/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.event.market;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.QDContract;
import com.devexperts.qd.ng.RecordCursor;
import com.dxfeed.api.impl.EventDelegateFlags;
import com.dxfeed.event.IndexedEventSource;
import com.dxfeed.event.market.Order;
import com.dxfeed.event.market.OrderBaseDelegateImpl;
import com.dxfeed.event.market.OrderSource;
import com.dxfeed.event.market.Scope;
import com.dxfeed.event.market.Side;
import com.dxfeed.event.market.impl.MarketMakerMapping;
import java.util.EnumSet;

public final class OrderByMarketMakerBidDelegate
extends OrderBaseDelegateImpl<Order> {
    private final MarketMakerMapping m;

    public OrderByMarketMakerBidDelegate(DataRecord record, QDContract contract, EnumSet<EventDelegateFlags> flags) {
        super(record, contract, flags);
        this.m = record.getMapping(MarketMakerMapping.class);
    }

    @Override
    public MarketMakerMapping getMapping() {
        return this.m;
    }

    @Override
    public Order createEvent() {
        return new Order();
    }

    @Override
    public Order getEvent(Order event, RecordCursor cursor) {
        super.getEvent(event, cursor);
        event.setEventFlags(cursor.getEventFlags());
        event.setIndex((long)this.getSource().id() << 48 | (long)this.m.getExchangeCode(cursor) << 32 | (long)this.m.getMarketMaker(cursor) & 0xFFFFFFFFL);
        event.setExchangeCode(this.m.getExchangeCode(cursor));
        event.setMarketMaker(this.m.getMarketMakerString(cursor));
        event.setTime(this.m.getBidTimeMillis(cursor));
        event.setSequence(0);
        event.setPrice(this.m.getBidPrice(cursor));
        event.setSizeAsDouble(this.m.getBidSizeDouble(cursor));
        event.setCount(this.m.getBidCount(cursor));
        event.setOrderSide(Side.BUY);
        event.setScope(Scope.AGGREGATE);
        return event;
    }

    @Override
    public IndexedEventSource getSource() {
        return OrderSource.AGGREGATE_BID;
    }
}

