/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.event.market;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.QDContract;
import com.devexperts.qd.ng.RecordCursor;
import com.dxfeed.api.impl.EventDelegateFlags;
import com.dxfeed.event.IndexedEventSource;
import com.dxfeed.event.market.Order;
import com.dxfeed.event.market.OrderBaseDelegateImpl;
import com.dxfeed.event.market.OrderSource;
import com.dxfeed.event.market.Scope;
import com.dxfeed.event.market.Side;
import com.dxfeed.event.market.impl.MarketMakerMapping;
import java.util.EnumSet;

public final class OrderByMarketMakerAskDelegate
extends OrderBaseDelegateImpl<Order> {
    private final MarketMakerMapping m;

    public OrderByMarketMakerAskDelegate(DataRecord record, QDContract contract, EnumSet<EventDelegateFlags> flags) {
        super(record, contract, flags);
        this.m = record.getMapping(MarketMakerMapping.class);
    }

    @Override
    public MarketMakerMapping getMapping() {
        return this.m;
    }

    @Override
    public Order createEvent() {
        return new Order();
    }

    @Override
    public Order getEvent(Order event, RecordCursor cursor) {
        super.getEvent(event, cursor);
        event.setEventFlags(cursor.getEventFlags());
        event.setIndex((long)this.getSource().id() << 48 | (long)this.m.getExchangeCode(cursor) << 32 | (long)this.m.getMarketMaker(cursor) & 0xFFFFFFFFL);
        event.setExchangeCode(this.m.getExchangeCode(cursor));
        event.setMarketMaker(this.m.getMarketMakerString(cursor));
        event.setTime(this.m.getAskTimeMillis(cursor));
        event.setSequence(0);
        event.setPrice(this.m.getAskPrice(cursor));
        event.setSizeAsDouble(this.m.getAskSizeDouble(cursor));
        event.setCount(this.m.getAskCount(cursor));
        event.setOrderSide(Side.SELL);
        event.setScope(Scope.AGGREGATE);
        return event;
    }

    @Override
    public IndexedEventSource getSource() {
        return OrderSource.AGGREGATE_ASK;
    }
}

