/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.event.market;

import com.devexperts.util.IndexedSet;
import com.devexperts.util.IndexerFunction;
import com.dxfeed.api.impl.EventDelegate;
import com.dxfeed.event.market.MarketEventDelegateSet;
import com.dxfeed.event.market.OrderBase;
import com.dxfeed.event.market.OrderBaseDelegateImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class OrderBaseDelegateSet<T extends OrderBase, D extends OrderBaseDelegateImpl<T>>
extends MarketEventDelegateSet<T, D> {
    private static final IndexerFunction.LongKey<List<? extends OrderBaseDelegateImpl<?>>> DELEGATE_LIST_BY_SOURCE_ID = value -> ((OrderBaseDelegateImpl)value.get(0)).getSource().id();
    private final IndexedSet<Long, List<D>> subDelegatesBySource = IndexedSet.createLong(DELEGATE_LIST_BY_SOURCE_ID);
    private final IndexedSet<Long, List<D>> pubDelegatesBySource = IndexedSet.createLong(DELEGATE_LIST_BY_SOURCE_ID);

    OrderBaseDelegateSet(Class<T> eventType) {
        super(eventType);
    }

    @Override
    public void add(D delegate) {
        if (((EventDelegate)delegate).isSub()) {
            OrderBaseDelegateSet.addToSet(this.subDelegatesBySource, delegate);
        }
        if (((EventDelegate)delegate).isPub()) {
            OrderBaseDelegateSet.addToSet(this.pubDelegatesBySource, delegate);
        }
        super.add(delegate);
    }

    @Override
    protected List<D> getRegularSubDelegatesBySubscriptionSymbol(Object symbol, int sourceId) {
        return sourceId >= 0 ? OrderBaseDelegateSet.getFromSet(this.subDelegatesBySource, sourceId) : super.getRegularSubDelegatesBySubscriptionSymbol(symbol, sourceId);
    }

    @Override
    public List<D> getPubDelegatesByEvent(T event) {
        return OrderBaseDelegateSet.getFromSet(this.pubDelegatesBySource, ((OrderBase)event).getSource().id());
    }

    private static <T extends OrderBase, D extends OrderBaseDelegateImpl<T>> void addToSet(IndexedSet<Long, List<D>> set, D delegate) {
        List<D> list = set.getByKey(delegate.getSource().id());
        if (list == null) {
            list = new ArrayList<D>(1);
            list.add(delegate);
            set.add(list);
        } else {
            list.add(delegate);
        }
    }

    private static <T extends OrderBase, D extends OrderBaseDelegateImpl<T>> List<D> getFromSet(IndexedSet<Long, List<D>> set, int sourceId) {
        List<D> list = set.getByKey(sourceId);
        return list == null ? Collections.emptyList() : list;
    }
}

