/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.event.market;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.QDContract;
import com.devexperts.qd.SerialFieldType;
import com.devexperts.qd.ng.RecordMapping;
import com.devexperts.qd.ng.RecordMappingFactory;
import com.devexperts.services.ServiceProvider;
import com.devexperts.util.SystemProperties;
import com.dxfeed.api.impl.EventDelegate;
import com.dxfeed.api.impl.EventDelegateFactory;
import com.dxfeed.api.impl.EventDelegateFlags;
import com.dxfeed.api.impl.SchemeBuilder;
import com.dxfeed.api.impl.SchemeFieldTime;
import com.dxfeed.event.market.AnalyticOrderDelegate;
import com.dxfeed.event.market.MarketEventSymbols;
import com.dxfeed.event.market.OrderByMarketMakerAskDelegate;
import com.dxfeed.event.market.OrderByMarketMakerBidDelegate;
import com.dxfeed.event.market.OrderByQuoteAskDelegate;
import com.dxfeed.event.market.OrderByQuoteBidDelegate;
import com.dxfeed.event.market.OrderDelegate;
import com.dxfeed.event.market.ProfileDelegate;
import com.dxfeed.event.market.QuoteDelegate;
import com.dxfeed.event.market.SpreadOrderDelegate;
import com.dxfeed.event.market.SummaryDelegate;
import com.dxfeed.event.market.TimeAndSaleDelegate;
import com.dxfeed.event.market.TradeDelegate;
import com.dxfeed.event.market.TradeETHDelegate;
import com.dxfeed.event.market.impl.AnalyticOrderMapping;
import com.dxfeed.event.market.impl.BookMapping;
import com.dxfeed.event.market.impl.FundamentalMapping;
import com.dxfeed.event.market.impl.MarketMakerMapping;
import com.dxfeed.event.market.impl.OrderMapping;
import com.dxfeed.event.market.impl.ProfileMapping;
import com.dxfeed.event.market.impl.QuoteMapping;
import com.dxfeed.event.market.impl.SpreadOrderMapping;
import com.dxfeed.event.market.impl.SummaryMapping;
import com.dxfeed.event.market.impl.TimeAndSaleMapping;
import com.dxfeed.event.market.impl.TradeETHMapping;
import com.dxfeed.event.market.impl.TradeMapping;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;

@ServiceProvider(order=-50)
public final class MarketFactoryImpl
extends EventDelegateFactory
implements RecordMappingFactory {
    @Override
    public void buildScheme(SchemeBuilder builder) {
        String recordName;
        builder.addOptionalField("Quote", "Sequence", SerialFieldType.SEQUENCE, "Quote", "Sequence", false);
        builder.addOptionalField("Quote", "TimeNanoPart", SerialFieldType.COMPACT_INT, "Quote", "TimeNanoPart", false);
        builder.addOptionalField("Quote", "Bid.Time", SerialFieldType.TIME_SECONDS, "Quote", "BidTime", true);
        builder.addOptionalField("Quote", "Bid.Exchange", SerialFieldType.UTF_CHAR, "Quote", "BidExchangeCode", true);
        builder.addRequiredField("Quote", "Bid.Price", this.select(SerialFieldType.DECIMAL, "dxscheme.price"));
        builder.addRequiredField("Quote", "Bid.Size", this.select(SerialFieldType.COMPACT_INT, "dxscheme.size"));
        builder.addOptionalField("Quote", "Ask.Time", SerialFieldType.TIME_SECONDS, "Quote", "AskTime", true);
        builder.addOptionalField("Quote", "Ask.Exchange", SerialFieldType.UTF_CHAR, "Quote", "AskExchangeCode", true);
        builder.addRequiredField("Quote", "Ask.Price", this.select(SerialFieldType.DECIMAL, "dxscheme.price"));
        builder.addRequiredField("Quote", "Ask.Size", this.select(SerialFieldType.COMPACT_INT, "dxscheme.size"));
        for (char exchange : SystemProperties.getProperty("com.dxfeed.event.market.impl.Quote.exchanges", "ABCDEFGHIJKLMNOPQRSTUVWXYZ").toCharArray()) {
            recordName = "Quote&" + exchange;
            builder.addOptionalField(recordName, "Sequence", SerialFieldType.SEQUENCE, "Quote", "Sequence", false);
            builder.addOptionalField(recordName, "TimeNanoPart", SerialFieldType.COMPACT_INT, "Quote", "TimeNanoPart", false);
            builder.addOptionalField(recordName, "Bid.Time", SerialFieldType.TIME_SECONDS, "Quote", "BidTime", true);
            builder.addRequiredField(recordName, "Bid.Price", this.select(SerialFieldType.DECIMAL, "dxscheme.price"));
            builder.addRequiredField(recordName, "Bid.Size", this.select(SerialFieldType.COMPACT_INT, "dxscheme.size"));
            builder.addOptionalField(recordName, "Ask.Time", SerialFieldType.TIME_SECONDS, "Quote", "AskTime", true);
            builder.addRequiredField(recordName, "Ask.Price", this.select(SerialFieldType.DECIMAL, "dxscheme.price"));
            builder.addRequiredField(recordName, "Ask.Size", this.select(SerialFieldType.COMPACT_INT, "dxscheme.size"));
        }
        if (SystemProperties.getBooleanProperty("reuters.phantom", false)) {
            builder.addRequiredField("Quote2", "Bid.Price", this.select(SerialFieldType.DECIMAL, new String[0]));
            builder.addRequiredField("Quote2", "Bid.Size", this.select(SerialFieldType.DECIMAL, new String[0]));
            builder.addRequiredField("Quote2", "Ask.Price", this.select(SerialFieldType.DECIMAL, new String[0]));
            builder.addRequiredField("Quote2", "Ask.Size", this.select(SerialFieldType.DECIMAL, new String[0]));
            builder.addRequiredField("Quote2", "Bid.Price.Timestamp", SerialFieldType.TIME_SECONDS);
            builder.addRequiredField("Quote2", "Bid.Size.Timestamp", SerialFieldType.TIME_SECONDS);
            builder.addRequiredField("Quote2", "Ask.Price.Timestamp", SerialFieldType.TIME_SECONDS);
            builder.addRequiredField("Quote2", "Ask.Size.Timestamp", SerialFieldType.TIME_SECONDS);
        }
        builder.addOptionalField("Trade", "Last.Time", SerialFieldType.TIME_SECONDS, "Trade", "Time", true);
        builder.addOptionalField("Trade", "Last.Sequence", SerialFieldType.SEQUENCE, "Trade", "Sequence", true);
        builder.addOptionalField("Trade", "Last.TimeNanoPart", SerialFieldType.COMPACT_INT, "Trade", "TimeNanoPart", false);
        builder.addOptionalField("Trade", "Last.Exchange", SerialFieldType.UTF_CHAR, "Trade", "ExchangeCode", true);
        builder.addRequiredField("Trade", "Last.Price", this.select(SerialFieldType.DECIMAL, "dxscheme.price"));
        builder.addRequiredField("Trade", "Last.Size", this.select(SerialFieldType.COMPACT_INT, "dxscheme.size"));
        builder.addOptionalField("Trade", "Last.Tick", SerialFieldType.COMPACT_INT, "Trade", "Tick", true);
        builder.addOptionalField("Trade", "Last.Change", this.select(SerialFieldType.DECIMAL, "dxscheme.price"), "Trade", "Change", true);
        builder.addOptionalField("Trade", "Volume", this.select(SerialFieldType.DECIMAL, "dxscheme.volume", "dxscheme.size"), "Trade", "DayVolume", true);
        builder.addOptionalField("Trade", "DayTurnover", this.select(SerialFieldType.DECIMAL, "dxscheme.turnover", "dxscheme.price"), "Trade", "DayTurnover", true);
        builder.addOptionalField("Trade", "Last.Flags", SerialFieldType.COMPACT_INT, "Trade", "Flags", true);
        if (SystemProperties.getBooleanProperty("reuters.phantom", false)) {
            builder.addRequiredField("Trade", "Date", SerialFieldType.COMPACT_INT);
            builder.addRequiredField("Trade", "Operation", SerialFieldType.COMPACT_INT);
        }
        for (char exchange : SystemProperties.getProperty("com.dxfeed.event.market.impl.Trade.exchanges", "ABCDEFGHIJKLMNOPQRSTUVWXYZ").toCharArray()) {
            recordName = "Trade&" + exchange;
            builder.addOptionalField(recordName, "Last.Time", SerialFieldType.TIME_SECONDS, "Trade", "Time", true);
            builder.addOptionalField(recordName, "Last.Sequence", SerialFieldType.SEQUENCE, "Trade", "Sequence", true);
            builder.addOptionalField(recordName, "Last.TimeNanoPart", SerialFieldType.COMPACT_INT, "Trade", "TimeNanoPart", false);
            builder.addRequiredField(recordName, "Last.Price", this.select(SerialFieldType.DECIMAL, "dxscheme.price"));
            builder.addRequiredField(recordName, "Last.Size", this.select(SerialFieldType.COMPACT_INT, "dxscheme.size"));
            builder.addOptionalField(recordName, "Last.Tick", SerialFieldType.COMPACT_INT, "Trade", "Tick", true);
            builder.addOptionalField(recordName, "Last.Change", this.select(SerialFieldType.DECIMAL, "dxscheme.price"), "Trade", "Change", true);
            builder.addOptionalField(recordName, "Volume", this.select(SerialFieldType.DECIMAL, "dxscheme.volume", "dxscheme.size"), "Trade", "DayVolume", true);
            builder.addOptionalField(recordName, "DayTurnover", this.select(SerialFieldType.DECIMAL, "dxscheme.turnover", "dxscheme.price"), "Trade", "DayTurnover", true);
            builder.addOptionalField(recordName, "Last.Flags", SerialFieldType.COMPACT_INT, "Trade", "Flags", true);
        }
        builder.addOptionalField("TradeETH", "ETHLast.Time", SerialFieldType.TIME_SECONDS, "TradeETH", "Time", true);
        builder.addOptionalField("TradeETH", "ETHLast.Sequence", SerialFieldType.SEQUENCE, "TradeETH", "Sequence", true);
        builder.addOptionalField("TradeETH", "Last.TimeNanoPart", SerialFieldType.COMPACT_INT, "TradeETH", "TimeNanoPart", false);
        builder.addOptionalField("TradeETH", "ETHLast.Exchange", SerialFieldType.UTF_CHAR, "TradeETH", "ExchangeCode", true);
        builder.addRequiredField("TradeETH", "ETHLast.Price", this.select(SerialFieldType.DECIMAL, "dxscheme.price"));
        builder.addRequiredField("TradeETH", "ETHLast.Size", this.select(SerialFieldType.COMPACT_INT, "dxscheme.size"));
        builder.addOptionalField("TradeETH", "ETHLast.Change", this.select(SerialFieldType.DECIMAL, "dxscheme.price"), "TradeETH", "Change", true);
        builder.addOptionalField("TradeETH", "ETHVolume", this.select(SerialFieldType.DECIMAL, "dxscheme.volume", "dxscheme.size"), "TradeETH", "DayVolume", true);
        builder.addOptionalField("TradeETH", "ETHDayTurnover", this.select(SerialFieldType.DECIMAL, "dxscheme.turnover", "dxscheme.price"), "TradeETH", "DayTurnover", true);
        builder.addRequiredField("TradeETH", "ETHLast.Flags", SerialFieldType.COMPACT_INT);
        for (char exchange : SystemProperties.getProperty("com.dxfeed.event.market.impl.TradeETH.exchanges", "ABCDEFGHIJKLMNOPQRSTUVWXYZ").toCharArray()) {
            recordName = "TradeETH&" + exchange;
            builder.addOptionalField(recordName, "ETHLast.Time", SerialFieldType.TIME_SECONDS, "TradeETH", "Time", true);
            builder.addOptionalField(recordName, "ETHLast.Sequence", SerialFieldType.SEQUENCE, "TradeETH", "Sequence", true);
            builder.addOptionalField(recordName, "Last.TimeNanoPart", SerialFieldType.COMPACT_INT, "TradeETH", "TimeNanoPart", false);
            builder.addRequiredField(recordName, "ETHLast.Price", this.select(SerialFieldType.DECIMAL, "dxscheme.price"));
            builder.addRequiredField(recordName, "ETHLast.Size", this.select(SerialFieldType.COMPACT_INT, "dxscheme.size"));
            builder.addOptionalField(recordName, "ETHLast.Change", this.select(SerialFieldType.DECIMAL, "dxscheme.price"), "TradeETH", "Change", true);
            builder.addOptionalField(recordName, "ETHVolume", this.select(SerialFieldType.DECIMAL, "dxscheme.volume", "dxscheme.size"), "TradeETH", "DayVolume", true);
            builder.addOptionalField(recordName, "ETHDayTurnover", this.select(SerialFieldType.DECIMAL, "dxscheme.turnover", "dxscheme.price"), "TradeETH", "DayTurnover", true);
            builder.addRequiredField(recordName, "ETHLast.Flags", SerialFieldType.COMPACT_INT);
        }
        builder.addRequiredField("Summary", "DayId", SerialFieldType.DATE);
        builder.addRequiredField("Summary", "DayOpen.Price", this.select(SerialFieldType.DECIMAL, "dxscheme.price"));
        builder.addRequiredField("Summary", "DayHigh.Price", this.select(SerialFieldType.DECIMAL, "dxscheme.price"));
        builder.addRequiredField("Summary", "DayLow.Price", this.select(SerialFieldType.DECIMAL, "dxscheme.price"));
        builder.addOptionalField("Summary", "DayClose.Price", this.select(SerialFieldType.DECIMAL, "dxscheme.price"), "Summary", "DayClosePrice", true);
        builder.addRequiredField("Summary", "PrevDayId", SerialFieldType.DATE);
        builder.addRequiredField("Summary", "PrevDayClose.Price", this.select(SerialFieldType.DECIMAL, "dxscheme.price"));
        builder.addOptionalField("Summary", "PrevDayVolume", this.select(SerialFieldType.DECIMAL, "dxscheme.volume", "dxscheme.size"), "Summary", "PrevDayVolume", true);
        builder.addOptionalField("Summary", "OpenInterest", this.select(SerialFieldType.COMPACT_INT, new String[0]), "Summary", "OpenInterest", true);
        builder.addOptionalField("Summary", "Flags", SerialFieldType.COMPACT_INT, "Summary", "Flags", true);
        for (char exchange : SystemProperties.getProperty("com.dxfeed.event.market.impl.Summary.exchanges", "ABCDEFGHIJKLMNOPQRSTUVWXYZ").toCharArray()) {
            recordName = "Summary&" + exchange;
            builder.addRequiredField(recordName, "DayId", SerialFieldType.DATE);
            builder.addRequiredField(recordName, "DayOpen.Price", this.select(SerialFieldType.DECIMAL, "dxscheme.price"));
            builder.addRequiredField(recordName, "DayHigh.Price", this.select(SerialFieldType.DECIMAL, "dxscheme.price"));
            builder.addRequiredField(recordName, "DayLow.Price", this.select(SerialFieldType.DECIMAL, "dxscheme.price"));
            builder.addOptionalField(recordName, "DayClose.Price", this.select(SerialFieldType.DECIMAL, "dxscheme.price"), "Summary", "DayClosePrice", true);
            builder.addRequiredField(recordName, "PrevDayId", SerialFieldType.DATE);
            builder.addRequiredField(recordName, "PrevDayClose.Price", this.select(SerialFieldType.DECIMAL, "dxscheme.price"));
            builder.addOptionalField(recordName, "PrevDayVolume", this.select(SerialFieldType.DECIMAL, "dxscheme.volume", "dxscheme.size"), "Summary", "PrevDayVolume", true);
            builder.addOptionalField(recordName, "Flags", SerialFieldType.COMPACT_INT, "Summary", "Flags", true);
        }
        builder.addRequiredField("Fundamental", "Open.Price", this.select(SerialFieldType.DECIMAL, "dxscheme.price"));
        builder.addRequiredField("Fundamental", "High.Price", this.select(SerialFieldType.DECIMAL, "dxscheme.price"));
        builder.addRequiredField("Fundamental", "Low.Price", this.select(SerialFieldType.DECIMAL, "dxscheme.price"));
        builder.addRequiredField("Fundamental", "Close.Price", this.select(SerialFieldType.DECIMAL, "dxscheme.price"));
        builder.addOptionalField("Fundamental", "OpenInterest", this.select(SerialFieldType.COMPACT_INT, new String[0]), "Summary", "OpenInterest", true);
        for (char exchange : SystemProperties.getProperty("com.dxfeed.event.market.impl.Fundamental.exchanges", "ABCDEFGHIJKLMNOPQRSTUVWXYZ").toCharArray()) {
            recordName = "Fundamental&" + exchange;
            builder.addRequiredField(recordName, "Open.Price", this.select(SerialFieldType.DECIMAL, "dxscheme.price"));
            builder.addRequiredField(recordName, "High.Price", this.select(SerialFieldType.DECIMAL, "dxscheme.price"));
            builder.addRequiredField(recordName, "Low.Price", this.select(SerialFieldType.DECIMAL, "dxscheme.price"));
            builder.addRequiredField(recordName, "Close.Price", this.select(SerialFieldType.DECIMAL, "dxscheme.price"));
        }
        for (char exchange : SystemProperties.getProperty("com.dxfeed.event.market.impl.Book.exchanges", "I").toCharArray()) {
            recordName = "Book&" + exchange;
            builder.addRequiredField(recordName, "ID", SerialFieldType.COMPACT_INT, SchemeFieldTime.FIRST_TIME_INT_FIELD);
            builder.addRequiredField(recordName, "Sequence", SerialFieldType.VOID, SchemeFieldTime.SECOND_TIME_INT_FIELD);
            builder.addRequiredField(recordName, "Time", SerialFieldType.TIME_SECONDS);
            builder.addRequiredField(recordName, "Type", SerialFieldType.UTF_CHAR);
            builder.addRequiredField(recordName, "Price", this.select(SerialFieldType.DECIMAL, "dxscheme.price"));
            builder.addRequiredField(recordName, "Size", this.select(SerialFieldType.COMPACT_INT, "dxscheme.size"));
            builder.addRequiredField(recordName, "TimeInForce", SerialFieldType.UTF_CHAR);
            builder.addRequiredField(recordName, "Symbol", SerialFieldType.UTF_CHAR_ARRAY);
        }
        builder.addOptionalField("Profile", "Beta", this.select(SerialFieldType.DECIMAL, new String[0]), "Profile", "Beta", true);
        builder.addOptionalField("Profile", "Eps", this.select(SerialFieldType.DECIMAL, new String[0]), "Profile", "Eps", true);
        builder.addOptionalField("Profile", "DivFreq", this.select(SerialFieldType.COMPACT_INT, new String[0]), "Profile", "DivFreq", true);
        builder.addOptionalField("Profile", "ExdDiv.Amount", this.select(SerialFieldType.DECIMAL, new String[0]), "Profile", "ExdDivAmount", true);
        builder.addOptionalField("Profile", "ExdDiv.Date", SerialFieldType.DATE, "Profile", "ExdDivDate", true);
        builder.addOptionalField("Profile", "52High.Price", this.select(SerialFieldType.DECIMAL, "dxscheme.price"), "Profile", "HighPrice52", true);
        builder.addOptionalField("Profile", "52Low.Price", this.select(SerialFieldType.DECIMAL, "dxscheme.price"), "Profile", "LowPrice52", true);
        builder.addOptionalField("Profile", "Shares", this.select(SerialFieldType.DECIMAL, new String[0]), "Profile", "Shares", true);
        builder.addOptionalField("Profile", "FreeFloat", this.select(SerialFieldType.DECIMAL, new String[0]), "Profile", "FreeFloat", true);
        builder.addOptionalField("Profile", "HighLimitPrice", this.select(SerialFieldType.DECIMAL, "dxscheme.price"), "Profile", "HighLimitPrice", true);
        builder.addOptionalField("Profile", "LowLimitPrice", this.select(SerialFieldType.DECIMAL, "dxscheme.price"), "Profile", "LowLimitPrice", true);
        builder.addOptionalField("Profile", "Halt.StartTime", SerialFieldType.TIME_SECONDS, "Profile", "HaltStartTime", true);
        builder.addOptionalField("Profile", "Halt.EndTime", SerialFieldType.TIME_SECONDS, "Profile", "HaltEndTime", true);
        builder.addOptionalField("Profile", "Flags", SerialFieldType.COMPACT_INT, "Profile", "Flags", true);
        builder.addRequiredField("Profile", "Description", SerialFieldType.UTF_CHAR_ARRAY);
        builder.addOptionalField("Profile", "StatusReason", SerialFieldType.UTF_CHAR_ARRAY, "Profile", "StatusReason", true);
        for (String suffix : SystemProperties.getProperty("com.dxfeed.event.market.impl.Order.suffixes", "|#NTV|#ntv|#NFX|#ESPD|#XNFI|#ICE|#ISE|#DEA|#DEX|#BYX|#BZX|#BATE|#CHIX|#CEUX|#BXTR|#IST|#BI20|#ABE|#FAIR|#GLBX|#glbx|#ERIS|#XEUR|#xeur|#CFE|#C2OX|#SMFE").split("\\|")) {
            recordName = "Order" + suffix;
            builder.addRequiredField(recordName, "Void", SerialFieldType.VOID, SchemeFieldTime.FIRST_TIME_INT_FIELD);
            builder.addRequiredField(recordName, "Index", SerialFieldType.COMPACT_INT, SchemeFieldTime.SECOND_TIME_INT_FIELD);
            builder.addRequiredField(recordName, "Time", SerialFieldType.TIME_SECONDS);
            builder.addRequiredField(recordName, "Sequence", SerialFieldType.SEQUENCE);
            builder.addOptionalField(recordName, "TimeNanoPart", SerialFieldType.COMPACT_INT, "Order", "TimeNanoPart", false);
            if (SystemProperties.getBooleanProperty("dxscheme.fob", false)) {
                if (suffix.matches(SystemProperties.getProperty("com.dxfeed.event.market.impl.Order.fob.suffixes", "|#NTV"))) {
                    builder.addOptionalField(recordName, "ActionTime", SerialFieldType.TIME_MILLIS, "Order", "ActionTime", true);
                }
                if (suffix.matches(SystemProperties.getProperty("com.dxfeed.event.market.impl.Order.fob.suffixes", "|#NTV"))) {
                    builder.addOptionalField(recordName, "OrderId", SerialFieldType.LONG, "Order", "OrderId", true);
                }
                if (suffix.matches(SystemProperties.getProperty("com.dxfeed.event.market.impl.Order.fob.suffixes", "|#NTV"))) {
                    builder.addOptionalField(recordName, "AuxOrderId", SerialFieldType.LONG, "Order", "AuxOrderId", true);
                }
            }
            builder.addRequiredField(recordName, "Price", this.select(SerialFieldType.DECIMAL, "dxscheme.price"));
            builder.addRequiredField(recordName, "Size", this.select(SerialFieldType.COMPACT_INT, "dxscheme.size"));
            builder.addOptionalField(recordName, "ExecutedSize", this.select(SerialFieldType.DECIMAL, new String[0]), "Order", "ExecutedSize", false);
            if (suffix.matches(SystemProperties.getProperty("com.dxfeed.event.order.impl.Order.suffixes.count", ""))) {
                builder.addOptionalField(recordName, "Count", this.select(SerialFieldType.COMPACT_INT, new String[0]), "Order", "Count", true);
            }
            builder.addRequiredField(recordName, "Flags", SerialFieldType.COMPACT_INT);
            if (SystemProperties.getBooleanProperty("dxscheme.fob", false)) {
                if (suffix.matches(SystemProperties.getProperty("com.dxfeed.event.market.impl.Order.fob.suffixes", "|#NTV"))) {
                    builder.addOptionalField(recordName, "TradeId", SerialFieldType.LONG, "Order", "TradeId", true);
                }
                if (suffix.matches(SystemProperties.getProperty("com.dxfeed.event.market.impl.Order.fob.suffixes", "|#NTV"))) {
                    builder.addOptionalField(recordName, "TradePrice", this.select(SerialFieldType.DECIMAL, new String[0]), "Order", "TradePrice", true);
                }
                if (suffix.matches(SystemProperties.getProperty("com.dxfeed.event.market.impl.Order.fob.suffixes", "|#NTV"))) {
                    builder.addOptionalField(recordName, "TradeSize", this.select(SerialFieldType.DECIMAL, new String[0]), "Order", "TradeSize", true);
                }
            }
            if (suffix.matches(SystemProperties.getProperty("com.dxfeed.event.order.impl.Order.suffixes.mmid", "|#NTV|#BATE|#CHIX|#CEUX|#BXTR"))) {
                builder.addOptionalField(recordName, "MMID", SerialFieldType.SHORT_STRING, "Order", "MarketMaker", true);
            }
            builder.addOptionalField(recordName, "IcebergPeakSize", this.select(SerialFieldType.DECIMAL, new String[0]), "Order", "IcebergPeakSize", false);
            builder.addOptionalField(recordName, "IcebergHiddenSize", this.select(SerialFieldType.DECIMAL, new String[0]), "Order", "IcebergHiddenSize", false);
            builder.addOptionalField(recordName, "IcebergExecutedSize", this.select(SerialFieldType.DECIMAL, new String[0]), "Order", "IcebergExecutedSize", false);
            builder.addOptionalField(recordName, "IcebergFlags", SerialFieldType.COMPACT_INT, "Order", "IcebergFlags", false);
        }
        for (String suffix : SystemProperties.getProperty("com.dxfeed.event.market.impl.AnalyticOrder.suffixes", "|#GLBX").split("\\|")) {
            recordName = "AnalyticOrder" + suffix;
            builder.addRequiredField(recordName, "Void", SerialFieldType.VOID, SchemeFieldTime.FIRST_TIME_INT_FIELD);
            builder.addRequiredField(recordName, "Index", SerialFieldType.COMPACT_INT, SchemeFieldTime.SECOND_TIME_INT_FIELD);
            builder.addRequiredField(recordName, "Time", SerialFieldType.TIME_SECONDS);
            builder.addRequiredField(recordName, "Sequence", SerialFieldType.SEQUENCE);
            builder.addOptionalField(recordName, "TimeNanoPart", SerialFieldType.COMPACT_INT, "AnalyticOrder", "TimeNanoPart", false);
            if (SystemProperties.getBooleanProperty("dxscheme.fob", false)) {
                if (suffix.matches(SystemProperties.getProperty("com.dxfeed.event.market.impl.Order.fob.suffixes", "|#NTV"))) {
                    builder.addOptionalField(recordName, "ActionTime", SerialFieldType.TIME_MILLIS, "AnalyticOrder", "ActionTime", true);
                }
                if (suffix.matches(SystemProperties.getProperty("com.dxfeed.event.market.impl.Order.fob.suffixes", "|#NTV"))) {
                    builder.addOptionalField(recordName, "OrderId", SerialFieldType.LONG, "AnalyticOrder", "OrderId", true);
                }
                if (suffix.matches(SystemProperties.getProperty("com.dxfeed.event.market.impl.Order.fob.suffixes", "|#NTV"))) {
                    builder.addOptionalField(recordName, "AuxOrderId", SerialFieldType.LONG, "AnalyticOrder", "AuxOrderId", true);
                }
            }
            builder.addRequiredField(recordName, "Price", this.select(SerialFieldType.DECIMAL, "dxscheme.price"));
            builder.addRequiredField(recordName, "Size", this.select(SerialFieldType.COMPACT_INT, "dxscheme.size"));
            builder.addOptionalField(recordName, "ExecutedSize", this.select(SerialFieldType.DECIMAL, new String[0]), "AnalyticOrder", "ExecutedSize", false);
            if (suffix.matches(SystemProperties.getProperty("com.dxfeed.event.order.impl.AnalyticOrder.suffixes.count", ""))) {
                builder.addOptionalField(recordName, "Count", this.select(SerialFieldType.COMPACT_INT, new String[0]), "AnalyticOrder", "Count", true);
            }
            builder.addRequiredField(recordName, "Flags", SerialFieldType.COMPACT_INT);
            if (SystemProperties.getBooleanProperty("dxscheme.fob", false)) {
                if (suffix.matches(SystemProperties.getProperty("com.dxfeed.event.market.impl.Order.fob.suffixes", "|#NTV"))) {
                    builder.addOptionalField(recordName, "TradeId", SerialFieldType.LONG, "AnalyticOrder", "TradeId", true);
                }
                if (suffix.matches(SystemProperties.getProperty("com.dxfeed.event.market.impl.Order.fob.suffixes", "|#NTV"))) {
                    builder.addOptionalField(recordName, "TradePrice", this.select(SerialFieldType.DECIMAL, new String[0]), "AnalyticOrder", "TradePrice", true);
                }
                if (suffix.matches(SystemProperties.getProperty("com.dxfeed.event.market.impl.Order.fob.suffixes", "|#NTV"))) {
                    builder.addOptionalField(recordName, "TradeSize", this.select(SerialFieldType.DECIMAL, new String[0]), "AnalyticOrder", "TradeSize", true);
                }
            }
            if (suffix.matches(SystemProperties.getProperty("com.dxfeed.event.order.impl.AnalyticOrder.suffixes.mmid", "|#NTV|#BATE|#CHIX|#CEUX|#BXTR"))) {
                builder.addOptionalField(recordName, "MMID", SerialFieldType.SHORT_STRING, "AnalyticOrder", "MarketMaker", true);
            }
            builder.addOptionalField(recordName, "IcebergPeakSize", this.select(SerialFieldType.DECIMAL, new String[0]), "AnalyticOrder", "IcebergPeakSize", false);
            builder.addOptionalField(recordName, "IcebergHiddenSize", this.select(SerialFieldType.DECIMAL, new String[0]), "AnalyticOrder", "IcebergHiddenSize", false);
            builder.addOptionalField(recordName, "IcebergExecutedSize", this.select(SerialFieldType.DECIMAL, new String[0]), "AnalyticOrder", "IcebergExecutedSize", false);
            builder.addOptionalField(recordName, "IcebergFlags", SerialFieldType.COMPACT_INT, "AnalyticOrder", "IcebergFlags", false);
        }
        for (String suffix : SystemProperties.getProperty("com.dxfeed.event.market.impl.SpreadOrder.suffixes", "|#ISE").split("\\|")) {
            recordName = "SpreadOrder" + suffix;
            builder.addRequiredField(recordName, "Void", SerialFieldType.VOID, SchemeFieldTime.FIRST_TIME_INT_FIELD);
            builder.addRequiredField(recordName, "Index", SerialFieldType.COMPACT_INT, SchemeFieldTime.SECOND_TIME_INT_FIELD);
            builder.addRequiredField(recordName, "Time", SerialFieldType.TIME_SECONDS);
            builder.addRequiredField(recordName, "Sequence", SerialFieldType.SEQUENCE);
            builder.addOptionalField(recordName, "TimeNanoPart", SerialFieldType.COMPACT_INT, "SpreadOrder", "TimeNanoPart", false);
            if (SystemProperties.getBooleanProperty("dxscheme.fob", false)) {
                if (suffix.matches(SystemProperties.getProperty("com.dxfeed.event.market.impl.Order.fob.suffixes", "|#NTV"))) {
                    builder.addOptionalField(recordName, "ActionTime", SerialFieldType.TIME_MILLIS, "SpreadOrder", "ActionTime", true);
                }
                if (suffix.matches(SystemProperties.getProperty("com.dxfeed.event.market.impl.Order.fob.suffixes", "|#NTV"))) {
                    builder.addOptionalField(recordName, "OrderId", SerialFieldType.LONG, "SpreadOrder", "OrderId", true);
                }
                if (suffix.matches(SystemProperties.getProperty("com.dxfeed.event.market.impl.Order.fob.suffixes", "|#NTV"))) {
                    builder.addOptionalField(recordName, "AuxOrderId", SerialFieldType.LONG, "SpreadOrder", "AuxOrderId", true);
                }
            }
            builder.addRequiredField(recordName, "Price", this.select(SerialFieldType.DECIMAL, "dxscheme.price"));
            builder.addRequiredField(recordName, "Size", this.select(SerialFieldType.COMPACT_INT, "dxscheme.size"));
            builder.addOptionalField(recordName, "ExecutedSize", this.select(SerialFieldType.DECIMAL, new String[0]), "SpreadOrder", "ExecutedSize", false);
            if (suffix.matches(SystemProperties.getProperty("com.dxfeed.event.order.impl.SpreadOrder.suffixes.count", ""))) {
                builder.addOptionalField(recordName, "Count", this.select(SerialFieldType.COMPACT_INT, new String[0]), "SpreadOrder", "Count", true);
            }
            builder.addRequiredField(recordName, "Flags", SerialFieldType.COMPACT_INT);
            if (SystemProperties.getBooleanProperty("dxscheme.fob", false)) {
                if (suffix.matches(SystemProperties.getProperty("com.dxfeed.event.market.impl.Order.fob.suffixes", "|#NTV"))) {
                    builder.addOptionalField(recordName, "TradeId", SerialFieldType.LONG, "SpreadOrder", "TradeId", true);
                }
                if (suffix.matches(SystemProperties.getProperty("com.dxfeed.event.market.impl.Order.fob.suffixes", "|#NTV"))) {
                    builder.addOptionalField(recordName, "TradePrice", this.select(SerialFieldType.DECIMAL, new String[0]), "SpreadOrder", "TradePrice", true);
                }
                if (suffix.matches(SystemProperties.getProperty("com.dxfeed.event.market.impl.Order.fob.suffixes", "|#NTV"))) {
                    builder.addOptionalField(recordName, "TradeSize", this.select(SerialFieldType.DECIMAL, new String[0]), "SpreadOrder", "TradeSize", true);
                }
            }
            builder.addRequiredField(recordName, "SpreadSymbol", SerialFieldType.UTF_CHAR_ARRAY);
        }
        builder.addRequiredField("MarketMaker", "MMExchange", SerialFieldType.UTF_CHAR, SchemeFieldTime.FIRST_TIME_INT_FIELD);
        builder.addRequiredField("MarketMaker", "MMID", SerialFieldType.SHORT_STRING, SchemeFieldTime.SECOND_TIME_INT_FIELD);
        builder.addOptionalField("MarketMaker", "MMBid.Time", SerialFieldType.TIME_SECONDS, "Order", "BidTime", true);
        builder.addRequiredField("MarketMaker", "MMBid.Price", this.select(SerialFieldType.DECIMAL, "dxscheme.price"));
        builder.addRequiredField("MarketMaker", "MMBid.Size", this.select(SerialFieldType.COMPACT_INT, "dxscheme.size"));
        builder.addOptionalField("MarketMaker", "MMBid.Count", this.select(SerialFieldType.COMPACT_INT, new String[0]), "Order", "BidCount", true);
        builder.addOptionalField("MarketMaker", "MMAsk.Time", SerialFieldType.TIME_SECONDS, "Order", "AskTime", true);
        builder.addRequiredField("MarketMaker", "MMAsk.Price", this.select(SerialFieldType.DECIMAL, "dxscheme.price"));
        builder.addRequiredField("MarketMaker", "MMAsk.Size", this.select(SerialFieldType.COMPACT_INT, "dxscheme.size"));
        builder.addOptionalField("MarketMaker", "MMAsk.Count", this.select(SerialFieldType.COMPACT_INT, new String[0]), "Order", "AskCount", true);
        builder.addRequiredField("TimeAndSale", "Time", SerialFieldType.TIME_SECONDS, SchemeFieldTime.FIRST_TIME_INT_FIELD);
        builder.addRequiredField("TimeAndSale", "Sequence", SerialFieldType.SEQUENCE, SchemeFieldTime.SECOND_TIME_INT_FIELD);
        builder.addOptionalField("TimeAndSale", "TimeNanoPart", SerialFieldType.COMPACT_INT, "TimeAndSale", "TimeNanoPart", false);
        builder.addRequiredField("TimeAndSale", "Exchange", SerialFieldType.UTF_CHAR);
        builder.addRequiredField("TimeAndSale", "Price", this.select(SerialFieldType.DECIMAL, "dxscheme.price"));
        builder.addRequiredField("TimeAndSale", "Size", this.select(SerialFieldType.COMPACT_INT, "dxscheme.size"));
        builder.addRequiredField("TimeAndSale", "Bid.Price", this.select(SerialFieldType.DECIMAL, "dxscheme.price"));
        builder.addRequiredField("TimeAndSale", "Ask.Price", this.select(SerialFieldType.DECIMAL, "dxscheme.price"));
        builder.addRequiredField("TimeAndSale", "ExchangeSaleConditions", SerialFieldType.SHORT_STRING);
        builder.addRequiredField("TimeAndSale", "Flags", SerialFieldType.COMPACT_INT);
        builder.addOptionalField("TimeAndSale", "Buyer", SerialFieldType.UTF_CHAR_ARRAY, "TimeAndSale", "Buyer", false);
        builder.addOptionalField("TimeAndSale", "Seller", SerialFieldType.UTF_CHAR_ARRAY, "TimeAndSale", "Seller", false);
        for (char exchange : SystemProperties.getProperty("com.dxfeed.event.market.impl.TimeAndSale.exchanges", "ABCDEFGHIJKLMNOPQRSTUVWXYZ").toCharArray()) {
            recordName = "TimeAndSale&" + exchange;
            builder.addRequiredField(recordName, "Time", SerialFieldType.TIME_SECONDS, SchemeFieldTime.FIRST_TIME_INT_FIELD);
            builder.addRequiredField(recordName, "Sequence", SerialFieldType.SEQUENCE, SchemeFieldTime.SECOND_TIME_INT_FIELD);
            builder.addOptionalField(recordName, "TimeNanoPart", SerialFieldType.COMPACT_INT, "TimeAndSale", "TimeNanoPart", false);
            builder.addRequiredField(recordName, "Exchange", SerialFieldType.UTF_CHAR);
            builder.addRequiredField(recordName, "Price", this.select(SerialFieldType.DECIMAL, "dxscheme.price"));
            builder.addRequiredField(recordName, "Size", this.select(SerialFieldType.COMPACT_INT, "dxscheme.size"));
            builder.addRequiredField(recordName, "Bid.Price", this.select(SerialFieldType.DECIMAL, "dxscheme.price"));
            builder.addRequiredField(recordName, "Ask.Price", this.select(SerialFieldType.DECIMAL, "dxscheme.price"));
            builder.addRequiredField(recordName, "ExchangeSaleConditions", SerialFieldType.SHORT_STRING);
            builder.addRequiredField(recordName, "Flags", SerialFieldType.COMPACT_INT);
            builder.addOptionalField(recordName, "Buyer", SerialFieldType.UTF_CHAR_ARRAY, "TimeAndSale", "Buyer", false);
            builder.addOptionalField(recordName, "Seller", SerialFieldType.UTF_CHAR_ARRAY, "TimeAndSale", "Seller", false);
        }
    }

    @Override
    public Collection<EventDelegate<?>> createDelegates(DataRecord record) {
        ArrayList result = new ArrayList();
        if (record.getMapping(QuoteMapping.class) != null) {
            result.add(new QuoteDelegate(record, QDContract.TICKER, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB)));
            result.add(new QuoteDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.PUB, EventDelegateFlags.WILDCARD)));
            result.add(new OrderByQuoteBidDelegate(record, QDContract.TICKER, EnumSet.of(EventDelegateFlags.SUB)));
            result.add(new OrderByQuoteBidDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.WILDCARD)));
            result.add(new OrderByQuoteAskDelegate(record, QDContract.TICKER, EnumSet.of(EventDelegateFlags.SUB)));
            result.add(new OrderByQuoteAskDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.WILDCARD)));
        } else if (record.getMapping(TradeMapping.class) != null) {
            result.add(new TradeDelegate(record, QDContract.TICKER, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB)));
            result.add(new TradeDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.PUB, EventDelegateFlags.WILDCARD)));
        } else if (record.getMapping(TradeETHMapping.class) != null) {
            result.add(new TradeETHDelegate(record, QDContract.TICKER, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB)));
            result.add(new TradeETHDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.PUB, EventDelegateFlags.WILDCARD)));
        } else if (record.getMapping(SummaryMapping.class) != null) {
            result.add(new SummaryDelegate(record, QDContract.TICKER, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB)));
            result.add(new SummaryDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.PUB, EventDelegateFlags.WILDCARD)));
        } else if (record.getMapping(ProfileMapping.class) != null) {
            result.add(new ProfileDelegate(record, QDContract.TICKER, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB)));
            result.add(new ProfileDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.PUB, EventDelegateFlags.WILDCARD)));
        } else if (record.getMapping(OrderMapping.class) != null) {
            result.add(new OrderDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.PUB, EventDelegateFlags.WILDCARD)));
            result.add(new OrderDelegate(record, QDContract.HISTORY, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB)));
        } else if (record.getMapping(AnalyticOrderMapping.class) != null) {
            result.add(new AnalyticOrderDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.PUB, EventDelegateFlags.WILDCARD)));
            result.add(new AnalyticOrderDelegate(record, QDContract.HISTORY, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB)));
        } else if (record.getMapping(SpreadOrderMapping.class) != null) {
            result.add(new SpreadOrderDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.PUB, EventDelegateFlags.WILDCARD)));
            result.add(new SpreadOrderDelegate(record, QDContract.HISTORY, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB)));
        } else if (record.getMapping(MarketMakerMapping.class) != null) {
            result.add(new OrderByMarketMakerBidDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.WILDCARD)));
            result.add(new OrderByMarketMakerBidDelegate(record, QDContract.HISTORY, EnumSet.of(EventDelegateFlags.SUB)));
            result.add(new OrderByMarketMakerAskDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.WILDCARD)));
            result.add(new OrderByMarketMakerAskDelegate(record, QDContract.HISTORY, EnumSet.of(EventDelegateFlags.SUB)));
        } else if (record.getMapping(TimeAndSaleMapping.class) != null) {
            result.add(new TimeAndSaleDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB, EventDelegateFlags.WILDCARD)));
            result.add(new TimeAndSaleDelegate(record, QDContract.HISTORY, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB, EventDelegateFlags.TIME_SERIES)));
        }
        return result;
    }

    @Override
    public Collection<EventDelegate<?>> createStreamOnlyDelegates(DataRecord record) {
        ArrayList result = new ArrayList();
        if (record.getMapping(QuoteMapping.class) != null) {
            result.add(new QuoteDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB, EventDelegateFlags.WILDCARD)));
            result.add(new OrderByQuoteBidDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.WILDCARD)));
            result.add(new OrderByQuoteAskDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.WILDCARD)));
        } else if (record.getMapping(TradeMapping.class) != null) {
            result.add(new TradeDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB, EventDelegateFlags.WILDCARD)));
        } else if (record.getMapping(TradeETHMapping.class) != null) {
            result.add(new TradeETHDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB, EventDelegateFlags.WILDCARD)));
        } else if (record.getMapping(SummaryMapping.class) != null) {
            result.add(new SummaryDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB, EventDelegateFlags.WILDCARD)));
        } else if (record.getMapping(ProfileMapping.class) != null) {
            result.add(new ProfileDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB, EventDelegateFlags.WILDCARD)));
        } else if (record.getMapping(OrderMapping.class) != null) {
            result.add(new OrderDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB, EventDelegateFlags.WILDCARD)));
        } else if (record.getMapping(AnalyticOrderMapping.class) != null) {
            result.add(new AnalyticOrderDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB, EventDelegateFlags.WILDCARD)));
        } else if (record.getMapping(SpreadOrderMapping.class) != null) {
            result.add(new SpreadOrderDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB, EventDelegateFlags.WILDCARD)));
        } else if (record.getMapping(MarketMakerMapping.class) != null) {
            result.add(new OrderByMarketMakerBidDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.WILDCARD)));
            result.add(new OrderByMarketMakerAskDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.WILDCARD)));
        } else if (record.getMapping(TimeAndSaleMapping.class) != null) {
            result.add(new TimeAndSaleDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB, EventDelegateFlags.WILDCARD)));
        }
        return result;
    }

    @Override
    public RecordMapping createMapping(DataRecord record) {
        String baseRecordName = this.getBaseRecordName(record.getName());
        if (baseRecordName.equals("Quote")) {
            return new QuoteMapping(record);
        }
        if (baseRecordName.equals("Trade")) {
            return new TradeMapping(record);
        }
        if (baseRecordName.equals("TradeETH")) {
            return new TradeETHMapping(record);
        }
        if (baseRecordName.equals("Summary")) {
            return new SummaryMapping(record);
        }
        if (baseRecordName.equals("Fundamental")) {
            return new FundamentalMapping(record);
        }
        if (baseRecordName.equals("Book")) {
            return new BookMapping(record);
        }
        if (baseRecordName.equals("Profile")) {
            return new ProfileMapping(record);
        }
        if (baseRecordName.equals("Order")) {
            return new OrderMapping(record);
        }
        if (baseRecordName.equals("AnalyticOrder")) {
            return new AnalyticOrderMapping(record);
        }
        if (baseRecordName.equals("SpreadOrder")) {
            return new SpreadOrderMapping(record);
        }
        if (baseRecordName.equals("MarketMaker")) {
            return new MarketMakerMapping(record);
        }
        if (baseRecordName.equals("TimeAndSale")) {
            return new TimeAndSaleMapping(record);
        }
        return null;
    }

    @Override
    protected String getBaseRecordName(String recordName) {
        String s = MarketEventSymbols.getBaseSymbol(recordName);
        int i = s.lastIndexOf(35);
        return i < 0 ? s : s.substring(0, i);
    }
}

