/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.event.market;

import com.dxfeed.api.impl.EventDelegate;
import com.dxfeed.api.impl.EventDelegateSet;
import com.dxfeed.event.market.MarketEvent;
import com.dxfeed.event.market.MarketEventDelegateImpl;
import com.dxfeed.event.market.MarketEventSymbols;
import java.util.ArrayList;
import java.util.List;

class MarketEventDelegateSet<T extends MarketEvent, D extends MarketEventDelegateImpl<T>>
extends EventDelegateSet<T, D> {
    private final List<List<D>> timeSeriesDelegatesByExchangeCode = MarketEventDelegateSet.newListOfLists();
    private final List<List<D>> subDelegatesByExchangeCode = MarketEventDelegateSet.newListOfLists();
    private final List<List<D>> pubDelegatesByExchangeCode = MarketEventDelegateSet.newListOfLists();
    private final List<D> lastingDelegateByExchangeCode = new ArrayList<D>();

    MarketEventDelegateSet(Class<T> eventType) {
        super(eventType);
    }

    @Override
    public void add(D delegate) {
        if (((EventDelegate)delegate).isSub()) {
            if (((EventDelegate)delegate).isTimeSeries()) {
                MarketEventDelegateSet.addToListOfLists(this.timeSeriesDelegatesByExchangeCode, delegate);
            } else {
                MarketEventDelegateSet.addToListOfLists(this.subDelegatesByExchangeCode, delegate);
            }
            if (((EventDelegate)delegate).isLastingEvent()) {
                MarketEventDelegateSet.addToList(this.lastingDelegateByExchangeCode, delegate);
            }
        }
        if (((EventDelegate)delegate).isPub()) {
            MarketEventDelegateSet.addToListOfLists(this.pubDelegatesByExchangeCode, delegate);
        }
        super.add(delegate);
    }

    @Override
    protected List<D> getRegularSubDelegatesBySubscriptionSymbol(Object symbol, int sourceId) {
        return MarketEventDelegateSet.getFromList(this.subDelegatesByExchangeCode, (String)symbol);
    }

    @Override
    public List<D> getTimeSeriesDelegatesByEventSymbol(Object symbol) {
        return MarketEventDelegateSet.getFromList(this.timeSeriesDelegatesByExchangeCode, (String)symbol);
    }

    @Override
    public D getLastingDelegateByEventSymbol(Object symbol) {
        return (D)((MarketEventDelegateImpl)MarketEventDelegateSet.getFromList(this.lastingDelegateByExchangeCode, (String)symbol));
    }

    @Override
    public List<D> getPubDelegatesByEvent(T event) {
        return MarketEventDelegateSet.getFromList(this.pubDelegatesByExchangeCode, ((MarketEvent)event).getEventSymbol());
    }

    private static <D extends MarketEventDelegateImpl<?>> List<List<D>> newListOfLists() {
        ArrayList<List<D>> result = new ArrayList<List<D>>();
        result.add(new ArrayList(1));
        return result;
    }

    private static <T extends MarketEvent, D extends MarketEventDelegateImpl<T>> void addToListOfLists(List<List<D>> list, D delegate) {
        char exchangeCode = delegate.getExchangeCode();
        while (list.size() <= exchangeCode) {
            list.add(null);
        }
        if (list.get(exchangeCode) == null) {
            list.set(exchangeCode, new ArrayList(1));
        }
        list.get(exchangeCode).add(delegate);
    }

    private static <T extends MarketEvent, D extends MarketEventDelegateImpl<T>> void addToList(List<D> list, D delegate) {
        char exchangeCode = delegate.getExchangeCode();
        while (list.size() <= exchangeCode) {
            list.add(null);
        }
        if (list.set(exchangeCode, delegate) != null) {
            throw new IllegalArgumentException("only one delegate of this type is supported " + delegate);
        }
    }

    private static <T> T getFromList(List<T> list, String eventSymbol) {
        char exchangeCode = MarketEventSymbols.getExchangeCode(eventSymbol);
        T result = null;
        if (exchangeCode < list.size()) {
            result = list.get(exchangeCode);
        }
        if (result == null) {
            result = list.get(0);
        }
        return result;
    }
}

