/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.event.market;

import com.dxfeed.event.market.AnalyticOrder;
import com.dxfeed.event.market.Direction;
import com.dxfeed.event.market.IcebergType;
import com.dxfeed.event.market.OrderBase;
import com.dxfeed.event.market.PriceType;
import com.dxfeed.event.market.Profile;
import com.dxfeed.event.market.Scope;
import com.dxfeed.event.market.ShortSaleRestriction;
import com.dxfeed.event.market.Side;
import com.dxfeed.event.market.Summary;
import com.dxfeed.event.market.TimeAndSale;
import com.dxfeed.event.market.TimeAndSaleType;
import com.dxfeed.event.market.TradeBase;
import com.dxfeed.event.market.TradingStatus;
import com.dxfeed.event.market.Util;

public class MarketAccessorImpl {
    private MarketAccessorImpl() {
    }

    public static int getOrderFlags(OrderBase order) {
        return order.getFlags();
    }

    public static void setOrderFlags(OrderBase order, int flags) {
        order.setFlags(flags);
    }

    public static int orderExchange(char exchangeCode) {
        Util.checkChar(exchangeCode, 127, "exchangeCode");
        return exchangeCode << 4;
    }

    public static char getOrderExchange(int flags) {
        return (char)Util.getBits(flags, 127, 4);
    }

    public static int setOrderExchange(int flags, char exchangeCode) {
        Util.checkChar(exchangeCode, 127, "exchangeCode");
        return Util.setBits(flags, 127, 4, exchangeCode);
    }

    public static int orderSide(Side side) {
        return side.getCode() << 2;
    }

    public static Side getOrderSide(int flags) {
        return Side.valueOf(Util.getBits(flags, 3, 2));
    }

    public static int setOrderSide(int flags, Side side) {
        return Util.setBits(flags, 3, 2, side.getCode());
    }

    public static int orderScope(Scope scope) {
        return scope.getCode() << 0;
    }

    public static Scope getOrderScope(int flags) {
        return Scope.valueOf(Util.getBits(flags, 3, 0));
    }

    @Deprecated
    public static int setScope(int flags, Scope scope) {
        return Util.setBits(flags, 3, 0, scope.getCode());
    }

    public static int setOrderScope(int flags, Scope scope) {
        return Util.setBits(flags, 3, 0, scope.getCode());
    }

    public static int getIcebergFlags(AnalyticOrder order) {
        return order.getIcebergFlags();
    }

    public static void setIcebergFlags(AnalyticOrder order, int icebergFlags) {
        order.setIcebergFlags(icebergFlags);
    }

    public static int orderIcebergType(IcebergType type) {
        return type.getCode() << 0;
    }

    public static IcebergType getOrderIcebergType(int flags) {
        return IcebergType.valueOf(Util.getBits(flags, 3, 0));
    }

    public static int setOrderIcebergType(int flags, IcebergType type) {
        return Util.setBits(flags, 3, 0, type.getCode());
    }

    public static int getProfileFlags(Profile profile) {
        return profile.getFlags();
    }

    public static void setProfileFlags(Profile profile, int flags) {
        profile.setFlags(flags);
    }

    public static int profileShortSaleRestriction(ShortSaleRestriction restriction) {
        return restriction.getCode() << 2;
    }

    public static ShortSaleRestriction getProfileShortSaleRestriction(int flags) {
        return ShortSaleRestriction.valueOf(Util.getBits(flags, 3, 2));
    }

    public static int setProfileShortSaleRestriction(int flags, ShortSaleRestriction restriction) {
        return Util.setBits(flags, 3, 2, restriction.getCode());
    }

    public static int profileTradingStatus(TradingStatus status) {
        return status.getCode() << 0;
    }

    public static TradingStatus getProfileTradingStatus(int flags) {
        return TradingStatus.valueOf(Util.getBits(flags, 3, 0));
    }

    public static int setProfileTradingStatus(int flags, TradingStatus status) {
        return Util.setBits(flags, 3, 0, status.getCode());
    }

    public static int getSummaryFlags(Summary summary) {
        return summary.getFlags();
    }

    public static void setSummaryFlags(Summary summary, int flags) {
        summary.setFlags(flags);
    }

    public static int summaryCloseType(PriceType type) {
        return type.getCode() << 2;
    }

    public static PriceType getSummaryCloseType(int flags) {
        return PriceType.valueOf(Util.getBits(flags, 3, 2));
    }

    public static int setSummaryCloseType(int flags, PriceType type) {
        return Util.setBits(flags, 3, 2, type.getCode());
    }

    public static int summaryPrevCloseType(PriceType type) {
        return type.getCode() << 0;
    }

    public static PriceType getSummaryPrevCloseType(int flags) {
        return PriceType.valueOf(Util.getBits(flags, 3, 0));
    }

    public static int setSummaryPrevCloseType(int flags, PriceType type) {
        return Util.setBits(flags, 3, 0, type.getCode());
    }

    public static int getTnsFlags(TimeAndSale tns) {
        return tns.getFlags();
    }

    public static void setTnsFlags(TimeAndSale tns, int flags) {
        tns.setFlags(flags);
    }

    public static int tnsTradeThroughExempt(char tradeThroughExempt) {
        Util.checkChar(tradeThroughExempt, 255, "tradeThroughExempt");
        return tradeThroughExempt << 8;
    }

    public static char getTnsTradeThroughExempt(int flags) {
        return (char)Util.getBits(flags, 255, 8);
    }

    public static int setTnsTradeThroughExempt(int flags, char tradeThroughExempt) {
        Util.checkChar(tradeThroughExempt, 255, "tradeThroughExempt");
        return Util.setBits(flags, 255, 8, tradeThroughExempt);
    }

    public static int tnsAggressorSide(Side side) {
        return side.getCode() << 5;
    }

    public static Side getTnsAggressorSide(int flags) {
        return Side.valueOf(Util.getBits(flags, 3, 5));
    }

    public static int setTnsAggressorSide(int flags, Side side) {
        return Util.setBits(flags, 3, 5, side.getCode());
    }

    public static int tnsSpreadLeg(boolean spreadLeg) {
        return spreadLeg ? 16 : 0;
    }

    public static boolean isTnsSpreadLeg(int flags) {
        return (flags & 0x10) != 0;
    }

    public static int setTnsSpreadLeg(int flags, boolean spreadLeg) {
        return spreadLeg ? flags | 0x10 : flags & 0xFFFFFFEF;
    }

    public static int tnsExtendedTradingHours(boolean extendedTradingHours) {
        return extendedTradingHours ? 8 : 0;
    }

    public static boolean isTnsExtendedTradingHours(int flags) {
        return (flags & 8) != 0;
    }

    public static int setTnsExtendedTradingHours(int flags, boolean extendedTradingHours) {
        return extendedTradingHours ? flags | 8 : flags & 0xFFFFFFF7;
    }

    public static int tnsValidTick(boolean validTick) {
        return validTick ? 4 : 0;
    }

    public static boolean isTnsValidTick(int flags) {
        return (flags & 4) != 0;
    }

    public static int setTnsValidTick(int flags, boolean validTick) {
        return validTick ? flags | 4 : flags & 0xFFFFFFFB;
    }

    public static int tnsType(TimeAndSaleType type) {
        return type.getCode() << 0;
    }

    public static TimeAndSaleType getTnsType(int flags) {
        return TimeAndSaleType.valueOf(Util.getBits(flags, 3, 0));
    }

    public static int setTnsType(int flags, TimeAndSaleType type) {
        return Util.setBits(flags, 3, 0, type.getCode());
    }

    public static int tnsNewValidTick(boolean validTick) {
        return MarketAccessorImpl.tnsNew() | MarketAccessorImpl.tnsValidTick(validTick);
    }

    public static int tnsNew() {
        return MarketAccessorImpl.tnsType(TimeAndSaleType.NEW);
    }

    public static int tnsCorrection() {
        return MarketAccessorImpl.tnsType(TimeAndSaleType.CORRECTION);
    }

    public static int tnsCancel() {
        return MarketAccessorImpl.tnsType(TimeAndSaleType.CANCEL);
    }

    public static boolean isTnsNew(int flags) {
        return MarketAccessorImpl.getTnsType(flags) == TimeAndSaleType.NEW;
    }

    public static boolean isTnsCorrection(int flags) {
        return MarketAccessorImpl.getTnsType(flags) == TimeAndSaleType.CORRECTION;
    }

    public static boolean isTnsCancel(int flags) {
        return MarketAccessorImpl.getTnsType(flags) == TimeAndSaleType.CANCEL;
    }

    public static int correctTns(int flags) {
        return MarketAccessorImpl.setTnsType(MarketAccessorImpl.setTnsValidTick(flags, false), TimeAndSaleType.CORRECTION);
    }

    public static int cancelTns(int flags) {
        return MarketAccessorImpl.setTnsType(MarketAccessorImpl.setTnsValidTick(flags, false), TimeAndSaleType.CANCEL);
    }

    public static int getTradeFlags(TradeBase trade) {
        return trade.getFlags();
    }

    public static void setTradeFlags(TradeBase trade, int flags) {
        trade.setFlags(flags);
    }

    public static int tradeTickDirection(Direction direction) {
        return direction.getCode() << 1;
    }

    public static Direction getTradeTickDirection(int flags) {
        return Direction.valueOf(Util.getBits(flags, 7, 1));
    }

    public static int setTradeTickDirection(int flags, Direction direction) {
        return Util.setBits(flags, 7, 1, direction.getCode());
    }

    public static int tradeExtendedTradingHours(boolean extendedTradingHours) {
        return extendedTradingHours ? 1 : 0;
    }

    public static boolean isTradeExtendedTradingHours(int flags) {
        return (flags & 1) != 0;
    }

    public static int setTradeExtendedTradingHours(int flags, boolean extendedTradingHours) {
        return extendedTradingHours ? flags | 1 : flags & 0xFFFFFFFE;
    }
}

