/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.event.candle.impl;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.ng.RecordCursor;
import com.devexperts.qd.util.MappingUtil;
import com.devexperts.util.TimeUtil;
import com.dxfeed.event.candle.impl.CandleEventMapping;

public class TradeHistoryMapping
extends CandleEventMapping {
    private final int iTime;
    private final int iSequence;
    private final int iExchangeCode;
    private final int iClose;
    private final int iVolume;
    private final int iBidPrice;
    private final int iAskPrice;

    public TradeHistoryMapping(DataRecord record) {
        super(record);
        this.iTime = MappingUtil.findIntField(record, "Time", true);
        this.iSequence = MappingUtil.findIntField(record, "Sequence", true);
        this.iExchangeCode = MappingUtil.findIntField(record, "Exchange", false);
        this.iClose = this.findIntField("Price", true);
        this.iVolume = this.findIntField("Size", true);
        this.iBidPrice = this.findIntField("Bid", false);
        this.iAskPrice = this.findIntField("Ask", false);
        this.putNonDefaultPropertyName("Exchange", "ExchangeCode");
        this.putNonDefaultPropertyName("Price", "Close");
        this.putNonDefaultPropertyName("Size", "Volume");
        this.putNonDefaultPropertyName("Bid", "BidPrice");
        this.putNonDefaultPropertyName("Ask", "AskPrice");
    }

    public long getTimeMillis(RecordCursor cursor) {
        return (long)this.getInt(cursor, this.iTime) * 1000L;
    }

    public void setTimeMillis(RecordCursor cursor, long time) {
        this.setInt(cursor, this.iTime, TimeUtil.getSecondsFromTime(time));
    }

    public int getTimeSeconds(RecordCursor cursor) {
        return this.getInt(cursor, this.iTime);
    }

    public void setTimeSeconds(RecordCursor cursor, int time) {
        this.setInt(cursor, this.iTime, time);
    }

    public int getSequence(RecordCursor cursor) {
        return this.getInt(cursor, this.iSequence);
    }

    public void setSequence(RecordCursor cursor, int sequence) {
        this.setInt(cursor, this.iSequence, sequence);
    }

    @Deprecated
    public char getExchange(RecordCursor cursor) {
        if (this.iExchangeCode < 0) {
            return '\u0000';
        }
        return (char)this.getInt(cursor, this.iExchangeCode);
    }

    @Deprecated
    public void setExchange(RecordCursor cursor, char exchange) {
        if (this.iExchangeCode < 0) {
            return;
        }
        this.setInt(cursor, this.iExchangeCode, exchange);
    }

    public char getExchangeCode(RecordCursor cursor) {
        if (this.iExchangeCode < 0) {
            return '\u0000';
        }
        return (char)this.getInt(cursor, this.iExchangeCode);
    }

    public void setExchangeCode(RecordCursor cursor, char exchangeCode) {
        if (this.iExchangeCode < 0) {
            return;
        }
        this.setInt(cursor, this.iExchangeCode, exchangeCode);
    }

    @Deprecated
    public double getPrice(RecordCursor cursor) {
        return this.getAsDouble(cursor, this.iClose);
    }

    @Deprecated
    public void setPrice(RecordCursor cursor, double price) {
        this.setAsDouble(cursor, this.iClose, price);
    }

    @Deprecated
    public int getPriceDecimal(RecordCursor cursor) {
        return this.getAsTinyDecimal(cursor, this.iClose);
    }

    @Deprecated
    public void setPriceDecimal(RecordCursor cursor, int price) {
        this.setAsTinyDecimal(cursor, this.iClose, price);
    }

    @Deprecated
    public long getPriceWideDecimal(RecordCursor cursor) {
        return this.getAsWideDecimal(cursor, this.iClose);
    }

    @Deprecated
    public void setPriceWideDecimal(RecordCursor cursor, long price) {
        this.setAsWideDecimal(cursor, this.iClose, price);
    }

    public double getClose(RecordCursor cursor) {
        return this.getAsDouble(cursor, this.iClose);
    }

    public void setClose(RecordCursor cursor, double close) {
        this.setAsDouble(cursor, this.iClose, close);
    }

    public int getCloseDecimal(RecordCursor cursor) {
        return this.getAsTinyDecimal(cursor, this.iClose);
    }

    public void setCloseDecimal(RecordCursor cursor, int close) {
        this.setAsTinyDecimal(cursor, this.iClose, close);
    }

    public long getCloseWideDecimal(RecordCursor cursor) {
        return this.getAsWideDecimal(cursor, this.iClose);
    }

    public void setCloseWideDecimal(RecordCursor cursor, long close) {
        this.setAsWideDecimal(cursor, this.iClose, close);
    }

    @Deprecated
    public int getSize(RecordCursor cursor) {
        return this.getAsInt(cursor, this.iVolume);
    }

    @Deprecated
    public void setSize(RecordCursor cursor, int size) {
        this.setAsInt(cursor, this.iVolume, size);
    }

    @Deprecated
    public long getSizeLong(RecordCursor cursor) {
        return this.getAsLong(cursor, this.iVolume);
    }

    @Deprecated
    public void setSizeLong(RecordCursor cursor, long size) {
        this.setAsLong(cursor, this.iVolume, size);
    }

    @Deprecated
    public double getSizeDouble(RecordCursor cursor) {
        return this.getAsDouble(cursor, this.iVolume);
    }

    @Deprecated
    public void setSizeDouble(RecordCursor cursor, double size) {
        this.setAsDouble(cursor, this.iVolume, size);
    }

    @Deprecated
    public int getSizeDecimal(RecordCursor cursor) {
        return this.getAsTinyDecimal(cursor, this.iVolume);
    }

    @Deprecated
    public void setSizeDecimal(RecordCursor cursor, int size) {
        this.setAsTinyDecimal(cursor, this.iVolume, size);
    }

    @Deprecated
    public long getSizeWideDecimal(RecordCursor cursor) {
        return this.getAsWideDecimal(cursor, this.iVolume);
    }

    @Deprecated
    public void setSizeWideDecimal(RecordCursor cursor, long size) {
        this.setAsWideDecimal(cursor, this.iVolume, size);
    }

    public int getVolume(RecordCursor cursor) {
        return this.getAsInt(cursor, this.iVolume);
    }

    public void setVolume(RecordCursor cursor, int volume) {
        this.setAsInt(cursor, this.iVolume, volume);
    }

    public long getVolumeLong(RecordCursor cursor) {
        return this.getAsLong(cursor, this.iVolume);
    }

    public void setVolumeLong(RecordCursor cursor, long volume) {
        this.setAsLong(cursor, this.iVolume, volume);
    }

    public double getVolumeDouble(RecordCursor cursor) {
        return this.getAsDouble(cursor, this.iVolume);
    }

    public void setVolumeDouble(RecordCursor cursor, double volume) {
        this.setAsDouble(cursor, this.iVolume, volume);
    }

    public int getVolumeDecimal(RecordCursor cursor) {
        return this.getAsTinyDecimal(cursor, this.iVolume);
    }

    public void setVolumeDecimal(RecordCursor cursor, int volume) {
        this.setAsTinyDecimal(cursor, this.iVolume, volume);
    }

    public long getVolumeWideDecimal(RecordCursor cursor) {
        return this.getAsWideDecimal(cursor, this.iVolume);
    }

    public void setVolumeWideDecimal(RecordCursor cursor, long volume) {
        this.setAsWideDecimal(cursor, this.iVolume, volume);
    }

    @Deprecated
    public double getBid(RecordCursor cursor) {
        if (this.iBidPrice < 0) {
            return Double.NaN;
        }
        return this.getAsDouble(cursor, this.iBidPrice);
    }

    @Deprecated
    public void setBid(RecordCursor cursor, double bid) {
        if (this.iBidPrice < 0) {
            return;
        }
        this.setAsDouble(cursor, this.iBidPrice, bid);
    }

    @Deprecated
    public int getBidDecimal(RecordCursor cursor) {
        if (this.iBidPrice < 0) {
            return 0;
        }
        return this.getAsTinyDecimal(cursor, this.iBidPrice);
    }

    @Deprecated
    public void setBidDecimal(RecordCursor cursor, int bid) {
        if (this.iBidPrice < 0) {
            return;
        }
        this.setAsTinyDecimal(cursor, this.iBidPrice, bid);
    }

    @Deprecated
    public long getBidWideDecimal(RecordCursor cursor) {
        if (this.iBidPrice < 0) {
            return 0L;
        }
        return this.getAsWideDecimal(cursor, this.iBidPrice);
    }

    @Deprecated
    public void setBidWideDecimal(RecordCursor cursor, long bid) {
        if (this.iBidPrice < 0) {
            return;
        }
        this.setAsWideDecimal(cursor, this.iBidPrice, bid);
    }

    public double getBidPrice(RecordCursor cursor) {
        if (this.iBidPrice < 0) {
            return Double.NaN;
        }
        return this.getAsDouble(cursor, this.iBidPrice);
    }

    public void setBidPrice(RecordCursor cursor, double bidPrice) {
        if (this.iBidPrice < 0) {
            return;
        }
        this.setAsDouble(cursor, this.iBidPrice, bidPrice);
    }

    public int getBidPriceDecimal(RecordCursor cursor) {
        if (this.iBidPrice < 0) {
            return 0;
        }
        return this.getAsTinyDecimal(cursor, this.iBidPrice);
    }

    public void setBidPriceDecimal(RecordCursor cursor, int bidPrice) {
        if (this.iBidPrice < 0) {
            return;
        }
        this.setAsTinyDecimal(cursor, this.iBidPrice, bidPrice);
    }

    public long getBidPriceWideDecimal(RecordCursor cursor) {
        if (this.iBidPrice < 0) {
            return 0L;
        }
        return this.getAsWideDecimal(cursor, this.iBidPrice);
    }

    public void setBidPriceWideDecimal(RecordCursor cursor, long bidPrice) {
        if (this.iBidPrice < 0) {
            return;
        }
        this.setAsWideDecimal(cursor, this.iBidPrice, bidPrice);
    }

    @Deprecated
    public double getAsk(RecordCursor cursor) {
        if (this.iAskPrice < 0) {
            return Double.NaN;
        }
        return this.getAsDouble(cursor, this.iAskPrice);
    }

    @Deprecated
    public void setAsk(RecordCursor cursor, double ask) {
        if (this.iAskPrice < 0) {
            return;
        }
        this.setAsDouble(cursor, this.iAskPrice, ask);
    }

    @Deprecated
    public int getAskDecimal(RecordCursor cursor) {
        if (this.iAskPrice < 0) {
            return 0;
        }
        return this.getAsTinyDecimal(cursor, this.iAskPrice);
    }

    @Deprecated
    public void setAskDecimal(RecordCursor cursor, int ask) {
        if (this.iAskPrice < 0) {
            return;
        }
        this.setAsTinyDecimal(cursor, this.iAskPrice, ask);
    }

    @Deprecated
    public long getAskWideDecimal(RecordCursor cursor) {
        if (this.iAskPrice < 0) {
            return 0L;
        }
        return this.getAsWideDecimal(cursor, this.iAskPrice);
    }

    @Deprecated
    public void setAskWideDecimal(RecordCursor cursor, long ask) {
        if (this.iAskPrice < 0) {
            return;
        }
        this.setAsWideDecimal(cursor, this.iAskPrice, ask);
    }

    public double getAskPrice(RecordCursor cursor) {
        if (this.iAskPrice < 0) {
            return Double.NaN;
        }
        return this.getAsDouble(cursor, this.iAskPrice);
    }

    public void setAskPrice(RecordCursor cursor, double askPrice) {
        if (this.iAskPrice < 0) {
            return;
        }
        this.setAsDouble(cursor, this.iAskPrice, askPrice);
    }

    public int getAskPriceDecimal(RecordCursor cursor) {
        if (this.iAskPrice < 0) {
            return 0;
        }
        return this.getAsTinyDecimal(cursor, this.iAskPrice);
    }

    public void setAskPriceDecimal(RecordCursor cursor, int askPrice) {
        if (this.iAskPrice < 0) {
            return;
        }
        this.setAsTinyDecimal(cursor, this.iAskPrice, askPrice);
    }

    public long getAskPriceWideDecimal(RecordCursor cursor) {
        if (this.iAskPrice < 0) {
            return 0L;
        }
        return this.getAsWideDecimal(cursor, this.iAskPrice);
    }

    public void setAskPriceWideDecimal(RecordCursor cursor, long askPrice) {
        if (this.iAskPrice < 0) {
            return;
        }
        this.setAsWideDecimal(cursor, this.iAskPrice, askPrice);
    }
}

