/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.event.candle.impl;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.ng.RecordCursor;
import com.devexperts.qd.util.MappingUtil;
import com.devexperts.util.TimeUtil;
import com.dxfeed.event.candle.impl.CandleEventMapping;

public class CandleMapping
extends CandleEventMapping {
    private final int iTime;
    private final int iSequence;
    private final int iCount;
    private final int iOpen;
    private final int iHigh;
    private final int iLow;
    private final int iClose;
    private final int iVolume;
    private final int iVWAP;
    private final int iBidVolume;
    private final int iAskVolume;
    private final int iImpVolatility;
    private final int iOpenInterest;

    public CandleMapping(DataRecord record) {
        super(record);
        this.iTime = MappingUtil.findIntField(record, "Time", true);
        this.iSequence = MappingUtil.findIntField(record, "Sequence", true);
        this.iCount = this.findIntField("Count", false);
        this.iOpen = this.findIntField("Open", true);
        this.iHigh = this.findIntField("High", true);
        this.iLow = this.findIntField("Low", true);
        this.iClose = this.findIntField("Close", true);
        this.iVolume = this.findIntField("Volume", false);
        this.iVWAP = this.findIntField("VWAP", false);
        this.iBidVolume = this.findIntField("Bid.Volume", false);
        this.iAskVolume = this.findIntField("Ask.Volume", false);
        this.iImpVolatility = this.findIntField("ImpVolatility", false);
        this.iOpenInterest = this.findIntField("OpenInterest", false);
    }

    public long getTimeMillis(RecordCursor cursor) {
        return (long)this.getInt(cursor, this.iTime) * 1000L;
    }

    public void setTimeMillis(RecordCursor cursor, long time) {
        this.setInt(cursor, this.iTime, TimeUtil.getSecondsFromTime(time));
    }

    public int getTimeSeconds(RecordCursor cursor) {
        return this.getInt(cursor, this.iTime);
    }

    public void setTimeSeconds(RecordCursor cursor, int time) {
        this.setInt(cursor, this.iTime, time);
    }

    public int getSequence(RecordCursor cursor) {
        return this.getInt(cursor, this.iSequence);
    }

    public void setSequence(RecordCursor cursor, int sequence) {
        this.setInt(cursor, this.iSequence, sequence);
    }

    public long getCount(RecordCursor cursor) {
        if (this.iCount < 0) {
            return 0L;
        }
        return this.getAsLong(cursor, this.iCount);
    }

    public void setCount(RecordCursor cursor, long count) {
        if (this.iCount < 0) {
            return;
        }
        this.setAsLong(cursor, this.iCount, count);
    }

    public double getCountDouble(RecordCursor cursor) {
        if (this.iCount < 0) {
            return Double.NaN;
        }
        return this.getAsDouble(cursor, this.iCount);
    }

    public void setCountDouble(RecordCursor cursor, double count) {
        if (this.iCount < 0) {
            return;
        }
        this.setAsDouble(cursor, this.iCount, count);
    }

    public int getCountDecimal(RecordCursor cursor) {
        if (this.iCount < 0) {
            return 0;
        }
        return this.getAsTinyDecimal(cursor, this.iCount);
    }

    public void setCountDecimal(RecordCursor cursor, int count) {
        if (this.iCount < 0) {
            return;
        }
        this.setAsTinyDecimal(cursor, this.iCount, count);
    }

    public long getCountWideDecimal(RecordCursor cursor) {
        if (this.iCount < 0) {
            return 0L;
        }
        return this.getAsWideDecimal(cursor, this.iCount);
    }

    public void setCountWideDecimal(RecordCursor cursor, long count) {
        if (this.iCount < 0) {
            return;
        }
        this.setAsWideDecimal(cursor, this.iCount, count);
    }

    public double getOpen(RecordCursor cursor) {
        return this.getAsDouble(cursor, this.iOpen);
    }

    public void setOpen(RecordCursor cursor, double open) {
        this.setAsDouble(cursor, this.iOpen, open);
    }

    public int getOpenDecimal(RecordCursor cursor) {
        return this.getAsTinyDecimal(cursor, this.iOpen);
    }

    public void setOpenDecimal(RecordCursor cursor, int open) {
        this.setAsTinyDecimal(cursor, this.iOpen, open);
    }

    public long getOpenWideDecimal(RecordCursor cursor) {
        return this.getAsWideDecimal(cursor, this.iOpen);
    }

    public void setOpenWideDecimal(RecordCursor cursor, long open) {
        this.setAsWideDecimal(cursor, this.iOpen, open);
    }

    public double getHigh(RecordCursor cursor) {
        return this.getAsDouble(cursor, this.iHigh);
    }

    public void setHigh(RecordCursor cursor, double high) {
        this.setAsDouble(cursor, this.iHigh, high);
    }

    public int getHighDecimal(RecordCursor cursor) {
        return this.getAsTinyDecimal(cursor, this.iHigh);
    }

    public void setHighDecimal(RecordCursor cursor, int high) {
        this.setAsTinyDecimal(cursor, this.iHigh, high);
    }

    public long getHighWideDecimal(RecordCursor cursor) {
        return this.getAsWideDecimal(cursor, this.iHigh);
    }

    public void setHighWideDecimal(RecordCursor cursor, long high) {
        this.setAsWideDecimal(cursor, this.iHigh, high);
    }

    public double getLow(RecordCursor cursor) {
        return this.getAsDouble(cursor, this.iLow);
    }

    public void setLow(RecordCursor cursor, double low) {
        this.setAsDouble(cursor, this.iLow, low);
    }

    public int getLowDecimal(RecordCursor cursor) {
        return this.getAsTinyDecimal(cursor, this.iLow);
    }

    public void setLowDecimal(RecordCursor cursor, int low) {
        this.setAsTinyDecimal(cursor, this.iLow, low);
    }

    public long getLowWideDecimal(RecordCursor cursor) {
        return this.getAsWideDecimal(cursor, this.iLow);
    }

    public void setLowWideDecimal(RecordCursor cursor, long low) {
        this.setAsWideDecimal(cursor, this.iLow, low);
    }

    public double getClose(RecordCursor cursor) {
        return this.getAsDouble(cursor, this.iClose);
    }

    public void setClose(RecordCursor cursor, double close) {
        this.setAsDouble(cursor, this.iClose, close);
    }

    public int getCloseDecimal(RecordCursor cursor) {
        return this.getAsTinyDecimal(cursor, this.iClose);
    }

    public void setCloseDecimal(RecordCursor cursor, int close) {
        this.setAsTinyDecimal(cursor, this.iClose, close);
    }

    public long getCloseWideDecimal(RecordCursor cursor) {
        return this.getAsWideDecimal(cursor, this.iClose);
    }

    public void setCloseWideDecimal(RecordCursor cursor, long close) {
        this.setAsWideDecimal(cursor, this.iClose, close);
    }

    public long getVolume(RecordCursor cursor) {
        if (this.iVolume < 0) {
            return 0L;
        }
        return this.getAsLong(cursor, this.iVolume);
    }

    public void setVolume(RecordCursor cursor, long volume) {
        if (this.iVolume < 0) {
            return;
        }
        this.setAsLong(cursor, this.iVolume, volume);
    }

    public double getVolumeDouble(RecordCursor cursor) {
        if (this.iVolume < 0) {
            return Double.NaN;
        }
        return this.getAsDouble(cursor, this.iVolume);
    }

    public void setVolumeDouble(RecordCursor cursor, double volume) {
        if (this.iVolume < 0) {
            return;
        }
        this.setAsDouble(cursor, this.iVolume, volume);
    }

    public int getVolumeDecimal(RecordCursor cursor) {
        if (this.iVolume < 0) {
            return 0;
        }
        return this.getAsTinyDecimal(cursor, this.iVolume);
    }

    public void setVolumeDecimal(RecordCursor cursor, int volume) {
        if (this.iVolume < 0) {
            return;
        }
        this.setAsTinyDecimal(cursor, this.iVolume, volume);
    }

    public long getVolumeWideDecimal(RecordCursor cursor) {
        if (this.iVolume < 0) {
            return 0L;
        }
        return this.getAsWideDecimal(cursor, this.iVolume);
    }

    public void setVolumeWideDecimal(RecordCursor cursor, long volume) {
        if (this.iVolume < 0) {
            return;
        }
        this.setAsWideDecimal(cursor, this.iVolume, volume);
    }

    public double getVWAP(RecordCursor cursor) {
        if (this.iVWAP < 0) {
            return Double.NaN;
        }
        return this.getAsDouble(cursor, this.iVWAP);
    }

    public void setVWAP(RecordCursor cursor, double _VWAP) {
        if (this.iVWAP < 0) {
            return;
        }
        this.setAsDouble(cursor, this.iVWAP, _VWAP);
    }

    public int getVWAPDecimal(RecordCursor cursor) {
        if (this.iVWAP < 0) {
            return 0;
        }
        return this.getAsTinyDecimal(cursor, this.iVWAP);
    }

    public void setVWAPDecimal(RecordCursor cursor, int _VWAP) {
        if (this.iVWAP < 0) {
            return;
        }
        this.setAsTinyDecimal(cursor, this.iVWAP, _VWAP);
    }

    public long getVWAPWideDecimal(RecordCursor cursor) {
        if (this.iVWAP < 0) {
            return 0L;
        }
        return this.getAsWideDecimal(cursor, this.iVWAP);
    }

    public void setVWAPWideDecimal(RecordCursor cursor, long _VWAP) {
        if (this.iVWAP < 0) {
            return;
        }
        this.setAsWideDecimal(cursor, this.iVWAP, _VWAP);
    }

    public long getBidVolume(RecordCursor cursor) {
        if (this.iBidVolume < 0) {
            return 0L;
        }
        return this.getAsLong(cursor, this.iBidVolume);
    }

    public void setBidVolume(RecordCursor cursor, long bidVolume) {
        if (this.iBidVolume < 0) {
            return;
        }
        this.setAsLong(cursor, this.iBidVolume, bidVolume);
    }

    public double getBidVolumeDouble(RecordCursor cursor) {
        if (this.iBidVolume < 0) {
            return Double.NaN;
        }
        return this.getAsDouble(cursor, this.iBidVolume);
    }

    public void setBidVolumeDouble(RecordCursor cursor, double bidVolume) {
        if (this.iBidVolume < 0) {
            return;
        }
        this.setAsDouble(cursor, this.iBidVolume, bidVolume);
    }

    public int getBidVolumeDecimal(RecordCursor cursor) {
        if (this.iBidVolume < 0) {
            return 0;
        }
        return this.getAsTinyDecimal(cursor, this.iBidVolume);
    }

    public void setBidVolumeDecimal(RecordCursor cursor, int bidVolume) {
        if (this.iBidVolume < 0) {
            return;
        }
        this.setAsTinyDecimal(cursor, this.iBidVolume, bidVolume);
    }

    public long getBidVolumeWideDecimal(RecordCursor cursor) {
        if (this.iBidVolume < 0) {
            return 0L;
        }
        return this.getAsWideDecimal(cursor, this.iBidVolume);
    }

    public void setBidVolumeWideDecimal(RecordCursor cursor, long bidVolume) {
        if (this.iBidVolume < 0) {
            return;
        }
        this.setAsWideDecimal(cursor, this.iBidVolume, bidVolume);
    }

    public long getAskVolume(RecordCursor cursor) {
        if (this.iAskVolume < 0) {
            return 0L;
        }
        return this.getAsLong(cursor, this.iAskVolume);
    }

    public void setAskVolume(RecordCursor cursor, long askVolume) {
        if (this.iAskVolume < 0) {
            return;
        }
        this.setAsLong(cursor, this.iAskVolume, askVolume);
    }

    public double getAskVolumeDouble(RecordCursor cursor) {
        if (this.iAskVolume < 0) {
            return Double.NaN;
        }
        return this.getAsDouble(cursor, this.iAskVolume);
    }

    public void setAskVolumeDouble(RecordCursor cursor, double askVolume) {
        if (this.iAskVolume < 0) {
            return;
        }
        this.setAsDouble(cursor, this.iAskVolume, askVolume);
    }

    public int getAskVolumeDecimal(RecordCursor cursor) {
        if (this.iAskVolume < 0) {
            return 0;
        }
        return this.getAsTinyDecimal(cursor, this.iAskVolume);
    }

    public void setAskVolumeDecimal(RecordCursor cursor, int askVolume) {
        if (this.iAskVolume < 0) {
            return;
        }
        this.setAsTinyDecimal(cursor, this.iAskVolume, askVolume);
    }

    public long getAskVolumeWideDecimal(RecordCursor cursor) {
        if (this.iAskVolume < 0) {
            return 0L;
        }
        return this.getAsWideDecimal(cursor, this.iAskVolume);
    }

    public void setAskVolumeWideDecimal(RecordCursor cursor, long askVolume) {
        if (this.iAskVolume < 0) {
            return;
        }
        this.setAsWideDecimal(cursor, this.iAskVolume, askVolume);
    }

    public double getImpVolatility(RecordCursor cursor) {
        if (this.iImpVolatility < 0) {
            return Double.NaN;
        }
        return this.getAsDouble(cursor, this.iImpVolatility);
    }

    public void setImpVolatility(RecordCursor cursor, double impVolatility) {
        if (this.iImpVolatility < 0) {
            return;
        }
        this.setAsDouble(cursor, this.iImpVolatility, impVolatility);
    }

    public int getImpVolatilityDecimal(RecordCursor cursor) {
        if (this.iImpVolatility < 0) {
            return 0;
        }
        return this.getAsTinyDecimal(cursor, this.iImpVolatility);
    }

    public void setImpVolatilityDecimal(RecordCursor cursor, int impVolatility) {
        if (this.iImpVolatility < 0) {
            return;
        }
        this.setAsTinyDecimal(cursor, this.iImpVolatility, impVolatility);
    }

    public long getImpVolatilityWideDecimal(RecordCursor cursor) {
        if (this.iImpVolatility < 0) {
            return 0L;
        }
        return this.getAsWideDecimal(cursor, this.iImpVolatility);
    }

    public void setImpVolatilityWideDecimal(RecordCursor cursor, long impVolatility) {
        if (this.iImpVolatility < 0) {
            return;
        }
        this.setAsWideDecimal(cursor, this.iImpVolatility, impVolatility);
    }

    public long getOpenInterest(RecordCursor cursor) {
        if (this.iOpenInterest < 0) {
            return 0L;
        }
        return this.getAsLong(cursor, this.iOpenInterest);
    }

    public void setOpenInterest(RecordCursor cursor, long openInterest) {
        if (this.iOpenInterest < 0) {
            return;
        }
        this.setAsLong(cursor, this.iOpenInterest, openInterest);
    }

    public double getOpenInterestDouble(RecordCursor cursor) {
        if (this.iOpenInterest < 0) {
            return Double.NaN;
        }
        return this.getAsDouble(cursor, this.iOpenInterest);
    }

    public void setOpenInterestDouble(RecordCursor cursor, double openInterest) {
        if (this.iOpenInterest < 0) {
            return;
        }
        this.setAsDouble(cursor, this.iOpenInterest, openInterest);
    }

    public int getOpenInterestDecimal(RecordCursor cursor) {
        if (this.iOpenInterest < 0) {
            return 0;
        }
        return this.getAsTinyDecimal(cursor, this.iOpenInterest);
    }

    public void setOpenInterestDecimal(RecordCursor cursor, int openInterest) {
        if (this.iOpenInterest < 0) {
            return;
        }
        this.setAsTinyDecimal(cursor, this.iOpenInterest, openInterest);
    }

    public long getOpenInterestWideDecimal(RecordCursor cursor) {
        if (this.iOpenInterest < 0) {
            return 0L;
        }
        return this.getAsWideDecimal(cursor, this.iOpenInterest);
    }

    public void setOpenInterestWideDecimal(RecordCursor cursor, long openInterest) {
        if (this.iOpenInterest < 0) {
            return;
        }
        this.setAsWideDecimal(cursor, this.iOpenInterest, openInterest);
    }
}

