/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.event.candle.impl;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.ng.RecordMapping;
import com.dxfeed.event.candle.CandlePeriod;
import com.dxfeed.event.candle.CandlePrice;
import com.dxfeed.event.candle.CandleSymbol;
import com.dxfeed.event.market.MarketEventSymbols;

public abstract class CandleEventMapping
extends RecordMapping {
    private static final String TRADE_HISTORY = "TradeHistory";
    private static final String TRADE = "Trade.";
    private static final String CANDLE = "Candle";
    protected final CandlePeriod recordPeriod;
    protected final CandlePrice recordPrice;

    CandleEventMapping(DataRecord record) {
        super(record);
        String name = record.getName();
        CandleEventMapping.checkValidName(name);
        this.recordPeriod = CandleEventMapping.getRecordPeriod(name);
        this.recordPrice = CandleEventMapping.getRecordPrice(name);
    }

    private static void checkValidName(String name) {
        if (name.equals(TRADE_HISTORY)) {
            return;
        }
        if (name.startsWith(TRADE)) {
            if (MarketEventSymbols.hasAttributes(name)) {
                throw new IllegalArgumentException("Trade record does not support attributes: " + name);
            }
            return;
        }
        if (name.startsWith(CANDLE)) {
            String bareName = CandlePrice.DEFAULT.changeAttributeForSymbol(CandlePeriod.DEFAULT.changeAttributeForSymbol(name));
            if (!bareName.equals(CANDLE)) {
                throw new IllegalArgumentException("Candle record supports only price and period attributes: " + name);
            }
            return;
        }
        throw new IllegalArgumentException("Unsupported record name prefix: " + name);
    }

    private static CandlePeriod getRecordPeriod(String name) {
        if (name.equals(TRADE_HISTORY)) {
            return CandlePeriod.TICK;
        }
        CandlePeriod period = CandlePeriod.getAttributeForSymbol(name);
        if (period != CandlePeriod.DEFAULT) {
            return period;
        }
        String baseName = MarketEventSymbols.getBaseSymbol(name);
        int i = baseName.indexOf(46);
        return i < 0 ? null : CandlePeriod.parse(baseName.substring(i + 1));
    }

    private static CandlePrice getRecordPrice(String name) {
        CandlePrice price = CandlePrice.getAttributeForSymbol(name);
        return price == CandlePrice.DEFAULT ? null : price;
    }

    public final CandlePeriod getRecordPeriod() {
        return this.recordPeriod;
    }

    public final CandlePrice getRecordPrice() {
        return this.recordPrice;
    }

    @Override
    public final CandleSymbol getEventSymbolByQDSymbol(String qdSymbol) {
        if (this.recordPeriod == null) {
            return CandleSymbol.valueOf(qdSymbol);
        }
        if (this.recordPrice == null) {
            return CandleSymbol.valueOf(qdSymbol, this.recordPeriod);
        }
        return CandleSymbol.valueOf(qdSymbol, this.recordPeriod, this.recordPrice);
    }

    @Override
    public final String getQDSymbolByEventSymbol(Object symbol) {
        String s = symbol.toString();
        if (this.recordPeriod != null) {
            s = CandlePeriod.DEFAULT.changeAttributeForSymbol(s);
            if (this.recordPrice != null) {
                s = CandlePrice.DEFAULT.changeAttributeForSymbol(s);
            }
        }
        return s;
    }
}

