/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.event.candle;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.QDContract;
import com.devexperts.qd.SerialFieldType;
import com.devexperts.qd.ng.RecordMapping;
import com.devexperts.qd.ng.RecordMappingFactory;
import com.devexperts.services.ServiceProvider;
import com.devexperts.util.SystemProperties;
import com.dxfeed.api.impl.EventDelegate;
import com.dxfeed.api.impl.EventDelegateFactory;
import com.dxfeed.api.impl.EventDelegateFlags;
import com.dxfeed.api.impl.SchemeBuilder;
import com.dxfeed.api.impl.SchemeFieldTime;
import com.dxfeed.event.candle.CandleByTradeHistoryDelegate;
import com.dxfeed.event.candle.CandleDelegate;
import com.dxfeed.event.candle.DailyCandleDelegate;
import com.dxfeed.event.candle.impl.CandleMapping;
import com.dxfeed.event.candle.impl.TradeHistoryMapping;
import com.dxfeed.event.market.MarketEventSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;

@ServiceProvider(order=-50)
public final class CandleFactoryImpl
extends EventDelegateFactory
implements RecordMappingFactory {
    @Override
    public void buildScheme(SchemeBuilder builder) {
        String recordName;
        builder.addRequiredField("TradeHistory", "Time", SerialFieldType.TIME_SECONDS, SchemeFieldTime.FIRST_TIME_INT_FIELD);
        builder.addRequiredField("TradeHistory", "Sequence", SerialFieldType.SEQUENCE, SchemeFieldTime.SECOND_TIME_INT_FIELD);
        builder.addOptionalField("TradeHistory", "Exchange", SerialFieldType.UTF_CHAR, "Candle", "ExchangeCode", true);
        builder.addRequiredField("TradeHistory", "Price", this.select(SerialFieldType.DECIMAL, "dxscheme.price"));
        builder.addRequiredField("TradeHistory", "Size", this.select(SerialFieldType.COMPACT_INT, "dxscheme.size"));
        builder.addOptionalField("TradeHistory", "Bid", this.select(SerialFieldType.DECIMAL, "dxscheme.price"), "Candle", "BidPrice", true);
        builder.addOptionalField("TradeHistory", "Ask", this.select(SerialFieldType.DECIMAL, "dxscheme.price"), "Candle", "AskPrice", true);
        for (String suffix : SystemProperties.getProperty("com.dxfeed.event.candle.impl.Candle.suffixes", "").split("\\|")) {
            recordName = "Candle" + suffix;
            builder.addRequiredField(recordName, "Time", SerialFieldType.TIME_SECONDS, SchemeFieldTime.FIRST_TIME_INT_FIELD);
            builder.addRequiredField(recordName, "Sequence", SerialFieldType.SEQUENCE, SchemeFieldTime.SECOND_TIME_INT_FIELD);
            builder.addOptionalField(recordName, "Count", this.select(SerialFieldType.DECIMAL, new String[0]), "Candle", "Count", true);
            builder.addRequiredField(recordName, "Open", this.select(SerialFieldType.DECIMAL, "dxscheme.price"));
            builder.addRequiredField(recordName, "High", this.select(SerialFieldType.DECIMAL, "dxscheme.price"));
            builder.addRequiredField(recordName, "Low", this.select(SerialFieldType.DECIMAL, "dxscheme.price"));
            builder.addRequiredField(recordName, "Close", this.select(SerialFieldType.DECIMAL, "dxscheme.price"));
            builder.addOptionalField(recordName, "Volume", this.select(SerialFieldType.DECIMAL, "dxscheme.volume", "dxscheme.size"), "Candle", "Volume", true);
            builder.addOptionalField(recordName, "VWAP", this.select(SerialFieldType.DECIMAL, "dxscheme.price"), "Candle", "VWAP", true);
            if (!suffix.matches(".*[{,]price=(bid|ask|mark|s)[,}].*")) {
                builder.addOptionalField(recordName, "Bid.Volume", this.select(SerialFieldType.DECIMAL, "dxscheme.volume", "dxscheme.size"), "Candle", "BidVolume", true);
            }
            if (!suffix.matches(".*[{,]price=(bid|ask|mark|s)[,}].*")) {
                builder.addOptionalField(recordName, "Ask.Volume", this.select(SerialFieldType.DECIMAL, "dxscheme.volume", "dxscheme.size"), "Candle", "AskVolume", true);
            }
            builder.addOptionalField(recordName, "ImpVolatility", this.select(SerialFieldType.DECIMAL, new String[0]), "Candle", "ImpVolatility", true);
            builder.addOptionalField(recordName, "OpenInterest", this.select(SerialFieldType.DECIMAL, "dxscheme.oi"), "Candle", "OpenInterest", true);
        }
        for (String suffix : SystemProperties.getProperty("com.dxfeed.event.candle.impl.Trade.suffixes", "133ticks|144ticks|233ticks|333ticks|400ticks|512ticks|1600ticks|3200ticks|1min|2min|3min|4min|5min|6min|10min|12min|15min|20min|30min|1hour|2hour|3hour|4hour|6hour|8hour|12hour|Day|2Day|3Day|4Day|Week|Month|OptExp").split("\\|")) {
            recordName = "Trade." + suffix;
            builder.addRequiredField(recordName, "Time", SerialFieldType.TIME_SECONDS, SchemeFieldTime.FIRST_TIME_INT_FIELD);
            builder.addRequiredField(recordName, "Sequence", SerialFieldType.SEQUENCE, SchemeFieldTime.SECOND_TIME_INT_FIELD);
            builder.addOptionalField(recordName, "Count", this.select(SerialFieldType.DECIMAL, new String[0]), "Candle", "Count", true);
            builder.addRequiredField(recordName, "Open", this.select(SerialFieldType.DECIMAL, "dxscheme.price"));
            builder.addRequiredField(recordName, "High", this.select(SerialFieldType.DECIMAL, "dxscheme.price"));
            builder.addRequiredField(recordName, "Low", this.select(SerialFieldType.DECIMAL, "dxscheme.price"));
            builder.addRequiredField(recordName, "Close", this.select(SerialFieldType.DECIMAL, "dxscheme.price"));
            builder.addOptionalField(recordName, "Volume", this.select(SerialFieldType.DECIMAL, "dxscheme.volume", "dxscheme.size"), "Candle", "Volume", true);
            builder.addOptionalField(recordName, "VWAP", this.select(SerialFieldType.DECIMAL, "dxscheme.price"), "Candle", "VWAP", true);
            if (!suffix.matches(".*[{,]price=(bid|ask|mark|s)[,}].*")) {
                builder.addOptionalField(recordName, "Bid.Volume", this.select(SerialFieldType.DECIMAL, "dxscheme.volume", "dxscheme.size"), "Candle", "BidVolume", true);
            }
            if (!suffix.matches(".*[{,]price=(bid|ask|mark|s)[,}].*")) {
                builder.addOptionalField(recordName, "Ask.Volume", this.select(SerialFieldType.DECIMAL, "dxscheme.volume", "dxscheme.size"), "Candle", "AskVolume", true);
            }
            builder.addOptionalField(recordName, "ImpVolatility", this.select(SerialFieldType.DECIMAL, new String[0]), "Candle", "ImpVolatility", true);
            builder.addOptionalField(recordName, "OpenInterest", this.select(SerialFieldType.DECIMAL, "dxscheme.oi"), "Candle", "OpenInterest", true);
        }
    }

    @Override
    public Collection<EventDelegate<?>> createDelegates(DataRecord record) {
        ArrayList result = new ArrayList();
        if (record.getMapping(TradeHistoryMapping.class) != null) {
            result.add(new CandleByTradeHistoryDelegate(record, QDContract.TICKER, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB)));
            result.add(new CandleByTradeHistoryDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.PUB, EventDelegateFlags.WILDCARD)));
            result.add(new CandleByTradeHistoryDelegate(record, QDContract.HISTORY, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB, EventDelegateFlags.TIME_SERIES)));
        } else if (record.getMapping(CandleMapping.class) != null) {
            result.add(new CandleDelegate(record, QDContract.TICKER, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB)));
            result.add(new CandleDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.PUB, EventDelegateFlags.WILDCARD)));
            result.add(new CandleDelegate(record, QDContract.HISTORY, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB, EventDelegateFlags.TIME_SERIES)));
            result.add(new DailyCandleDelegate(record, QDContract.TICKER, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB)));
            result.add(new DailyCandleDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.PUB, EventDelegateFlags.WILDCARD)));
            result.add(new DailyCandleDelegate(record, QDContract.HISTORY, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB, EventDelegateFlags.TIME_SERIES)));
        }
        return result;
    }

    @Override
    public Collection<EventDelegate<?>> createStreamOnlyDelegates(DataRecord record) {
        ArrayList result = new ArrayList();
        if (record.getMapping(TradeHistoryMapping.class) != null) {
            result.add(new CandleByTradeHistoryDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB, EventDelegateFlags.WILDCARD)));
        } else if (record.getMapping(CandleMapping.class) != null) {
            result.add(new CandleDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB, EventDelegateFlags.WILDCARD)));
            result.add(new DailyCandleDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB, EventDelegateFlags.WILDCARD)));
        }
        return result;
    }

    @Override
    public RecordMapping createMapping(DataRecord record) {
        String baseRecordName = this.getBaseRecordName(record.getName());
        if (baseRecordName.equals("TradeHistory")) {
            return new TradeHistoryMapping(record);
        }
        if (baseRecordName.equals("Candle")) {
            return new CandleMapping(record);
        }
        if (baseRecordName.equals("Trade.")) {
            return new CandleMapping(record);
        }
        return null;
    }

    @Override
    protected String getBaseRecordName(String recordName) {
        String s = MarketEventSymbols.getBaseSymbol(recordName);
        int i = s.indexOf(46);
        return i > 0 ? s.substring(0, i + 1) : s;
    }
}

