/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.event.candle;

import com.devexperts.qd.QDContract;
import com.dxfeed.api.impl.EventDelegate;
import com.dxfeed.api.impl.EventDelegateSet;
import com.dxfeed.api.osub.WildcardSymbol;
import com.dxfeed.event.candle.Candle;
import com.dxfeed.event.candle.CandleEventDelegateImpl;
import com.dxfeed.event.candle.CandlePeriod;
import com.dxfeed.event.candle.CandlePrice;
import com.dxfeed.event.candle.CandleSymbol;
import com.dxfeed.event.candle.CandleType;
import com.dxfeed.event.candle.impl.CandleEventMapping;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class CandleEventDelegateSet<T extends Candle, D extends CandleEventDelegateImpl<T>>
extends EventDelegateSet<T, D> {
    private static final CandlePeriod MINUTE = CandlePeriod.valueOf(1.0, CandleType.MINUTE);
    private final Map<Object, List<D>> regularDelegatesByDescriptor = new HashMap<Object, List<D>>();
    private final Map<Object, List<D>> timeSeriesDelegatesByDescriptor = new HashMap<Object, List<D>>();
    private final Map<Object, List<D>> lastingDelegatesByDescriptor = new HashMap<Object, List<D>>();
    private final Map<Object, List<D>> publishableDelegatesByDescriptor = new HashMap<Object, List<D>>();

    CandleEventDelegateSet(Class<T> eventType) {
        super(eventType);
    }

    @Override
    public void add(D delegate) {
        List<D> delegates;
        CandleEventMapping m = ((CandleEventDelegateImpl)delegate).getMapping();
        Object descriptor = CandleEventDelegateSet.getRecordDescriptor(m.getRecordPeriod(), m.getRecordPrice());
        if (((EventDelegate)delegate).isSub()) {
            Map<Object, List<D>> map;
            Map<Object, List<D>> map2 = map = ((EventDelegate)delegate).isTimeSeries() ? this.timeSeriesDelegatesByDescriptor : this.regularDelegatesByDescriptor;
            if (map.put(descriptor, Collections.singletonList(delegate)) != null) {
                throw new IllegalArgumentException("Only one delegate for descriptor " + descriptor + " is supported: " + delegate);
            }
        }
        if (((EventDelegate)delegate).isLastingEvent() && ((EventDelegate)delegate).getContract() == QDContract.TICKER) {
            delegates = this.lastingDelegatesByDescriptor.get(descriptor);
            if (delegates == null) {
                delegates = new ArrayList<D>(2);
                this.lastingDelegatesByDescriptor.put(descriptor, delegates);
            }
            delegates.add(delegate);
        }
        if (((EventDelegate)delegate).isPub()) {
            delegates = this.publishableDelegatesByDescriptor.get(descriptor);
            if (delegates == null) {
                delegates = new ArrayList<D>(2);
                this.publishableDelegatesByDescriptor.put(descriptor, delegates);
            }
            delegates.add(delegate);
        }
        super.add(delegate);
    }

    @Override
    public void completeConstruction() {
        CandleEventDelegateSet.fixMap(this.timeSeriesDelegatesByDescriptor);
        CandleEventDelegateSet.fixMap(this.regularDelegatesByDescriptor);
        CandleEventDelegateSet.fixMap(this.lastingDelegatesByDescriptor);
        CandleEventDelegateSet.fixMap(this.publishableDelegatesByDescriptor);
        super.completeConstruction();
    }

    @Override
    public Object convertSymbol(Object symbol) {
        if (symbol instanceof CandleSymbol) {
            return symbol;
        }
        if (symbol instanceof String) {
            return CandleSymbol.valueOf((String)symbol);
        }
        if (symbol instanceof WildcardSymbol) {
            return symbol;
        }
        throw new IllegalArgumentException("Candle symbol must have either String, CandleSymbol, or WildcardSymbol class");
    }

    @Override
    protected List<D> getRegularSubDelegatesBySubscriptionSymbol(Object symbol, int sourceId) {
        return CandleEventDelegateSet.getFromMapByDescriptor(this.regularDelegatesByDescriptor, CandleEventDelegateSet.getSymbolDescriptor((CandleSymbol)symbol));
    }

    @Override
    public List<D> getTimeSeriesDelegatesByEventSymbol(Object symbol) {
        return CandleEventDelegateSet.getFromMapByDescriptor(this.timeSeriesDelegatesByDescriptor, CandleEventDelegateSet.getSymbolDescriptor((CandleSymbol)symbol));
    }

    @Override
    public D getLastingDelegateByEventSymbol(Object symbol) {
        List<D> list = CandleEventDelegateSet.getFromMapByDescriptor(this.lastingDelegatesByDescriptor, CandleEventDelegateSet.getSymbolDescriptor((CandleSymbol)symbol));
        return (D)(list.isEmpty() ? null : (CandleEventDelegateImpl)list.get(0));
    }

    @Override
    public List<D> getPubDelegatesByEvent(T event) {
        return CandleEventDelegateSet.getFromMapByDescriptor(this.publishableDelegatesByDescriptor, CandleEventDelegateSet.getSymbolDescriptor(((Candle)event).getEventSymbol()));
    }

    private static Object getSymbolDescriptor(CandleSymbol symbol) {
        return MINUTE.equals(symbol.getPeriod()) ? symbol.getPrice() : symbol.getPeriod();
    }

    private static <T extends Candle, D extends CandleEventDelegateImpl<T>> void fixMap(Map<Object, List<D>> map) {
        for (CandlePrice price : CandlePrice.values()) {
            if (map.containsKey(price)) continue;
            map.put(price, map.get(MINUTE));
        }
    }

    private static <T extends Candle, D extends CandleEventDelegateImpl<T>> List<D> getFromMapByDescriptor(Map<Object, List<D>> map, Object descriptor) {
        List<D> result = map.get(descriptor);
        if (result != null) {
            return result;
        }
        result = map.get(null);
        if (result != null) {
            return result;
        }
        return Collections.emptyList();
    }

    private static Object getRecordDescriptor(CandlePeriod period, CandlePrice price) {
        if (price != null) {
            if (MINUTE.equals(period)) {
                return price;
            }
            throw new IllegalArgumentException("Record price is supported only for " + MINUTE + " period");
        }
        return period;
    }
}

