/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.event.candle;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.QDContract;
import com.devexperts.qd.ng.RecordBuffer;
import com.devexperts.qd.ng.RecordCursor;
import com.dxfeed.api.impl.EventDelegateFlags;
import com.dxfeed.event.candle.Candle;
import com.dxfeed.event.candle.CandleEventDelegateImpl;
import com.dxfeed.event.candle.impl.CandleMapping;
import java.util.EnumSet;

public final class CandleDelegate
extends CandleEventDelegateImpl<Candle> {
    private final CandleMapping m;

    public CandleDelegate(DataRecord record, QDContract contract, EnumSet<EventDelegateFlags> flags) {
        super(record, contract, flags);
        this.m = record.getMapping(CandleMapping.class);
    }

    @Override
    public CandleMapping getMapping() {
        return this.m;
    }

    @Override
    public Candle createEvent() {
        return new Candle();
    }

    @Override
    public Candle getEvent(Candle event, RecordCursor cursor) {
        super.getEvent(event, cursor);
        event.setEventFlags(cursor.getEventFlags());
        event.setIndex((long)this.m.getTimeSeconds(cursor) << 32 | (long)this.m.getSequence(cursor) & 0xFFFFFFFFL);
        event.setCount(this.m.getCount(cursor));
        event.setOpen(this.m.getOpen(cursor));
        event.setHigh(this.m.getHigh(cursor));
        event.setLow(this.m.getLow(cursor));
        event.setClose(this.m.getClose(cursor));
        event.setVolumeAsDouble(this.m.getVolumeDouble(cursor));
        event.setVWAP(this.m.getVWAP(cursor));
        event.setBidVolumeAsDouble(this.m.getBidVolumeDouble(cursor));
        event.setAskVolumeAsDouble(this.m.getAskVolumeDouble(cursor));
        event.setImpVolatility(this.m.getImpVolatility(cursor));
        event.setOpenInterestAsDouble(this.m.getOpenInterestDouble(cursor));
        return event;
    }

    @Override
    public RecordCursor putEvent(Candle event, RecordBuffer buf) {
        RecordCursor cursor = super.putEvent(event, buf);
        cursor.setEventFlags(event.getEventFlags());
        this.m.setTimeSeconds(cursor, (int)(event.getIndex() >>> 32));
        this.m.setSequence(cursor, (int)event.getIndex());
        this.m.setCount(cursor, event.getCount());
        this.m.setOpen(cursor, event.getOpen());
        this.m.setHigh(cursor, event.getHigh());
        this.m.setLow(cursor, event.getLow());
        this.m.setClose(cursor, event.getClose());
        this.m.setVolumeDouble(cursor, event.getVolumeAsDouble());
        this.m.setVWAP(cursor, event.getVWAP());
        this.m.setBidVolumeDouble(cursor, event.getBidVolumeAsDouble());
        this.m.setAskVolumeDouble(cursor, event.getAskVolumeAsDouble());
        this.m.setImpVolatility(cursor, event.getImpVolatility());
        this.m.setOpenInterestDouble(cursor, event.getOpenInterestAsDouble());
        return cursor;
    }
}

