/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.event.candle;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.QDContract;
import com.devexperts.qd.ng.RecordBuffer;
import com.devexperts.qd.ng.RecordCursor;
import com.dxfeed.api.impl.EventDelegateFlags;
import com.dxfeed.event.candle.Candle;
import com.dxfeed.event.candle.CandleEventDelegateImpl;
import com.dxfeed.event.candle.impl.TradeHistoryMapping;
import java.util.EnumSet;

public final class CandleByTradeHistoryDelegate
extends CandleEventDelegateImpl<Candle> {
    private final TradeHistoryMapping m;

    public CandleByTradeHistoryDelegate(DataRecord record, QDContract contract, EnumSet<EventDelegateFlags> flags) {
        super(record, contract, flags);
        this.m = record.getMapping(TradeHistoryMapping.class);
    }

    @Override
    public TradeHistoryMapping getMapping() {
        return this.m;
    }

    @Override
    public Candle createEvent() {
        return new Candle();
    }

    @Override
    public Candle getEvent(Candle event, RecordCursor cursor) {
        super.getEvent(event, cursor);
        event.setEventFlags(cursor.getEventFlags());
        event.setIndex((long)this.m.getTimeSeconds(cursor) << 32 | (long)this.m.getSequence(cursor) & 0xFFFFFFFFL);
        event.setCount(1L);
        event.setClose(this.m.getClose(cursor));
        event.setVolumeAsDouble(this.m.getVolumeDouble(cursor));
        event.setOpen(event.getClose());
        event.setHigh(event.getClose());
        event.setLow(event.getClose());
        return event;
    }

    @Override
    public RecordCursor putEvent(Candle event, RecordBuffer buf) {
        RecordCursor cursor = super.putEvent(event, buf);
        cursor.setEventFlags(event.getEventFlags());
        this.m.setTimeSeconds(cursor, (int)(event.getIndex() >>> 32));
        this.m.setSequence(cursor, (int)event.getIndex());
        this.m.setClose(cursor, event.getClose());
        this.m.setVolumeDouble(cursor, event.getVolumeAsDouble());
        return cursor;
    }
}

