/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.api.impl;

import com.devexperts.util.GlobListUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;

public class SchemeProperties {
    private final Map<String, String> patternStrings = new HashMap<String, String>();
    private final Map<String, Pattern> patterns = new HashMap<String, Pattern>();

    public SchemeProperties(Properties props) {
        props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(objKey, objValue) -> {
            String key = (String)objKey;
            if (key.startsWith("dxscheme.enabled.")) {
                String propertyName = key.substring("dxscheme.enabled.".length());
                this.enableEventPropertyIfAbsent(propertyName, (String)objValue);
            }
        }));
        if (Boolean.parseBoolean(props.getProperty("dxscheme.nanoTime"))) {
            this.enableEventPropertyIfAbsent("Sequence", "*");
            this.enableEventPropertyIfAbsent("TimeNanoPart", "*");
        }
    }

    public boolean equals(Object o) {
        return this == o || o instanceof SchemeProperties && this.patternStrings.equals(((SchemeProperties)o).patternStrings);
    }

    public int hashCode() {
        return this.patternStrings.hashCode();
    }

    private void enableEventPropertyIfAbsent(String propertyName, String patternString) {
        if (this.patternStrings.containsKey(propertyName)) {
            return;
        }
        this.patternStrings.put(propertyName, patternString);
        this.patterns.put(propertyName, GlobListUtil.compile(patternString));
    }

    Boolean isEventPropertyEnabled(String propertyName, String eventName) {
        Pattern pattern = this.patterns.get(propertyName);
        if (pattern == null) {
            return null;
        }
        return pattern.matcher(eventName).matches();
    }
}

