/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.api.impl;

import com.devexperts.qd.DataIntField;
import com.devexperts.qd.DataObjField;
import com.devexperts.qd.DataRecord;
import com.devexperts.qd.SerialFieldType;
import com.devexperts.qd.kit.DefaultRecord;
import com.devexperts.qd.kit.VoidIntField;
import com.dxfeed.api.impl.SchemeFieldTime;
import com.dxfeed.api.impl.SchemeProperties;
import com.dxfeed.api.impl.VersionedRecord;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

public class SchemeBuilder {
    private final Map<String, RecordInfo> records = new LinkedHashMap<String, RecordInfo>();
    @Nonnull
    private final SchemeProperties schemeProperties;

    public SchemeBuilder(@Nonnull SchemeProperties schemeProperties) {
        this.schemeProperties = Objects.requireNonNull(schemeProperties);
    }

    public void addField(String recordName, String fieldName, SerialFieldType type) {
        this.addFieldInternal(recordName, fieldName, type, SchemeFieldTime.COMMON_FIELD);
    }

    public void addField(String recordName, String fieldName, SerialFieldType type, SchemeFieldTime time) {
        this.addFieldInternal(recordName, fieldName, type, time);
    }

    public void addRequiredField(String recordName, String fieldName, SerialFieldType type, SchemeFieldTime time) {
        this.addFieldInternal(recordName, fieldName, type, time);
    }

    public void addRequiredField(String recordName, String fieldName, SerialFieldType type) {
        this.addRequiredField(recordName, fieldName, type, SchemeFieldTime.COMMON_FIELD);
    }

    public void addOptionalField(String recordName, String fieldName, SerialFieldType type, String eventName, String propertyName, boolean enabledByDefault, SchemeFieldTime time) {
        Boolean enabledInProperties = this.schemeProperties.isEventPropertyEnabled(propertyName, eventName);
        if (enabledInProperties != null) {
            enabledByDefault = enabledInProperties;
        }
        if (!enabledByDefault) {
            return;
        }
        this.addFieldInternal(recordName, fieldName, type, time);
    }

    public void addOptionalField(String recordName, String fieldName, SerialFieldType type, String eventName, String propertyName, boolean enabledByDefault) {
        this.addOptionalField(recordName, fieldName, type, eventName, propertyName, enabledByDefault, SchemeFieldTime.COMMON_FIELD);
    }

    private void addFieldInternal(String recordName, String fieldName, SerialFieldType type, SchemeFieldTime time) {
        RecordInfo info = this.records.get(recordName);
        if (info == null) {
            info = new RecordInfo(recordName);
            this.records.put(recordName, info);
        }
        String name = recordName + "." + fieldName;
        info.addField(name, type.forNamedField(name), time);
    }

    public DataRecord[] buildRecords() {
        DataRecord[] result = new DataRecord[this.records.size()];
        int id = 0;
        for (int regional = 0; regional < 2; ++regional) {
            for (RecordInfo info : this.records.values()) {
                if (regional != 0 != (info.recordName.length() > 2 && info.recordName.charAt(info.recordName.length() - 2) == '&')) continue;
                result[id] = info.createRecord(id);
                ++id;
            }
        }
        return result;
    }

    private static class RecordInfo {
        final String recordName;
        final LinkedHashMap<String, SerialFieldType> fields = new LinkedHashMap();
        int intFieldsCount;
        int objFieldsCount;
        String[] timeFields = new String[2];

        RecordInfo(String recordName) {
            this.recordName = recordName;
        }

        void addField(String fieldName, SerialFieldType type, SchemeFieldTime time) {
            SerialFieldType oldType;
            if (time != SchemeFieldTime.COMMON_FIELD) {
                int timeFieldIndex;
                if (type.isObject()) {
                    throw new IllegalArgumentException("Failed to create default data-scheme: " + fieldName + " time-field must have integer type");
                }
                int n = timeFieldIndex = time == SchemeFieldTime.FIRST_TIME_INT_FIELD ? 0 : 1;
                if (this.timeFields[timeFieldIndex] == null) {
                    this.timeFields[timeFieldIndex] = fieldName;
                } else if (!this.timeFields[timeFieldIndex].equals(fieldName)) {
                    throw new IllegalArgumentException("Failed to create default data-scheme: different time-fields proposed for " + this.recordName + " record");
                }
            }
            if ((oldType = this.fields.get(fieldName)) == null) {
                if (type.isObject()) {
                    ++this.objFieldsCount;
                } else {
                    this.intFieldsCount = type.isLong() ? (this.intFieldsCount += 2) : ++this.intFieldsCount;
                }
                this.fields.put(fieldName, type);
            } else if (oldType != type) {
                throw new IllegalArgumentException("Failed to create default data-scheme: " + fieldName + " field has several different types");
            }
        }

        public DataRecord createRecord(int id) {
            boolean hasTime;
            int intIndex = 0;
            int objIndex = 0;
            boolean bl = hasTime = this.timeFields[0] != null || this.timeFields[1] != null;
            if (hasTime) {
                for (int i = 0; i < 2; ++i) {
                    if (this.timeFields[i] != null) continue;
                    this.addField(this.recordName + ".$VoidTimeField", SerialFieldType.VOID, i == 0 ? SchemeFieldTime.FIRST_TIME_INT_FIELD : SchemeFieldTime.SECOND_TIME_INT_FIELD);
                }
                intIndex = 2;
            }
            DataIntField[] intFields = new DataIntField[this.intFieldsCount];
            DataObjField[] objFields = new DataObjField[this.objFieldsCount];
            for (Map.Entry<String, SerialFieldType> entry : this.fields.entrySet()) {
                SerialFieldType type = entry.getValue();
                String fieldName = entry.getKey();
                if (type.isObject()) {
                    DataObjField field = type.createDefaultObjInstance(objIndex, fieldName);
                    if (field == null) {
                        throw new IllegalArgumentException("Cannot construct field " + fieldName + " of type " + type);
                    }
                    objFields[objIndex] = field;
                    ++objIndex;
                    continue;
                }
                int index = hasTime && fieldName.equals(this.timeFields[0]) ? 0 : (hasTime && fieldName.equals(this.timeFields[1]) ? 1 : intIndex++);
                DataIntField field = type.createDefaultIntInstance(index, fieldName);
                if (field == null) {
                    throw new IllegalArgumentException("Cannot construct field " + fieldName + " of type " + type);
                }
                intFields[index] = field;
                if (!type.isLong()) continue;
                if (index + 1 != intIndex) {
                    throw new IllegalArgumentException("Cannot add void tail for " + fieldName + " of type " + type + " at index " + index);
                }
                intFields[intIndex] = new VoidIntField(intIndex, fieldName + "$VoidTail");
                ++intIndex;
            }
            if (this.recordName.equals("Configuration")) {
                return new VersionedRecord(id, this.recordName, hasTime, intFields, objFields, "Version");
            }
            return new DefaultRecord(id, this.recordName, hasTime, intFields, objFields);
        }
    }
}

