/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.api.impl;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.HistorySubscriptionFilter;
import com.devexperts.qd.kit.TimeField;
import com.devexperts.services.ServiceProvider;
import com.devexperts.util.SynchronizedIndexedSet;
import com.devexperts.util.SystemProperties;
import com.dxfeed.event.candle.impl.CandleMapping;
import com.dxfeed.event.candle.impl.TradeHistoryMapping;
import com.dxfeed.event.market.impl.TimeAndSaleMapping;
import com.dxfeed.event.option.impl.GreeksMapping;
import com.dxfeed.event.option.impl.TheoPriceMapping;
import com.dxfeed.event.option.impl.UnderlyingMapping;
import java.util.Arrays;

@ServiceProvider(order=100)
public class HistorySubscriptionFilterImpl
implements HistorySubscriptionFilter {
    private final int candleMaxRecordCount = SystemProperties.getIntProperty(HistorySubscriptionFilterImpl.class, "maxRecordCount.candle", SystemProperties.getIntProperty(HistorySubscriptionFilterImpl.class, "candleMaxRecordCount", 8000));
    private final int timeSeriesMaxRecordCount = SystemProperties.getIntProperty(HistorySubscriptionFilterImpl.class, "maxRecordCount.timeSeries", SystemProperties.getIntProperty(HistorySubscriptionFilterImpl.class, "tradeMaxRecordCount", 1000));
    private final int indexedMaxRecordCount = SystemProperties.getIntProperty(HistorySubscriptionFilterImpl.class, "maxRecordCount.indexed", Integer.MAX_VALUE);
    private final SynchronizedIndexedSet<DataRecord, RecordLimit> maxRecordCounts = SynchronizedIndexedSet.create(RecordLimit::getRecord);
    private volatile RecordLimit[] maxRecordCache = new RecordLimit[256];

    @Override
    public long getMinHistoryTime(DataRecord record, int cipher, String symbol) {
        return Long.MIN_VALUE;
    }

    @Override
    public int getMaxRecordCount(DataRecord record, int cipher, String symbol) {
        RecordLimit limit;
        RecordLimit[] cache;
        int id = record.getId();
        if (id >= (cache = this.maxRecordCache).length) {
            this.maxRecordCache = cache = Arrays.copyOf(cache, Math.max(cache.length * 2, id + 1));
        }
        if ((limit = cache[id]) == null || limit.getRecord() != record) {
            limit = (RecordLimit)this.maxRecordCounts.getByKey(record);
            if (limit == null) {
                limit = this.maxRecordCounts.putIfAbsentAndGet(this.createRecordLimit(record));
            }
            cache[id] = limit;
        }
        return limit.getLimit();
    }

    private RecordLimit createRecordLimit(DataRecord record) {
        int defaultMaxRecordCount = record.getMapping(CandleMapping.class) != null ? this.candleMaxRecordCount : (record.getMapping(TimeAndSaleMapping.class) != null || record.getMapping(TradeHistoryMapping.class) != null || record.getMapping(UnderlyingMapping.class) != null || record.getMapping(TheoPriceMapping.class) != null || record.getMapping(GreeksMapping.class) != null || record.getIntFieldCount() > 0 && record.getIntField(0) instanceof TimeField ? this.timeSeriesMaxRecordCount : (record.hasTime() ? this.indexedMaxRecordCount : 0));
        String propName = this.generatePropertyName(record);
        int maxRecordCount = SystemProperties.getIntProperty(HistorySubscriptionFilterImpl.class, propName, defaultMaxRecordCount);
        return new RecordLimit(record, maxRecordCount);
    }

    public String toString() {
        return "HistorySubscriptionFilterImpl{candle=" + this.candleMaxRecordCount + ", timeSeries=" + this.timeSeriesMaxRecordCount + ", indexed=" + this.indexedMaxRecordCount + "}";
    }

    private String generatePropertyName(DataRecord record) {
        return "maxRecordCount." + record.getName();
    }

    private static class RecordLimit {
        private final DataRecord record;
        private final int limit;

        RecordLimit(DataRecord record, int limit) {
            this.record = record;
            this.limit = limit;
        }

        DataRecord getRecord() {
            return this.record;
        }

        public int getLimit() {
            return this.limit;
        }
    }
}

