/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.api.impl;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.DataScheme;
import com.devexperts.qd.QDContract;
import com.devexperts.qd.QDFilter;
import com.devexperts.qd.SpecificSubscriptionFilter;
import com.devexperts.qd.kit.CompositeFilters;
import com.devexperts.qd.kit.FilterSyntaxException;
import com.devexperts.qd.kit.PatternFilter;
import com.devexperts.qd.spi.QDFilterContext;
import com.devexperts.qd.spi.QDFilterFactory;
import com.devexperts.services.ServiceProvider;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

@ServiceProvider(order=-100)
public class FilterFactoryImpl
extends QDFilterFactory {
    private static final String COMPFEED_RECORDS = "Quote, Trade, TradeETH, Summary, Fundamental, Profile, Book, Order*, SpreadOrder*, MarketMaker, TimeAndSale, TradeHistory";
    private static final String CHARTDATA_RECORDS = "TradeHistory, Trade.*, Candle, Candle[{]*, DividendHistory, SplitHistory, EarningsHistory, ConferenceCallHistory, NewsHistory";
    @SpecificSubscriptionFilter(value="conversion rate filter, accepts composite and regional Quote records, accepts conversion rate symbols like ([A-Z]{3}$/[A-Z]{3}$)|([A-Z]{3}$FX/[A-Z]{3}$FX), no optional symbol parameters are accepted")
    public static final String CONVRATES = "convrates";
    @SpecificSubscriptionFilter(value="NoWildCard filter, accepts all records, prohibits wildcard symbol")
    public static final String NWC = "nwc";
    @SpecificSubscriptionFilter(value="accepts data provided by charting server via history contract: TradeHistory, Trade.*, Candle, Candle[{]*, DividendHistory, SplitHistory, EarningsHistory, ConferenceCallHistory, NewsHistory")
    public static final String CHARTDATA = "chartdata";
    @SpecificSubscriptionFilter(value="accepts composite and regional records forming exchange data feed: Quote, Trade, TradeETH, Summary, Fundamental, Profile, Book, Order*, SpreadOrder*, MarketMaker, TimeAndSale, TradeHistory")
    public static final String FEED = "feed";
    @SpecificSubscriptionFilter(value="accepts composite records forming exchange data feed")
    public static final String COMPFEED = "compfeed";
    @SpecificSubscriptionFilter(value="accepts regional records forming exchange data feed")
    public static final String REGFEED = "regfeed";
    private static final String SYMBOL_SUFFIX = "symbol";
    @SpecificSubscriptionFilter(value="The following symbol-based filters exist in 2 variants:\nsymbol-only (record agnostic) or including additional \"feed\" filter, e.g. \"opt = optsymbol & feed\", \"fx = fxsymbol & feed\", etc.")
    public static final String SYMBOL_DESC = "*symbol";
    @SpecificSubscriptionFilter(value="basic symbol aka [^/.=]* (not future, not option, not spread)")
    public static final String BS = "bs";
    @SpecificSubscriptionFilter(value="future symbol aka /*")
    public static final String FUT = "fut";
    @SpecificSubscriptionFilter(value="option symbol aka .*")
    public static final String OPT = "opt";
    @SpecificSubscriptionFilter(value="spread symbol aka =*")
    public static final String SPREAD = "spread";
    @SpecificSubscriptionFilter(value="non-option symbol aka [^.]*")
    public static final String CS = "cs";
    @SpecificSubscriptionFilter(value="equity option symbol aka .[^/]*")
    public static final String CSOPT = "csopt";
    @SpecificSubscriptionFilter(value="basic symbol option symbol aka .[^/]*")
    public static final String BSOPT = "bsopt";
    @SpecificSubscriptionFilter(value="future option symbol aka ./*")
    public static final String FUTOPT = "futopt";
    @SpecificSubscriptionFilter(value="indicator or index (non-exchange) symbol aka $*")
    public static final String IND = "ind";
    @SpecificSubscriptionFilter(value="product symbol aka /[A-Z0-9]{1,3}, accepts optional symbol parameters like {tho=true} or {price=bid}, accepts optional symbol namespace like :XCME or :RTSX")
    public static final String PROD = "prod";
    @SpecificSubscriptionFilter(value="forex symbol aka [A-Z]{3,4}/[A-Z]{3} with optional suffix hash, accepts optional symbol parameters like {tho=true} or {price=bid}, accepts optional symbol namespace like :XCME or :RTSX")
    public static final String FX = "fx";

    @Override
    public QDFilter createFilter(String spec) {
        return this.createFilter(spec, QDFilterContext.DEFAULT);
    }

    @Override
    public QDFilter createFilter(String spec, QDFilterContext context) {
        QDFilter filter = this.parseCategoryFilter(spec);
        if (filter != null) {
            return filter;
        }
        filter = this.parseSymbolFilter(spec);
        if (filter != null) {
            return filter;
        }
        filter = this.parseSymbolFilter(spec + SYMBOL_SUFFIX);
        if (filter != null && context != QDFilterContext.SYMBOL_SET) {
            return CompositeFilters.makeAnd(filter, this.parseCategoryFilter(FEED));
        }
        return filter;
    }

    public QDFilter parseCategoryFilter(String spec) {
        if (spec.equals(CONVRATES)) {
            return new ConversionRateFilter(this.getScheme());
        }
        if (spec.equals(NWC)) {
            return new NWCFilter(this.getScheme());
        }
        if (spec.equals(CHARTDATA)) {
            return CompositeFilters.valueOf(FilterFactoryImpl.makeFilter(CHARTDATA_RECORDS, ""), spec, this.getScheme());
        }
        if (spec.equals(FEED)) {
            return CompositeFilters.valueOf(FilterFactoryImpl.makeFilter(COMPFEED_RECORDS, "") + "," + FilterFactoryImpl.makeFilter(COMPFEED_RECORDS, "[&][A-Z]"), spec, this.getScheme());
        }
        if (spec.equals(COMPFEED)) {
            return CompositeFilters.valueOf(FilterFactoryImpl.makeFilter(COMPFEED_RECORDS, ""), spec, this.getScheme());
        }
        if (spec.equals(REGFEED)) {
            return CompositeFilters.valueOf(FilterFactoryImpl.makeFilter(COMPFEED_RECORDS, "[&][A-Z]"), spec, this.getScheme());
        }
        return null;
    }

    private static String makeFilter(String records, String suffix) {
        StringBuilder sb = new StringBuilder();
        StringTokenizer st = new StringTokenizer(records, ", ");
        while (st.hasMoreTokens()) {
            String recordMask = st.nextToken();
            if (recordMask.endsWith("*") && !suffix.isEmpty()) continue;
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(':').append(recordMask).append(suffix);
        }
        return sb.toString();
    }

    private QDFilter parseSymbolFilter(String spec) throws FilterSyntaxException {
        if (spec.equals("bssymbol")) {
            return PatternFilter.valueOf("[^/.=]*", spec, this.getScheme());
        }
        if (spec.equals("futsymbol")) {
            return PatternFilter.valueOf("/*", spec, this.getScheme());
        }
        if (spec.equals("optsymbol")) {
            return PatternFilter.valueOf(".*", spec, this.getScheme());
        }
        if (spec.equals("spreadsymbol")) {
            return PatternFilter.valueOf("=*", spec, this.getScheme());
        }
        if (spec.equals("cssymbol")) {
            return PatternFilter.valueOf("[^.]*", spec, this.getScheme());
        }
        if (spec.equals("csoptsymbol")) {
            return PatternFilter.valueOf(".[^/]*", spec, this.getScheme());
        }
        if (spec.equals("bsoptsymbol")) {
            return PatternFilter.valueOf(".[^/]*", spec, this.getScheme());
        }
        if (spec.equals("futoptsymbol")) {
            return PatternFilter.valueOf("./*", spec, this.getScheme());
        }
        if (spec.equals("indsymbol")) {
            return PatternFilter.valueOf("$*", spec, this.getScheme());
        }
        if (spec.equals("prodsymbol")) {
            return new ProductSymbolFilter(this.getScheme());
        }
        if (spec.equals("fxsymbol")) {
            return new ForexSymbolFilter(this.getScheme());
        }
        return null;
    }

    private static class NWCFilter
    extends QDFilter {
        private final int wildcard;

        NWCFilter(DataScheme scheme) {
            super(scheme);
            this.wildcard = scheme.getCodec().getWildcardCipher();
        }

        @Override
        public boolean isFast() {
            return true;
        }

        @Override
        public boolean accept(QDContract contract, DataRecord record, int cipher, String symbol) {
            return cipher != this.wildcard;
        }

        @Override
        public QDFilter toStableFilter() {
            return this;
        }

        @Override
        public String getDefaultName() {
            return FilterFactoryImpl.NWC;
        }
    }

    private static class ConversionRateFilter
    extends QDFilter {
        private final int wildcard;
        private final boolean[] accepts;

        ConversionRateFilter(DataScheme scheme) {
            super(scheme);
            this.wildcard = scheme.getCodec().getWildcardCipher();
            this.accepts = new boolean[scheme.getRecordCount()];
            Pattern regex = Pattern.compile("Quote(&[A-Z])?");
            for (int i = 0; i < this.accepts.length; ++i) {
                this.accepts[i] = regex.matcher(scheme.getRecord(i).getName()).matches();
            }
        }

        @Override
        public boolean isFast() {
            return true;
        }

        @Override
        public boolean accept(QDContract contract, DataRecord record, int cipher, String symbol) {
            int id = record.getId();
            if (id >= this.accepts.length || !this.accepts[id]) {
                return false;
            }
            if (cipher != 0) {
                return cipher == this.wildcard;
            }
            return this.acceptSymbol(symbol);
        }

        private boolean acceptSymbol(String symbol) {
            if (symbol == null) {
                return false;
            }
            if (symbol.length() == 9) {
                return symbol.charAt(3) == '$' && symbol.charAt(4) == '/' && symbol.charAt(8) == '$' && ConversionRateFilter.isChar(symbol.charAt(0)) && ConversionRateFilter.isChar(symbol.charAt(1)) && ConversionRateFilter.isChar(symbol.charAt(2)) && ConversionRateFilter.isChar(symbol.charAt(5)) && ConversionRateFilter.isChar(symbol.charAt(6)) && ConversionRateFilter.isChar(symbol.charAt(7));
            }
            if (symbol.length() == 13) {
                return symbol.charAt(3) == '$' && symbol.charAt(4) == 'F' && symbol.charAt(5) == 'X' && symbol.charAt(6) == '/' && symbol.charAt(10) == '$' && symbol.charAt(11) == 'F' && symbol.charAt(12) == 'X' && ConversionRateFilter.isChar(symbol.charAt(0)) && ConversionRateFilter.isChar(symbol.charAt(1)) && ConversionRateFilter.isChar(symbol.charAt(2)) && ConversionRateFilter.isChar(symbol.charAt(7)) && ConversionRateFilter.isChar(symbol.charAt(8)) && ConversionRateFilter.isChar(symbol.charAt(9));
            }
            return false;
        }

        private static boolean isChar(char c) {
            return c >= 'A' && c <= 'Z';
        }

        @Override
        public QDFilter toStableFilter() {
            return this;
        }

        @Override
        public String getDefaultName() {
            return FilterFactoryImpl.CONVRATES;
        }
    }

    private static class ForexSymbolFilter
    extends QDFilter {
        private final int wildcard;
        private final boolean negated;

        ForexSymbolFilter(DataScheme scheme) {
            this(scheme, false);
        }

        private ForexSymbolFilter(DataScheme scheme, boolean negated) {
            super(scheme);
            this.wildcard = scheme.getCodec().getWildcardCipher();
            this.negated = negated;
        }

        @Override
        public QDFilter.Kind getKind() {
            return QDFilter.Kind.OTHER_SYMBOL_ONLY;
        }

        @Override
        public boolean isFast() {
            return true;
        }

        @Override
        public QDFilter negate() {
            return new ForexSymbolFilter(this.getScheme(), !this.negated);
        }

        @Override
        public boolean accept(QDContract contract, DataRecord record, int cipher, String symbol) {
            if (cipher == this.wildcard) {
                return true;
            }
            if (cipher != 0) {
                return this.negated;
            }
            return this.negated ^ this.acceptSymbol(symbol);
        }

        private boolean acceptSymbol(String symbol) {
            if (symbol == null || symbol.length() < 7) {
                return false;
            }
            if (symbol.charAt(3) == '/') {
                return ForexSymbolFilter.isChar(symbol.charAt(0)) && ForexSymbolFilter.isChar(symbol.charAt(1)) && ForexSymbolFilter.isChar(symbol.charAt(2)) && ForexSymbolFilter.isChar(symbol.charAt(4)) && ForexSymbolFilter.isChar(symbol.charAt(5)) && ForexSymbolFilter.isChar(symbol.charAt(6)) && (symbol.length() <= 7 || ForexSymbolFilter.isEnding(symbol.charAt(7)));
            }
            if (symbol.charAt(4) == '/' && symbol.length() >= 8) {
                return ForexSymbolFilter.isChar(symbol.charAt(0)) && ForexSymbolFilter.isChar(symbol.charAt(1)) && ForexSymbolFilter.isChar(symbol.charAt(2)) && ForexSymbolFilter.isChar(symbol.charAt(3)) && ForexSymbolFilter.isChar(symbol.charAt(5)) && ForexSymbolFilter.isChar(symbol.charAt(6)) && ForexSymbolFilter.isChar(symbol.charAt(7)) && (symbol.length() <= 8 || ForexSymbolFilter.isEnding(symbol.charAt(8)));
            }
            return false;
        }

        private static boolean isChar(char c) {
            return c >= 'A' && c <= 'Z';
        }

        private static boolean isEnding(char c) {
            return c == '#' || c == '{' || c == ':';
        }

        @Override
        public QDFilter toStableFilter() {
            return this;
        }

        @Override
        public String getDefaultName() {
            return (this.negated ? "!" : "") + FilterFactoryImpl.FX + FilterFactoryImpl.SYMBOL_SUFFIX;
        }
    }

    private static class ProductSymbolFilter
    extends QDFilter {
        private final int wildcard;
        private final boolean negated;

        ProductSymbolFilter(DataScheme scheme) {
            this(scheme, false);
        }

        private ProductSymbolFilter(DataScheme scheme, boolean negated) {
            super(scheme);
            this.wildcard = scheme.getCodec().getWildcardCipher();
            this.negated = negated;
        }

        @Override
        public QDFilter.Kind getKind() {
            return QDFilter.Kind.OTHER_SYMBOL_ONLY;
        }

        @Override
        public boolean isFast() {
            return true;
        }

        @Override
        public QDFilter negate() {
            return new ProductSymbolFilter(this.getScheme(), !this.negated);
        }

        @Override
        public boolean accept(QDContract contract, DataRecord record, int cipher, String symbol) {
            if (cipher == this.wildcard) {
                return true;
            }
            if (symbol != null) {
                return this.negated ^ this.acceptSymbol(symbol);
            }
            return this.negated ^ this.acceptCode(this.getScheme().getCodec().decodeToLong(cipher));
        }

        private boolean acceptCode(long code) {
            if (code >>> 56 != 47L) {
                return false;
            }
            for (int i = 1; i <= 4; ++i) {
                int c = (int)(code >>> (7 - i << 3)) & 0xFF;
                if (c == 0 || c == 123 || c == 58) {
                    return i >= 2 && i <= 4;
                }
                if (c >= 65 && c <= 90 || c >= 48 && c <= 57) continue;
                return false;
            }
            return false;
        }

        private boolean acceptSymbol(String symbol) {
            int n = symbol.length();
            if (n < 2) {
                return false;
            }
            if (symbol.charAt(0) != '/') {
                return false;
            }
            for (int i = 1; i <= 4 && i < n; ++i) {
                char c = symbol.charAt(i);
                if (c == '{' || c == ':') {
                    return i >= 2 && i <= 4;
                }
                if (c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') continue;
                return false;
            }
            return n <= 4;
        }

        @Override
        public String getDefaultName() {
            return (this.negated ? "!" : "") + FilterFactoryImpl.PROD + FilterFactoryImpl.SYMBOL_SUFFIX;
        }

        @Override
        public QDFilter toStableFilter() {
            return this;
        }
    }
}

