/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.api.impl;

import com.dxfeed.api.impl.EventDelegate;
import com.dxfeed.api.osub.WildcardSymbol;
import com.dxfeed.event.EventType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class EventDelegateSet<T extends EventType<?>, D extends EventDelegate<T>> {
    protected final Class<T> eventType;
    protected final List<D> allSubDelegates = new ArrayList<D>();
    protected final List<D> allPubDelegates = new ArrayList<D>();
    protected final List<D> allTimeSeriesDelegates = new ArrayList<D>();
    protected final List<D> allWildcardDelegates = new ArrayList<D>();
    protected final List<D> allLastingDelegates = new ArrayList<D>();
    protected boolean complete;

    public EventDelegateSet(Class<T> eventType) {
        this.eventType = eventType;
    }

    public Class<T> eventType() {
        return this.eventType;
    }

    public void add(D delegate) {
        if (this.complete) {
            throw new IllegalStateException();
        }
        if (((EventDelegate)delegate).isSub()) {
            if (((EventDelegate)delegate).isTimeSeries()) {
                this.allTimeSeriesDelegates.add(delegate);
            } else {
                this.allSubDelegates.add(delegate);
            }
            if (((EventDelegate)delegate).isLastingEvent()) {
                this.allLastingDelegates.add(delegate);
            }
        }
        if (((EventDelegate)delegate).isPub()) {
            this.allPubDelegates.add(delegate);
        }
        if (((EventDelegate)delegate).isWildcard()) {
            this.allWildcardDelegates.add(delegate);
        }
    }

    public void completeConstruction() {
        this.complete = true;
    }

    public Object convertSymbol(Object symbol) {
        return symbol;
    }

    public List<D> getSubDelegatesBySubscriptionSymbol(Object symbol, int sourceId) {
        if (symbol instanceof WildcardSymbol) {
            return this.allWildcardDelegates;
        }
        if (symbol.toString().startsWith("*")) {
            return Collections.emptyList();
        }
        return this.getRegularSubDelegatesBySubscriptionSymbol(symbol, sourceId);
    }

    protected List<D> getRegularSubDelegatesBySubscriptionSymbol(Object symbol, int sourceId) {
        return sourceId <= 0 ? this.allSubDelegates : Collections.emptyList();
    }

    public List<D> getTimeSeriesDelegatesByEventSymbol(Object symbol) {
        return this.allTimeSeriesDelegates;
    }

    public D getLastingDelegateByEventSymbol(Object symbol) {
        return (D)(this.allLastingDelegates.isEmpty() ? null : (EventDelegate)this.allLastingDelegates.get(0));
    }

    public List<D> getPubDelegatesByEvent(T event) {
        return this.allPubDelegates;
    }

    public List<D> getAllPubDelegates() {
        return this.allPubDelegates;
    }
}

