/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.api.impl;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.QDContract;
import com.devexperts.qd.SymbolCodec;
import com.devexperts.qd.ng.RecordBuffer;
import com.devexperts.qd.ng.RecordCursor;
import com.devexperts.qd.ng.RecordMapping;
import com.devexperts.qd.util.TimeSequenceUtil;
import com.devexperts.util.Timing;
import com.dxfeed.api.impl.EventDelegateFlags;
import com.dxfeed.api.impl.EventDelegateSet;
import com.dxfeed.api.osub.TimeSeriesSubscriptionSymbol;
import com.dxfeed.event.EventType;
import com.dxfeed.event.LastingEvent;
import com.dxfeed.event.TimeSeriesEvent;
import java.util.EnumSet;

public abstract class EventDelegate<T extends EventType<?>> {
    protected final DataRecord record;
    protected final QDContract contract;
    protected final boolean sub;
    protected final boolean pub;
    protected final boolean timeSeries;
    protected final boolean wildcard;
    protected final SymbolCodec codec;
    protected final Class<T> eventType;
    protected final boolean lastingEvent;

    protected EventDelegate(DataRecord record, QDContract contract, EnumSet<EventDelegateFlags> flags) {
        this.record = record;
        this.contract = contract;
        this.sub = flags.contains((Object)EventDelegateFlags.SUB);
        this.pub = flags.contains((Object)EventDelegateFlags.PUB);
        this.timeSeries = flags.contains((Object)EventDelegateFlags.TIME_SERIES);
        this.wildcard = flags.contains((Object)EventDelegateFlags.WILDCARD);
        this.codec = record.getScheme().getCodec();
        this.eventType = this.createEvent().getClass();
        boolean timeSeriesEvent = TimeSeriesEvent.class.isAssignableFrom(this.eventType);
        if (this.timeSeries && !timeSeriesEvent) {
            throw new IllegalArgumentException("Cannot create time series delegate for non time series event " + this.eventType);
        }
        this.lastingEvent = LastingEvent.class.isAssignableFrom(this.eventType);
    }

    public final Class<T> getEventType() {
        return this.eventType;
    }

    public final DataRecord getRecord() {
        return this.record;
    }

    public final QDContract getContract() {
        return this.contract;
    }

    public final boolean isSub() {
        return this.sub;
    }

    public boolean isPub() {
        return this.pub;
    }

    public final boolean isTimeSeries() {
        return this.timeSeries;
    }

    public boolean isWildcard() {
        return this.wildcard;
    }

    public final boolean isLastingEvent() {
        return this.lastingEvent;
    }

    public EventDelegateSet<T, ? extends EventDelegate<T>> createDelegateSet() {
        return new EventDelegateSet(this.eventType);
    }

    public String getQDSymbolByEventSymbol(Object symbol) {
        return this.getMapping().getQDSymbolByEventSymbol(symbol);
    }

    public Object getEventSymbolByQDSymbol(String qdSymbol) {
        return this.getMapping().getEventSymbolByQDSymbol(qdSymbol);
    }

    public long getQDTimeByEventTime(long time) {
        return time == Long.MAX_VALUE ? Long.MAX_VALUE : TimeSequenceUtil.getTimeSequenceFromTimeMillis(time);
    }

    public long getEventTimeByQDTime(long time) {
        return time == Long.MAX_VALUE ? Long.MAX_VALUE : TimeSequenceUtil.getTimeMillisFromTimeSequence(time);
    }

    public long getFetchTimeHeuristicByEventSymbolAndFromTime(Object eventSymbol, long fromTime) {
        Timing.Day day = Timing.EST.getByTime(fromTime);
        while (!(day = Timing.EST.getById(day.day_id - 1)).isTrading()) {
        }
        return day.day_start;
    }

    public String getQDSymbolByEvent(T event) {
        return this.getQDSymbolByEventSymbol(event.getEventSymbol());
    }

    public Object getSubscriptionSymbolByQDSymbolAndTime(String qdSymbol, long time) {
        Object eventSymbol = this.getEventSymbolByQDSymbol(qdSymbol);
        return this.timeSeries ? new TimeSeriesSubscriptionSymbol<Object>(eventSymbol, this.getEventTimeByQDTime(time)) : eventSymbol;
    }

    public T createEvent(Object symbol, RecordCursor cursor) {
        Object event = this.createEvent();
        event.setEventSymbol((Object)symbol);
        return this.getEvent(event, cursor);
    }

    public T createEvent(RecordCursor cursor) {
        return this.createEvent(this.getEventSymbolByQDSymbol(this.codec.decode(cursor.getCipher(), cursor.getSymbol())), cursor);
    }

    public abstract RecordMapping getMapping();

    public abstract T createEvent();

    public T getEvent(T event, RecordCursor cursor) {
        event.setEventTime(TimeSequenceUtil.getTimeMillisFromTimeSequence(cursor.getEventTimeSequence()));
        return event;
    }

    public RecordCursor putEvent(T event, RecordBuffer buf) {
        String symbol = this.getQDSymbolByEvent(event);
        RecordCursor cursor = buf.add(this.record, this.codec.encode(symbol), symbol);
        if (cursor.hasEventTimeSequence()) {
            cursor.setEventTimeSequence(TimeSequenceUtil.getTimeSequenceFromTimeMillis(event.getEventTime()));
        }
        return cursor;
    }

    public String toString() {
        return "EventDelegate{eventType=" + this.eventType.getName() + ", record=" + this.record + ", contract=" + this.contract + ", sub=" + this.sub + ", pub=" + this.pub + ", timeSeries=" + this.timeSeries + ", wildcard=" + this.wildcard + '}';
    }
}

