/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.api.impl;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.kit.DefaultScheme;
import com.devexperts.qd.kit.PentaCodec;
import com.devexperts.services.ServiceProvider;
import com.devexperts.services.Services;
import com.dxfeed.api.impl.EventDelegateFactory;
import com.dxfeed.api.impl.SchemeBuilder;
import com.dxfeed.api.impl.SchemeProperties;
import javax.annotation.Nonnull;

@ServiceProvider(order=100)
public class DXFeedScheme
extends DefaultScheme {
    private static final SchemeProperties DEFAULT_PROPERTIES = new SchemeProperties(System.getProperties());
    private static final Iterable<? extends EventDelegateFactory> EVENT_DELEGATE_FACTORIES = Services.createServices(EventDelegateFactory.class, null);
    private static final DXFeedScheme INSTANCE = new DXFeedScheme(EVENT_DELEGATE_FACTORIES, DEFAULT_PROPERTIES);

    public static DXFeedScheme getInstance() {
        return INSTANCE;
    }

    static DXFeedScheme withProperties(@Nonnull SchemeProperties schemeProperties) {
        if (schemeProperties.equals(DEFAULT_PROPERTIES)) {
            return INSTANCE;
        }
        return new DXFeedScheme(EVENT_DELEGATE_FACTORIES, schemeProperties);
    }

    protected DXFeedScheme(Iterable<? extends EventDelegateFactory> eventDelegateFactories, @Nonnull SchemeProperties schemeProperties) {
        super(new PentaCodec(), DXFeedScheme.createRecords(eventDelegateFactories, schemeProperties));
    }

    private static DataRecord[] createRecords(Iterable<? extends EventDelegateFactory> eventDelegateFactories, @Nonnull SchemeProperties schemeProperties) {
        SchemeBuilder builder = new SchemeBuilder(schemeProperties);
        for (EventDelegateFactory eventDelegateFactory : eventDelegateFactories) {
            eventDelegateFactory.buildScheme(builder);
        }
        return builder.buildRecords();
    }
}

