/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.api.impl;

import com.devexperts.io.URLInputStream;
import com.devexperts.qd.DataRecord;
import com.devexperts.qd.DataScheme;
import com.devexperts.qd.QDAgent;
import com.devexperts.qd.QDCollector;
import com.devexperts.qd.QDContract;
import com.devexperts.qd.QDDistributor;
import com.devexperts.qd.QDFactory;
import com.devexperts.qd.QDLog;
import com.devexperts.qd.SubscriptionFilter;
import com.devexperts.qd.SymbolCodec;
import com.devexperts.qd.ng.RecordBuffer;
import com.devexperts.qd.qtp.AgentAdapter;
import com.devexperts.qd.qtp.DistributorAdapter;
import com.devexperts.qd.qtp.MessageAdapter;
import com.devexperts.qd.qtp.MessageConnector;
import com.devexperts.qd.qtp.MessageConnectorListener;
import com.devexperts.qd.qtp.QDEndpoint;
import com.devexperts.qd.stats.QDStats;
import com.devexperts.rmi.RMIEndpoint;
import com.devexperts.rmi.impl.RMIEndpointImpl;
import com.devexperts.rmi.impl.RMISupportingDXEndpoint;
import com.devexperts.services.ServiceProvider;
import com.devexperts.services.Services;
import com.devexperts.util.ExecutorProvider;
import com.devexperts.util.IndexedSet;
import com.devexperts.util.LogUtil;
import com.devexperts.util.SystemProperties;
import com.dxfeed.api.DXEndpoint;
import com.dxfeed.api.DXFeed;
import com.dxfeed.api.DXPublisher;
import com.dxfeed.api.impl.DXConnectorInitializer;
import com.dxfeed.api.impl.DXFeedImpl;
import com.dxfeed.api.impl.DXFeedScheme;
import com.dxfeed.api.impl.DXPublisherImpl;
import com.dxfeed.api.impl.EventDelegate;
import com.dxfeed.api.impl.EventDelegateFactory;
import com.dxfeed.api.impl.EventDelegateSet;
import com.dxfeed.api.impl.ExtensibleDXEndpoint;
import com.dxfeed.api.impl.SchemeProperties;
import com.dxfeed.event.EventType;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import javax.annotation.concurrent.GuardedBy;

public class DXEndpointImpl
extends ExtensibleDXEndpoint
implements MessageConnectorListener,
RMISupportingDXEndpoint {
    private static final boolean TRACE_LOG = DXEndpointImpl.class.desiredAssertionStatus();
    private static final ExecutorProvider DEFAULT_EXECUTOR_PROVIDER = new ExecutorProvider("DXEndpoint-DXExecutorThread", QDLog.log);
    private final DXEndpoint.Role role;
    private final QDEndpoint qdEndpoint;
    private final Properties props;
    private final DataScheme scheme;
    private final SymbolCodec codec;
    private final IndexedSet<Class<?>, EventDelegateSet<?, ?>> delegateSetsByEventType = IndexedSet.create((? super V value) -> value.eventType());
    private final EnumMap<QDContract, IndexedSet<DataRecord, List<EventDelegate<?>>>> delegateListsByContractAndRecord = new EnumMap(QDContract.class);
    private Set<Class<? extends EventType<?>>> eventTypes = new IndexedSet();
    private final List<PropertyChangeListener> stateChangeListeners = new CopyOnWriteArrayList<PropertyChangeListener>();
    private final Object lock;
    private final StateHolder stateHolder = new StateHolder();
    private RMIEndpointImpl rmiEndpoint;
    private volatile DXFeedImpl feed;
    private volatile DXPublisherImpl publisher;
    private String address;
    private final ExecutorProvider executorProvider;
    private final ExecutorProvider.Reference executorReference;

    public static MessageAdapter.AbstractFactory getMessageAdapterFactory(QDEndpoint qdEndpoint, DXEndpoint.Role role) {
        switch (role) {
            case FEED: 
            case ON_DEMAND_FEED: 
            case STREAM_FEED: {
                return new DistributorAdapter.Factory(qdEndpoint, null);
            }
            case PUBLISHER: {
                return new AgentAdapter.Factory(qdEndpoint, null);
            }
            case STREAM_PUBLISHER: {
                return new AgentAdapter.Factory(qdEndpoint, null){

                    @Override
                    public MessageAdapter createAdapter(QDStats stats) {
                        return new AgentAdapter(this.endpoint, this.ticker, this.stream, this.history, this.getFilter(), stats){

                            @Override
                            protected QDAgent createAgent(QDCollector collector, SubscriptionFilter filter, String keyProperties) {
                                QDAgent agent = super.createAgent(collector, filter, keyProperties);
                                agent.setBufferOverflowStrategy(QDAgent.BufferOverflowStrategy.BLOCK);
                                return agent;
                            }
                        };
                    }
                };
            }
        }
        throw new UnsupportedOperationException("Connection is not supported in " + (Object)((Object)role) + " role");
    }

    protected DXEndpointImpl(DXEndpoint.Role role, QDEndpoint qdEndpoint, Properties props) {
        this.role = role;
        this.qdEndpoint = qdEndpoint;
        this.lock = qdEndpoint.getLock();
        this.props = props;
        this.scheme = qdEndpoint.getScheme();
        this.codec = this.scheme.getCodec();
        this.executorProvider = this.hasProperty("dxfeed.threadPoolSize") ? new ExecutorProvider(Integer.decode(this.getProperty("dxfeed.threadPoolSize")), "DXEndpoint-" + qdEndpoint.getName() + "-DXExecutorThread", QDLog.log) : DEFAULT_EXECUTOR_PROVIDER;
        this.executorReference = this.executorProvider.newReference();
        if (Boolean.parseBoolean(props.getProperty("dxfeed.wildcard.enable", "false"))) {
            qdEndpoint.getStream().setEnableWildcards(true);
        }
        for (QDCollector collector : qdEndpoint.getCollectors()) {
            QDContract contract = collector.getContract();
            this.delegateListsByContractAndRecord.put(contract, IndexedSet.create((? super V value) -> ((EventDelegate)value.get(0)).getRecord()));
        }
        for (EventDelegateFactory factory : Services.createServices(EventDelegateFactory.class, null)) {
            for (int i = 0; i < this.scheme.getRecordCount(); ++i) {
                this.createDelegates(factory, this.scheme.getRecord(i));
            }
        }
        for (EventDelegateSet delegateSet : this.delegateSetsByEventType) {
            delegateSet.completeConstruction();
            this.eventTypes.add(delegateSet.eventType());
        }
        this.eventTypes = Collections.unmodifiableSet(this.eventTypes);
        qdEndpoint.addMessageConnectionListener(this);
    }

    public DXEndpointImpl(DXEndpoint.Role role, QDCollector ... collectors) {
        this(role, QDEndpoint.newBuilder().withScheme(collectors[0].getScheme()).build().addCollectors(collectors), new Properties());
        this.initConnectivity();
    }

    private void initConnectivity() {
        if (this.role == DXEndpoint.Role.FEED) {
            if (this.rmiEndpoint == null) {
                this.rmiEndpoint = new RMIEndpointImpl(RMIEndpoint.Side.CLIENT, this.qdEndpoint, DXEndpointImpl.getMessageAdapterFactory(this.qdEndpoint, DXEndpoint.Role.FEED), this);
            }
        } else if (!this.qdEndpoint.hasConnectorInitializer()) {
            this.qdEndpoint.setConnectorInitializer(new DXConnectorInitializer(this));
        }
        switch (this.role) {
            case FEED: 
            case ON_DEMAND_FEED: {
                if (this.hasProperty("dxfeed.user")) {
                    this.qdEndpoint.user(this.getProperty("dxfeed.user"));
                }
                if (this.hasProperty("dxfeed.password")) {
                    this.qdEndpoint.password(this.getProperty("dxfeed.password"));
                }
                if (!this.hasProperty("dxfeed.address")) break;
                this.connectImpl(this.getProperty("dxfeed.address"), this.role == DXEndpoint.Role.FEED);
                break;
            }
            case PUBLISHER: {
                if (!this.hasProperty("dxpublisher.address")) break;
                this.connectImpl(this.getProperty("dxpublisher.address"), true);
            }
        }
    }

    public static EnumSet<QDContract> getRoleContracts(DXEndpoint.Role role) {
        return role == DXEndpoint.Role.STREAM_FEED || role == DXEndpoint.Role.STREAM_PUBLISHER ? EnumSet.of(QDContract.STREAM) : EnumSet.of(QDContract.TICKER, QDContract.STREAM, QDContract.HISTORY);
    }

    @Override
    public Object getLock() {
        return this.lock;
    }

    @Override
    public QDEndpoint getQDEndpoint() {
        return this.qdEndpoint;
    }

    @Override
    public DXEndpoint.Role getRole() {
        return this.role;
    }

    public boolean isClosed() {
        return this.stateHolder.state == DXEndpoint.State.CLOSED;
    }

    @Override
    public DXEndpoint.State getState() {
        return this.stateHolder.state;
    }

    @Override
    public void addStateChangeListener(PropertyChangeListener listener) {
        this.stateChangeListeners.add(listener);
    }

    @Override
    public void removeStateChangeListener(PropertyChangeListener listener) {
        this.stateChangeListeners.remove(listener);
    }

    @Override
    public Set<Class<? extends EventType<?>>> getEventTypes() {
        return this.eventTypes;
    }

    @Override
    public DXFeed getFeed() {
        DXFeedImpl feed = this.feed;
        return feed == null ? this.createFeedInternal() : feed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DXFeed createFeedInternal() {
        Object object = this.lock;
        synchronized (object) {
            if (this.feed == null) {
                this.feed = new DXFeedImpl(this);
            }
            return this.feed;
        }
    }

    @Override
    public DXPublisher getPublisher() {
        DXPublisherImpl publisher = this.publisher;
        return publisher == null ? this.createPublisherInternal() : publisher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DXPublisher createPublisherInternal() {
        Object object = this.lock;
        synchronized (object) {
            if (this.publisher == null) {
                this.publisher = new DXPublisherImpl(this);
            }
            return this.publisher;
        }
    }

    public Executor getOrCreateExecutor() {
        return this.executorReference.getOrCreateExecutor();
    }

    @Override
    public ExecutorProvider.Reference getExecutorReference() {
        return this.executorReference;
    }

    @Override
    public DXEndpoint executor(Executor executor) {
        this.executorReference.setExecutor(executor);
        return this;
    }

    @Override
    public DXEndpoint user(String user) {
        this.qdEndpoint.user(user);
        return this;
    }

    @Override
    public DXEndpoint password(String password) {
        this.qdEndpoint.password(password);
        return this;
    }

    @Override
    public DXEndpoint connect(String address) {
        this.connectImpl(address, true);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reconnect() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isClosed() || this.qdEndpoint.isClosed()) {
                return;
            }
            this.qdEndpoint.reconnectActiveConnectors();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectImpl(String address, boolean start) {
        if (address == null) {
            throw new NullPointerException();
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.stateHolder.state == DXEndpoint.State.CLOSED || address.equals(this.address)) {
                return;
            }
            this.disconnect();
            this.qdEndpoint.initializeConnectorsForAddress(address);
            if (start) {
                this.qdEndpoint.startConnectors();
                this.setConnectedAddressSync(address);
                if (this.rmiEndpoint != null) {
                    this.rmiEndpoint.setConnectedAddressSync(address);
                }
            }
        }
    }

    @Override
    public void setConnectedAddressSync(String address) {
        this.address = address;
        this.stateHolder.updateNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        Object object = this.lock;
        synchronized (object) {
            if (this.address == null) {
                return;
            }
            this.address = null;
            this.qdEndpoint.cleanupConnectors();
            if (this.rmiEndpoint != null) {
                this.rmiEndpoint.disconnect();
            }
            this.stateHolder.updateNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnectAndClear() {
        Object object = this.lock;
        synchronized (object) {
            this.qdEndpoint.stopConnectorsAndWaitUninterruptibly();
            this.clearImpl();
            this.disconnect();
        }
    }

    public void clearImpl() {
        this.clearCollector(this.qdEndpoint.getCollector(QDContract.TICKER), false);
        this.clearCollector(this.qdEndpoint.getCollector(QDContract.HISTORY), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCollector(QDCollector collector, boolean keepTime) {
        if (collector == null) {
            return;
        }
        RecordBuffer buf = RecordBuffer.getInstance();
        collector.examineData(buf);
        DXFeedImpl.clearDataInBuffer(buf, keepTime);
        buf.rewind();
        try (QDDistributor distributor = collector.distributorBuilder().build();){
            distributor.process(buf);
        }
        buf.release();
    }

    @Override
    public void awaitNotConnected() throws InterruptedException {
        this.stateHolder.awaitNotConnected();
    }

    @Override
    public void awaitProcessed() throws InterruptedException {
        this.qdEndpoint.awaitProcessed();
    }

    @Override
    public void close() {
        if (this.prepareToClose()) {
            this.disconnect();
            if (this.feed != null) {
                this.feed.closeImpl();
            }
            this.closeRest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeAndAwaitTermination() throws InterruptedException {
        if (this.prepareToClose()) {
            Object object = this.lock;
            synchronized (object) {
                this.qdEndpoint.stopConnectorsAndWait();
                this.disconnect();
            }
            if (this.feed != null) {
                this.feed.awaitTerminationAndCloseImpl();
            }
            this.stateHolder.awaitClosed();
            this.closeRest();
        }
    }

    private boolean prepareToClose() {
        DXEndpoint.State oldState = this.makeClosed();
        return oldState != DXEndpoint.State.CLOSED;
    }

    private void closeRest() {
        if (this.publisher != null) {
            this.publisher.closeImpl();
        }
        this.qdEndpoint.close();
        this.executorReference.close();
    }

    private void fireStateChangeEvent(DXEndpoint.State oldState, DXEndpoint.State newState) {
        if (this.stateChangeListeners.isEmpty()) {
            return;
        }
        PropertyChangeEvent event = new PropertyChangeEvent(this, "state", (Object)oldState, (Object)newState);
        for (PropertyChangeListener listener : this.stateChangeListeners) {
            try {
                listener.propertyChange(event);
            }
            catch (Throwable t) {
                QDLog.log.error("Exception in DXEndpoint state change listener", t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DXEndpoint.State makeClosed() {
        Object object = this.lock;
        synchronized (object) {
            return this.stateHolder.makeClosed();
        }
    }

    public boolean hasProperty(String key) {
        return this.props.getProperty(key) != null;
    }

    public String getProperty(String key) {
        return this.props.getProperty(key);
    }

    public Set<QDContract> getContracts() {
        return this.qdEndpoint.getContracts();
    }

    public QDCollector getCollector(QDContract contract) {
        return this.qdEndpoint.getCollector(contract);
    }

    public int encode(String symbol) {
        return this.codec.encode(symbol);
    }

    public String decode(int cipher, String symbol) {
        return this.codec.decode(cipher, symbol);
    }

    public EventDelegateSet<?, ?> getDelegateSetByEventType(Class<?> eventType) {
        return this.delegateSetsByEventType.getByKey(eventType);
    }

    public List<EventDelegate<?>> getDelegateListByContractAndRecord(QDContract contract, DataRecord record) {
        return this.delegateListsByContractAndRecord.get(contract).getByKey(record);
    }

    public String toString() {
        return "DXEndpoint{role=" + (Object)((Object)this.role) + ", scheme=" + this.scheme.getClass().getSimpleName() + ", address=" + LogUtil.hideCredentials(this.address) + (this.isClosed() ? ", closed" : "") + '}';
    }

    public RMIEndpoint getRMIEndpoint() {
        return this.rmiEndpoint;
    }

    private void createDelegates(EventDelegateFactory factory, DataRecord record) {
        Collection<EventDelegate<?>> delegates;
        Collection<EventDelegate<?>> collection = delegates = this.role == DXEndpoint.Role.STREAM_FEED || this.role == DXEndpoint.Role.STREAM_PUBLISHER ? factory.createStreamOnlyDelegates(record) : factory.createDelegates(record);
        if (delegates == null) {
            return;
        }
        delegates.forEach(this::registerDelegate);
    }

    void registerDelegate(EventDelegate<?> delegate) {
        QDContract contract = delegate.getContract();
        if (this.qdEndpoint.getCollector(contract) == null) {
            return;
        }
        EventDelegateSet<?, Object> delegateSet = this.delegateSetsByEventType.getByKey(delegate.getEventType());
        if (delegateSet == null) {
            delegateSet = delegate.createDelegateSet();
            this.delegateSetsByEventType.add(delegateSet);
        }
        try {
            delegateSet.add(delegate);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Cannot mix events of incompatible types", e);
        }
        IndexedSet<DataRecord, List<EventDelegate<?>>> lists = this.delegateListsByContractAndRecord.get(contract);
        List<EventDelegate<?>> delegateList = lists.getByKey(delegate.getRecord());
        if (delegateList == null) {
            delegateList = new ArrayList(1);
            delegateList.add(delegate);
            lists.add(delegateList);
        } else {
            delegateList.add(delegate);
        }
    }

    @Override
    public void stateChanged(MessageConnector connector) {
        this.stateHolder.scheduleUpdate();
    }

    private class StateHolder
    implements Runnable {
        volatile DXEndpoint.State state;
        private DXEndpoint.State lastFiredState;
        private int scheduled;
        private volatile Thread processingThread;

        private StateHolder() {
            this.lastFiredState = this.state = DXEndpoint.State.NOT_CONNECTED;
        }

        synchronized void updateNow() {
            DXEndpoint.State computedState;
            if (this.state != DXEndpoint.State.CLOSED && this.state != (computedState = this.computeState())) {
                this.state = computedState;
                this.scheduleImpl();
            }
        }

        synchronized void scheduleUpdate() {
            if (this.state != DXEndpoint.State.CLOSED) {
                this.scheduleImpl();
            }
        }

        @GuardedBy(value="this")
        private void scheduleImpl() {
            if (TRACE_LOG) {
                QDLog.log.trace("Schedule state update to " + (Object)((Object)this.state));
            }
            if (this.scheduled++ > 0) {
                this.notifyAll();
                return;
            }
            DXEndpointImpl.this.getOrCreateExecutor().execute(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int lastScheduled = 0;
            while (true) {
                DXEndpoint.State newState;
                DXEndpoint.State oldState;
                StateHolder stateHolder = this;
                synchronized (stateHolder) {
                    this.state = this.computeState();
                    oldState = this.lastFiredState;
                    newState = this.state;
                    if (newState == oldState && this.scheduled == lastScheduled) {
                        this.processingThread = null;
                        this.scheduled = 0;
                        this.notifyAll();
                        return;
                    }
                    lastScheduled = this.scheduled;
                    this.lastFiredState = newState;
                    this.processingThread = Thread.currentThread();
                }
                if (oldState == newState) continue;
                DXEndpointImpl.this.fireStateChangeEvent(oldState, newState);
            }
        }

        @GuardedBy(value="this")
        private DXEndpoint.State computeState() {
            if (this.state == DXEndpoint.State.CLOSED) {
                return DXEndpoint.State.CLOSED;
            }
            boolean hasConnecting = false;
            for (MessageConnector connector : DXEndpointImpl.this.qdEndpoint.getConnectors()) {
                switch (connector.getState()) {
                    case CONNECTING: {
                        hasConnecting = true;
                        break;
                    }
                    case CONNECTED: {
                        return DXEndpoint.State.CONNECTED;
                    }
                }
            }
            return hasConnecting ? DXEndpoint.State.CONNECTING : DXEndpoint.State.NOT_CONNECTED;
        }

        synchronized DXEndpoint.State makeClosed() {
            DXEndpoint.State oldState = this.state;
            if (oldState != DXEndpoint.State.CLOSED) {
                this.state = DXEndpoint.State.CLOSED;
                this.scheduleImpl();
            }
            return oldState;
        }

        void awaitClosed() throws InterruptedException {
            this.await(DXEndpoint.State.CLOSED);
        }

        void awaitNotConnected() throws InterruptedException {
            this.await(DXEndpoint.State.NOT_CONNECTED);
        }

        private void await(DXEndpoint.State condition) throws InterruptedException {
            if (this.processingThread == Thread.currentThread()) {
                this.awaitInner(condition);
            } else {
                this.awaitOuter(condition);
            }
        }

        private synchronized void awaitInner(DXEndpoint.State condition) throws InterruptedException {
            while (true) {
                this.state = this.computeState();
                if (this.isCondition(condition)) {
                    return;
                }
                this.wait();
            }
        }

        private synchronized void awaitOuter(DXEndpoint.State condition) throws InterruptedException {
            while (!this.isCondition(condition) || this.scheduled != 0) {
                this.wait();
            }
        }

        @GuardedBy(value="this")
        private boolean isCondition(DXEndpoint.State condition) {
            return this.state == DXEndpoint.State.CLOSED || this.state == condition;
        }
    }

    @ServiceProvider
    public static class BuilderRMIImpl
    extends RMIEndpoint.Builder {
        private QDEndpoint.Builder qdEndpointBuilder = QDEndpoint.newBuilder();

        @Override
        public RMIEndpoint build() {
            DXEndpointImpl dxEndpoint = null;
            this.qdEndpointBuilder.withProperties(this.props);
            if (this.scheme != null) {
                this.qdEndpointBuilder.withScheme(this.scheme);
            }
            if (this.dxRole != null) {
                this.qdEndpointBuilder.withCollectors(DXEndpointImpl.getRoleContracts(this.dxRole));
            }
            this.qdEndpointBuilder.withName(this.getOrCreateName());
            this.qdEndpointBuilder.withEventTimeSequence(Boolean.parseBoolean(this.props.getProperty("dxendpoint.eventTime", "false")));
            QDEndpoint qdEndpoint = this.qdEndpointBuilder.build();
            if (this.dxRole != null) {
                dxEndpoint = new DXEndpointImpl(this.dxRole, qdEndpoint, this.props);
            }
            if (this.dxRole == DXEndpoint.Role.FEED) {
                this.side = this.side.withClient();
            }
            RMIEndpointImpl rmiEndpoint = new RMIEndpointImpl(this.side, qdEndpoint, this.dxRole != null ? DXEndpointImpl.getMessageAdapterFactory(qdEndpoint, this.dxRole) : null, dxEndpoint);
            if (dxEndpoint != null) {
                dxEndpoint.rmiEndpoint = rmiEndpoint;
                dxEndpoint.initConnectivity();
            }
            return rmiEndpoint;
        }

        @Override
        public boolean supportsProperty(String key) {
            return super.supportsProperty(key) || this.qdEndpointBuilder.supportsProperty(key);
        }
    }

    @ServiceProvider
    public static class BuilderImpl
    extends DXEndpoint.Builder {
        private static final Set<String> SUPPORTED_PROPERTIES = new LinkedHashSet<String>(Arrays.asList("dxfeed.properties", "dxfeed.threadPoolSize", "dxfeed.aggregationPeriod", "dxfeed.address", "dxfeed.user", "dxfeed.password", "dxfeed.wildcard.enable", "dxendpoint.eventTime", "dxendpoint.storeEverything", "dxscheme.nanoTime", "dxpublisher.properties", "dxpublisher.address", "dxpublisher.threadPoolSize"));
        private static final Set<String> MASKED_PROPERTIES = new HashSet<String>(Arrays.asList("dxfeed.user", "dxfeed.password"));
        private final Properties props = new Properties();
        private QDEndpoint.Builder qdEndpointBuilder = QDEndpoint.newBuilder();

        public BuilderImpl() {
            this.updateSubscribeSupport();
        }

        private void updateSubscribeSupport() {
            this.qdEndpointBuilder.withSubscribeSupport(this.role == DXEndpoint.Role.FEED ? "dxfeed.qd.subscribe." : null);
        }

        @Override
        public DXEndpoint.Builder withRole(DXEndpoint.Role role) {
            super.withRole(role);
            this.updateSubscribeSupport();
            return this;
        }

        @Override
        public DXEndpoint.Builder withProperty(String key, String value) {
            if (key == null || value == null) {
                throw new NullPointerException();
            }
            if (this.supportsProperty(key)) {
                this.props.setProperty(key, value);
            }
            return this;
        }

        @Override
        public boolean supportsProperty(String key) {
            return SUPPORTED_PROPERTIES.contains(key) || key.startsWith("dxscheme.enabled.") || this.qdEndpointBuilder.supportsProperty(key);
        }

        private void loadPropertiesDefaults(Properties defaultProps, boolean ignoreName) {
            for (String key : defaultProps.stringPropertyNames()) {
                String value;
                if (ignoreName && key.equals("name") || (value = defaultProps.getProperty(key)) == null || this.props.containsKey(key)) continue;
                this.withProperty(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void loadPropertiesDefaultsFromStream(InputStream in, String name, String propFileKey) {
            if (in == null) {
                return;
            }
            QDLog.log.info("DXEndpoint is loading properties from " + name);
            Properties props = new Properties();
            try {
                try {
                    props.load(in);
                }
                finally {
                    in.close();
                }
            }
            catch (IOException e) {
                this.failedToLoadFrom(name, propFileKey, e);
                return;
            }
            this.loadPropertiesDefaults(props, false);
        }

        private void loadPropertiesDefaultsFromFile(String fileName, String propFileKey) {
            try {
                this.loadPropertiesDefaultsFromStream(new URLInputStream(fileName), fileName, propFileKey);
            }
            catch (IOException e) {
                this.failedToLoadFrom("file '" + fileName + "'", propFileKey, e);
            }
        }

        private void failedToLoadFrom(String name, String propFileKey, IOException e) {
            QDLog.log.error("Failed to load " + propFileKey + " from " + LogUtil.hideCredentials(name), e);
        }

        @Override
        public DXEndpoint build() {
            this.loadProperties();
            DataScheme scheme = QDFactory.getDefaultScheme();
            SchemeProperties schemeProperties = new SchemeProperties(this.props);
            if (scheme == DXFeedScheme.getInstance()) {
                scheme = DXFeedScheme.withProperties(schemeProperties);
            }
            QDEndpoint qdEndpoint = this.qdEndpointBuilder.withProperties(this.props).withCollectors(DXEndpointImpl.getRoleContracts(this.role)).withScheme(scheme).withEventTimeSequence(Boolean.parseBoolean(this.props.getProperty("dxendpoint.eventTime", "false"))).withStoreEverything(Boolean.parseBoolean(this.props.getProperty("dxendpoint.storeEverything", "false"))).build();
            for (Map.Entry<Object, Object> entry : new TreeMap<Object, Object>(this.props).entrySet()) {
                String key = (String)entry.getKey();
                if (this.qdEndpointBuilder.supportsProperty(key) || !this.supportsProperty(key)) continue;
                QDLog.log.info(qdEndpoint.getName() + " DXEndpoint with " + key + "=" + (MASKED_PROPERTIES.contains(key) ? "****" : this.props.getProperty(key)));
            }
            DXEndpointImpl dxEndpoint = new DXEndpointImpl(this.role, qdEndpoint, this.props);
            dxEndpoint.initConnectivity();
            return dxEndpoint;
        }

        private void loadProperties() {
            String propFileKey;
            switch (this.role) {
                case FEED: 
                case ON_DEMAND_FEED: {
                    propFileKey = "dxfeed.properties";
                    break;
                }
                case PUBLISHER: {
                    propFileKey = "dxpublisher.properties";
                    break;
                }
                default: {
                    return;
                }
            }
            String fileName = this.props.getProperty(propFileKey);
            if (fileName == null) {
                fileName = SystemProperties.getProperty(propFileKey, null);
            }
            if (fileName != null) {
                this.loadPropertiesDefaultsFromFile(fileName, propFileKey);
            }
            try {
                this.loadPropertiesDefaults(System.getProperties(), true);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (fileName == null) {
                String resourceName = "/" + propFileKey;
                this.loadPropertiesDefaultsFromStream(DXEndpointImpl.class.getResourceAsStream(resourceName), "resource '" + resourceName + "'", propFileKey);
            }
        }
    }
}

