/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.util;

import com.devexperts.util.BusinessSchedule;
import com.devexperts.util.DayUtil;
import com.devexperts.util.IndexedSet;
import com.devexperts.util.IndexerFunction;
import com.devexperts.util.MathUtil;
import com.devexperts.util.QuickSort;
import com.devexperts.util.SystemProperties;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Comparator;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicLong;

public class Timing {
    private static final long DAY_LENGTH = 86400000L;
    private static final int MAX_DAYS_SIZE = SystemProperties.getIntProperty(Timing.class, "cacheSize", 25000, 100, 100000);
    private static final Comparator<Day> DAY_USAGE_COMPARATOR = Comparator.comparingLong(day -> Day.access$000(day));
    private static final IndexerFunction.IntKey<Day> DAY_INDEXER = day -> day.day_id;
    private static final IndexerFunction.IntKey<Day> YMD_INDEXER = day -> day.year_month_day_number;
    public static final Timing LOCAL = new Timing(TimeZone.getDefault());
    public static final Timing GMT = new Timing(TimeZone.getTimeZone("GMT"));
    public static final Timing EST = new Timing(TimeZone.getTimeZone("America/New_York"));
    public static final Timing CST = new Timing(TimeZone.getTimeZone("America/Chicago"));
    private final Calendar calendar;
    private final TimeZone time_zone;
    private final int raw_offset;
    private final BusinessSchedule business_schedule;
    private volatile ZoneId zoneId;
    private final Object lock = new Object();
    private final IndexedSet<Integer, Day> days_cache = IndexedSet.createInt(DAY_INDEXER);
    private final IndexedSet<Integer, Day> ymds_cache = IndexedSet.createInt(YMD_INDEXER);
    private final AtomicLong creation_counter = new AtomicLong(0L);
    private final AtomicLong usage_counter = new AtomicLong(0L);

    public Timing(Calendar calendar, BusinessSchedule business_schedule) {
        this.calendar = (Calendar)calendar.clone();
        this.time_zone = (TimeZone)calendar.getTimeZone().clone();
        this.raw_offset = this.time_zone.getRawOffset();
        this.business_schedule = business_schedule;
    }

    public Timing(TimeZone time_zone) {
        this(Calendar.getInstance(time_zone), BusinessSchedule.US);
    }

    public Calendar getCalendar() {
        return (Calendar)this.calendar.clone();
    }

    public TimeZone getTimeZone() {
        return (TimeZone)this.time_zone.clone();
    }

    public ZoneId getZoneId() {
        ZoneId zId = this.zoneId;
        if (zId == null) {
            this.zoneId = zId = this.time_zone.toZoneId();
        }
        return zId;
    }

    public Day today() {
        return this.getByTime(System.currentTimeMillis());
    }

    public Day getByTime(long millis) {
        this.usage_counter.incrementAndGet();
        int day_id = Timing.dayId(millis + (long)this.raw_offset);
        Day d = this.getCachedDay(day_id);
        if (d == null || millis > d.day_end) {
            d = this.getCachedDay(day_id + 1);
        }
        if (d == null || millis < d.day_start) {
            d = this.getCachedDay(day_id - 1);
        }
        while (d != null && millis > d.day_end) {
            d = this.getCachedDay(d.day_id + 1);
        }
        while (d != null && millis < d.day_start) {
            d = this.getCachedDay(d.day_id - 1);
        }
        if (d == null || !d.contains(millis)) {
            d = this.createCachedDay(millis);
        }
        return d;
    }

    public Day getById(int day_id) {
        this.usage_counter.incrementAndGet();
        Day d = this.getCachedDay(day_id);
        if (d == null) {
            d = this.createCachedDay((long)day_id * 86400000L - (long)this.raw_offset + 43200000L);
            while (d.day_id > day_id) {
                d = this.createCachedDay(d.day_start - 43200000L);
            }
            while (d.day_id < day_id) {
                d = this.createCachedDay(d.day_end + 43200000L);
            }
            if (day_id != d.day_id) {
                throw new RuntimeException("Abnormal Day creation for day #" + day_id + ".");
            }
        }
        return d;
    }

    public Day getByYmd(int year_month_day_number) {
        this.usage_counter.incrementAndGet();
        Day d = this.ymds_cache.getByKey(year_month_day_number);
        if (d != null) {
            d.usage_counter = this.usage_counter.get();
            return d;
        }
        year_month_day_number = Math.min(Math.max(year_month_day_number, 10102), 999991230);
        int year = year_month_day_number / 10000;
        int month = year_month_day_number / 100 % 100;
        int day = year_month_day_number % 100;
        if (day > 31) {
            ++month;
            day = 1;
        } else if (day < 1) {
            day = 1;
        }
        if (month > 12) {
            ++year;
            day = 1;
            month = 1;
        } else if (month < 1) {
            day = 1;
            month = 1;
        }
        d = this.ymds_cache.getByKey(year * 10000 + month * 100 + day);
        if (d != null) {
            d.usage_counter = this.usage_counter.get();
            return d;
        }
        int day_id = DayUtil.getDayIdByYearMonthDay(year, month, day);
        d = this.getCachedDay(day_id);
        if (d == null) {
            d = this.createCachedDay((long)day_id * 86400000L - (long)this.raw_offset + 43200000L);
        }
        while (d.year_month_day_number > year_month_day_number) {
            d = this.createCachedDay(d.day_start - 43200000L);
        }
        while (d.year_month_day_number < year_month_day_number) {
            d = this.createCachedDay(d.day_end + 43200000L);
        }
        return d;
    }

    public static long getGMTNoon(int day_id) {
        return (long)day_id * 86400000L + 43200000L;
    }

    public static int dayOfWeekNumber(long day_start, long week_start) {
        return (int)((day_start - week_start + 43200000L) / 86400000L) + 1;
    }

    public String toString() {
        return this.getStatistics();
    }

    public String getStatistics() {
        int days = this.days_cache.size();
        long uses = this.usage_counter.get();
        long hits = uses - this.creation_counter.get();
        double eff = hits <= 0L || uses <= 0L ? 0.0 : (double)((10000L * hits + uses / 2L) / uses) / 100.0;
        return "Timing." + this.time_zone.getDisplayName(false, 0) + ": days = " + days + ", efficiency = " + hits + "/" + uses + " (" + eff + "%)";
    }

    private Day getCachedDay(int day_id) {
        Day d = this.days_cache.getByKey(day_id);
        if (d != null) {
            d.usage_counter = this.usage_counter.get();
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Day createCachedDay(long millis) {
        Object object = this.lock;
        synchronized (object) {
            Day d = this.createDay(millis);
            Day old = this.days_cache.getByValue(d);
            if (old == null) {
                this.days_cache.put(d);
                this.ymds_cache.put(d);
            } else {
                d = old;
            }
            this.checkDaysCacheSize(d.day_id);
            d.usage_counter = this.usage_counter.get();
            return d;
        }
    }

    private static int dayId(long local_millis) {
        return (int)MathUtil.div(local_millis, 86400000L);
    }

    private static long dayStart(Calendar c) {
        c.set(11, c.getActualMinimum(11));
        c.set(12, c.getActualMinimum(12));
        c.set(13, c.getActualMinimum(13));
        c.set(14, c.getActualMinimum(14));
        return c.getTime().getTime();
    }

    private static long dayEnd(Calendar c) {
        c.set(11, c.getActualMaximum(11));
        c.set(12, c.getActualMaximum(12));
        c.set(13, c.getActualMaximum(13));
        c.set(14, c.getActualMaximum(14));
        return c.getTime().getTime();
    }

    private Day createDay(long millis) {
        this.creation_counter.incrementAndGet();
        Calendar c = this.calendar;
        c.setTimeInMillis(millis);
        int day_id = Timing.dayId(c.getTime().getTime() + (long)c.get(15) + (long)c.get(16));
        int year_month_day_number = c.get(1) * 10000 + (c.get(2) + 1) * 100 + c.get(5);
        long day_start = Timing.dayStart(c);
        long day_end = Timing.dayEnd(c);
        c.set(5, c.getActualMinimum(5));
        long month_start = Timing.dayStart(c);
        c.set(5, c.getActualMaximum(5));
        long month_end = Timing.dayEnd(c);
        c.set(6, c.getActualMinimum(6));
        long year_start = Timing.dayStart(c);
        c.set(6, c.getActualMaximum(6));
        long year_end = Timing.dayEnd(c);
        c.setTimeInMillis(millis);
        int day_of_week = c.get(7);
        c.add(6, -(day_of_week == 1 ? 6 : day_of_week - 2));
        long week_start = Timing.dayStart(c);
        c.add(6, 6);
        long week_end = Timing.dayEnd(c);
        return this.createDay(day_id, day_start, day_end, week_start, week_end, month_start, month_end, year_start, year_end, year_month_day_number);
    }

    protected Day createDay(int day_id, long day_start, long day_end, long week_start, long week_end, long month_start, long month_end, long year_start, long year_end, int year_month_day_number) {
        BusinessSchedule.OperatingMode mode = this.business_schedule.getOperatingMode(year_month_day_number, Timing.dayOfWeekNumber(day_start, week_start));
        return new Day(day_id, day_start, day_end, week_start, week_end, month_start, month_end, year_start, year_end, year_month_day_number, mode);
    }

    private void checkDaysCacheSize(int keep_day_id) {
        if (this.days_cache.size() <= MAX_DAYS_SIZE) {
            return;
        }
        Day[] a = this.days_cache.toArray(new Day[this.days_cache.size()]);
        QuickSort.sort(a, DAY_USAGE_COMPARATOR);
        int i = a.length / 2;
        while (--i >= 0) {
            if (a[i].day_id == keep_day_id) continue;
            this.days_cache.removeKey(a[i].day_id);
            this.ymds_cache.removeKey(a[i].year_month_day_number);
        }
    }

    public static class Day {
        public final int day_id;
        public final long day_start;
        public final long day_end;
        public final long week_start;
        public final long week_end;
        public final long month_start;
        public final long month_end;
        public final long year_start;
        public final long year_end;
        public final int year_month_day_number;
        public final BusinessSchedule.OperatingMode mode;
        private long usage_counter;

        protected Day(int day_id, long day_start, long day_end, long week_start, long week_end, long month_start, long month_end, long year_start, long year_end, int year_month_day_number, BusinessSchedule.OperatingMode mode) {
            this.day_id = day_id;
            this.day_start = day_start;
            this.day_end = day_end;
            this.week_start = week_start;
            this.week_end = week_end;
            this.month_start = month_start;
            this.month_end = month_end;
            this.year_start = year_start;
            this.year_end = year_end;
            this.year_month_day_number = year_month_day_number;
            this.mode = mode;
        }

        public boolean contains(long time) {
            return time >= this.day_start && time <= this.day_end;
        }

        public int yearNumber() {
            return this.year_month_day_number / 10000;
        }

        public int monthNumber() {
            return this.year_month_day_number / 100 % 100;
        }

        public int dayNumber() {
            return this.year_month_day_number % 100;
        }

        public int dayOfWeekNumber() {
            return Timing.dayOfWeekNumber(this.day_start, this.week_start);
        }

        public boolean isWeekend() {
            return this.mode.isWeekend();
        }

        public boolean isHoliday() {
            return this.mode.isHoliday();
        }

        public boolean isTrading() {
            return this.mode.isBusiness();
        }

        public long getGMTNoon() {
            return Timing.getGMTNoon(this.day_id);
        }

        public String toString() {
            return "#" + this.day_id + " (" + this.year_month_day_number + ")";
        }
    }
}

