/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.util;

import com.devexperts.monitoring.Monitored;
import com.devexperts.util.AtomicArrays;

public class TimeDistribution {
    private static final long US = 1000L;
    private static final long MS = 1000000L;
    private static final long SEC = 1000000000L;
    private static final long MIN = 60000000000L;
    private final Precision p;
    private final long[] counts;

    public TimeDistribution(Precision precision) {
        this.p = precision;
        this.counts = new long[this.p.nTotal];
    }

    public TimeDistribution(TimeDistribution other) {
        this(other.p);
        this.copyFrom(other);
    }

    public TimeDistribution(TimeDistribution cur, TimeDistribution old) {
        this(cur.p);
        if (cur.p != old.p) {
            throw new IllegalArgumentException("Different precision: " + (Object)((Object)cur.p) + " and " + (Object)((Object)old.p));
        }
        this.copyFromDiff(cur, old);
    }

    public void copyFrom(TimeDistribution other) {
        for (int i = 0; i < this.p.nTotal; ++i) {
            AtomicArrays.INSTANCE.setVolatileLong(this.counts, i, AtomicArrays.INSTANCE.getVolatileLong(other.counts, i));
        }
    }

    public void copyFromDiff(TimeDistribution cur, TimeDistribution old) {
        for (int i = 0; i < this.p.nTotal; ++i) {
            AtomicArrays.INSTANCE.setVolatileLong(this.counts, i, AtomicArrays.INSTANCE.getVolatileLong(cur.counts, i) - AtomicArrays.INSTANCE.getVolatileLong(old.counts, i));
        }
    }

    public void add(TimeDistribution other) {
        for (int i = 0; i < this.p.nTotal; ++i) {
            AtomicArrays.INSTANCE.addAndGetLong(this.counts, i, AtomicArrays.INSTANCE.getVolatileLong(other.counts, i));
        }
    }

    @Monitored(name="count", description="Number of measurements")
    public long getCount() {
        long count = 0L;
        for (int i = 0; i <= this.p.bigCountIndex; ++i) {
            count += AtomicArrays.INSTANCE.getVolatileLong(this.counts, i);
        }
        return count;
    }

    private double getNanosAt(int i, double fraction) {
        if (i < this.p.bigCountIndex) {
            long delta;
            long start;
            int power = i >> this.p.nBits;
            int offset = i & this.p.stripe - 1;
            if (power == 0) {
                start = offset;
                delta = 1L;
            } else {
                start = (long)(this.p.stripe + offset) << power - 1;
                delta = 1L << power - 1;
            }
            return (double)start + (double)delta * fraction;
        }
        if (fraction == 0.0) {
            return this.getNanosAt(this.p.bigCountIndex - 1, 1.0);
        }
        if (fraction == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        long c = AtomicArrays.INSTANCE.getVolatileLong(this.counts, this.p.bigCountIndex);
        return c > 0L ? (double)((long)((double)AtomicArrays.INSTANCE.getVolatileLong(this.counts, this.p.bigSumSecsIndex) / (double)c * 1.0E9)) : 0.0;
    }

    public long computePercentileNanos(double fraction) {
        if (fraction < 0.0 || fraction > 1.0) {
            throw new IllegalArgumentException();
        }
        double expectCount = (double)this.getCount() * fraction;
        long count = 0L;
        int maxI = 0;
        for (int i = 0; i <= this.p.bigCountIndex; ++i) {
            long c = AtomicArrays.INSTANCE.getVolatileLong(this.counts, i);
            if (c <= 0L) continue;
            if ((double)(count + c) > expectCount) {
                return (long)this.getNanosAt(i, (expectCount - (double)count) / (double)c);
            }
            count += c;
            maxI = i;
        }
        return (long)this.getNanosAt(maxI, 1.0);
    }

    public double getSumNanos() {
        double sum = 0.0;
        for (int i = 0; i <= this.p.bigCountIndex; ++i) {
            long c = AtomicArrays.INSTANCE.getVolatileLong(this.counts, i);
            if (c <= 0L) continue;
            sum += (double)c * this.getNanosAt(i, 0.5);
        }
        return sum;
    }

    @Monitored(name="avg", description="Average measurement in nanoseconds")
    public long getAverageNanos() {
        long count = 0L;
        double sum = 0.0;
        for (int i = 0; i <= this.p.bigCountIndex; ++i) {
            long c = AtomicArrays.INSTANCE.getVolatileLong(this.counts, i);
            if (c <= 0L) continue;
            count += c;
            sum += (double)c * this.getNanosAt(i, 0.5);
        }
        return (long)(sum / (double)count);
    }

    @Monitored(name="min", description="Minimum measurement in nanoseconds")
    public long getMinNanos() {
        return this.computePercentileNanos(0.0);
    }

    @Monitored(name="lower", description="10th percentile of measurements in nanoseconds")
    public long getLowerNanos() {
        return this.computePercentileNanos(0.1);
    }

    @Monitored(name="median", description="Median of measurements in nanoseconds")
    public long getMedianNanos() {
        return this.computePercentileNanos(0.5);
    }

    @Monitored(name="upper", description="90th percentile of measurements in nanoseconds")
    public long getUpperNanos() {
        return this.computePercentileNanos(0.9);
    }

    @Monitored(name="max", description="Maximum measurement in nanoseconds")
    public long getMaxNanos() {
        return this.computePercentileNanos(1.0);
    }

    public void addMeasurement(long nanos) {
        int index = this.p.getIndexUnlimited(nanos);
        if (index < this.p.bigCountIndex) {
            AtomicArrays.INSTANCE.addAndGetLong(this.counts, index, 1L);
        } else {
            AtomicArrays.INSTANCE.addAndGetLong(this.counts, this.p.bigCountIndex, 1L);
            AtomicArrays.INSTANCE.addAndGetLong(this.counts, this.p.bigSumSecsIndex, (nanos + 500000000L) / 1000000000L);
        }
    }

    public String toString() {
        long c = this.getCount();
        return c == 0L ? "0" : c + ", avg=" + TimeDistribution.formatNanos(this.getAverageNanos()) + "; min=" + TimeDistribution.formatNanos(this.getMinNanos()) + " [" + TimeDistribution.formatNanos(this.getLowerNanos()) + " - " + TimeDistribution.formatNanos(this.getMedianNanos()) + " - " + TimeDistribution.formatNanos(this.getUpperNanos()) + "] max=" + TimeDistribution.formatNanos(this.getMaxNanos());
    }

    public static String formatNanos(long nanos) {
        if (Double.isNaN(nanos)) {
            return "NaN";
        }
        if (nanos == Long.MAX_VALUE) {
            return "inf";
        }
        if (nanos == Long.MIN_VALUE) {
            return "-inf";
        }
        String s = "";
        if (nanos < 0L) {
            s = "-";
            nanos = -nanos;
        }
        if (nanos >= 60000000000L) {
            return s + TimeDistribution.fmt((double)nanos / 6.0E10) + "min";
        }
        if (nanos >= 1000000000L) {
            return s + TimeDistribution.fmt((double)nanos / 1.0E9) + "s";
        }
        if (nanos >= 1000000L) {
            return s + TimeDistribution.fmt((double)nanos / 1000000.0) + "ms";
        }
        if (nanos >= 1000L) {
            return s + TimeDistribution.fmt((double)nanos / 1000.0) + "us";
        }
        return s + nanos + "ns";
    }

    private static String fmt(double x) {
        if ((x = x >= 100.0 ? Math.floor(x + 0.5) : (x >= 10.0 ? Math.floor(x * 10.0 + 0.5) / 10.0 : Math.floor(x * 100.0 + 0.5) / 100.0)) == (double)((int)x)) {
            return Integer.toString((int)x);
        }
        return Double.toString(x);
    }

    public static enum Precision {
        HIGH(6, 600000000000L),
        LOW(3, 10000000000L);

        final int nBits;
        final int stripe;
        final int power1Base;
        final int bigCountIndex;
        final int bigSumSecsIndex;
        final int nTotal;

        private Precision(int nBits, long bigLimit) {
            this.nBits = nBits;
            this.stripe = 1 << nBits;
            this.power1Base = 63 - nBits;
            this.bigCountIndex = this.getIndexUnlimited(bigLimit) + 1;
            this.bigSumSecsIndex = this.bigCountIndex + 1;
            this.nTotal = this.bigSumSecsIndex + 1;
        }

        int getIndexUnlimited(long nanos) {
            if (nanos <= 0L) {
                return 0;
            }
            int power1 = this.power1Base - Long.numberOfLeadingZeros(nanos);
            if (power1 < 0) {
                return (int)nanos;
            }
            return (power1 << this.nBits) + (int)(nanos >> power1);
        }
    }
}

