/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.util;

import java.util.HashSet;
import java.util.Set;

public class JMXNameBuilder {
    private final StringBuffer sb = new StringBuffer(80);
    private final Set<String> keys = new HashSet<String>();

    public JMXNameBuilder() {
    }

    public JMXNameBuilder(String domain) {
        this.sb.append(domain);
        this.sb.append(':');
    }

    public void appendKeyProperties(String keyProperties) {
        if (keyProperties == null || keyProperties.isEmpty()) {
            return;
        }
        boolean in_key = true;
        boolean first_value_char = false;
        boolean quoted_value = false;
        String key = "";
        StringBuffer sb = new StringBuffer();
        int n = keyProperties.length();
        block4: for (int i = 0; i <= n; ++i) {
            char c;
            char c2 = c = i < n ? keyProperties.charAt(i) : (char)'\u0000';
            if (in_key && c == '=') {
                key = sb.toString();
                sb.setLength(0);
                in_key = false;
                first_value_char = true;
                continue;
            }
            if (quoted_value && c == '\"') {
                quoted_value = false;
                continue;
            }
            if (!(in_key || quoted_value || c != ',' && i != n)) {
                String value = sb.toString();
                sb.setLength(0);
                in_key = true;
                first_value_char = false;
                this.append(key, value);
                continue;
            }
            if (first_value_char && c == '\"') {
                quoted_value = true;
                first_value_char = false;
                continue;
            }
            if (quoted_value && c == '\\') {
                if (++i >= n) {
                    throw new IllegalArgumentException("Invalid quoted value -- backslash at the end of string");
                }
                c = keyProperties.charAt(i);
                switch (c) {
                    case 'n': {
                        sb.append('\n');
                        continue block4;
                    }
                    case '\"': 
                    case '*': 
                    case '?': 
                    case '\\': {
                        sb.append(c);
                        continue block4;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid character after backslash: " + c);
                    }
                }
            }
            sb.append(c);
            first_value_char = false;
        }
        if (!in_key || sb.length() > 0) {
            throw new IllegalArgumentException("Unexpected end of key properties string: " + keyProperties);
        }
    }

    public void append(String key, String rawValue) {
        if (this.keys.contains(key)) {
            return;
        }
        if (!this.keys.isEmpty()) {
            this.sb.append(',');
        }
        this.keys.add(key);
        this.sb.append(key);
        this.sb.append('=');
        this.sb.append(JMXNameBuilder.quoteKeyPropertyValue(rawValue));
    }

    public boolean isEmpty() {
        return this.sb.length() == 0;
    }

    public String toString() {
        return this.sb.toString();
    }

    public static String quoteKeyPropertyValue(String rawValue) {
        boolean legal = true;
        int n = rawValue.length();
        for (int i = 0; i < n; ++i) {
            switch (rawValue.charAt(i)) {
                case '\"': 
                case '*': 
                case ',': 
                case ':': 
                case '=': 
                case '?': {
                    legal = false;
                }
            }
        }
        if (legal) {
            return rawValue;
        }
        StringBuffer sb = new StringBuffer();
        sb.append('\"');
        int n2 = rawValue.length();
        block8: for (int i = 0; i < n2; ++i) {
            char c = rawValue.charAt(i);
            switch (c) {
                case '\n': {
                    sb.append("\\n");
                    continue block8;
                }
                case '\"': 
                case '*': 
                case '?': 
                case '\\': {
                    sb.append('\\');
                }
                default: {
                    sb.append(c);
                }
            }
        }
        sb.append('\"');
        return sb.toString();
    }

    public static void validateKeyProperties(String keyProperties) {
        if (keyProperties != null) {
            new JMXNameBuilder().appendKeyProperties(keyProperties);
        }
    }
}

