/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.util;

import com.devexperts.util.AtomicArrays;
import com.devexperts.util.UnsafeHolder;
import sun.misc.Unsafe;

class AtomicArraysUnsafe
extends AtomicArrays {
    private static final Unsafe unsafe = UnsafeHolder.UNSAFE;
    private static final int intBase = unsafe.arrayBaseOffset(int[].class);
    private static final int intScale = unsafe.arrayIndexScale(int[].class);
    private static final int longBase = unsafe.arrayBaseOffset(long[].class);
    private static final int longScale = unsafe.arrayIndexScale(long[].class);
    private static final int objBase = unsafe.arrayBaseOffset(Object[].class);
    private static final int objScale = unsafe.arrayIndexScale(Object[].class);

    AtomicArraysUnsafe() {
    }

    private static void throwIOOBE(int i, int length) {
        throw new IndexOutOfBoundsException("index=" + i + ", length=" + length);
    }

    private static long rawIntIndex(int[] a, int i) {
        if (i < 0 || i >= a.length) {
            AtomicArraysUnsafe.throwIOOBE(i, a.length);
        }
        return (long)intBase + (long)i * (long)intScale;
    }

    private static long rawLongIndex(long[] a, int i) {
        if (i < 0 || i >= a.length) {
            AtomicArraysUnsafe.throwIOOBE(i, a.length);
        }
        return (long)longBase + (long)i * (long)longScale;
    }

    private static long rawObjIndex(Object[] a, int i) {
        if (i < 0 || i >= a.length) {
            AtomicArraysUnsafe.throwIOOBE(i, a.length);
        }
        return (long)objBase + (long)i * (long)objScale;
    }

    @Override
    public void setVolatileInt(int[] a, int i, int val) {
        unsafe.putIntVolatile(a, AtomicArraysUnsafe.rawIntIndex(a, i), val);
    }

    @Override
    public int getVolatileInt(int[] a, int i) {
        return unsafe.getIntVolatile(a, AtomicArraysUnsafe.rawIntIndex(a, i));
    }

    @Override
    public int addAndGetInt(int[] a, int i, int delta) {
        int update;
        int expect;
        long index = AtomicArraysUnsafe.rawIntIndex(a, i);
        while (!unsafe.compareAndSwapInt(a, index, expect = unsafe.getInt(a, index), update = expect + delta)) {
        }
        return update;
    }

    @Override
    public boolean compareAndSetInt(int[] a, int i, int expect, int update) {
        return unsafe.compareAndSwapInt(a, AtomicArraysUnsafe.rawIntIndex(a, i), expect, update);
    }

    @Override
    public void setVolatileLong(long[] a, int i, long val) {
        unsafe.putLongVolatile(a, AtomicArraysUnsafe.rawLongIndex(a, i), val);
    }

    @Override
    public long getVolatileLong(long[] a, int i) {
        return unsafe.getLongVolatile(a, AtomicArraysUnsafe.rawLongIndex(a, i));
    }

    @Override
    public long addAndGetLong(long[] a, int i, long delta) {
        long update;
        long expect;
        long index = AtomicArraysUnsafe.rawLongIndex(a, i);
        while (!unsafe.compareAndSwapLong(a, index, expect = unsafe.getLong(a, index), update = expect + delta)) {
        }
        return update;
    }

    @Override
    public <T> void setVolatileObj(T[] a, int i, T val) {
        unsafe.putObjectVolatile(a, AtomicArraysUnsafe.rawObjIndex(a, i), val);
    }

    @Override
    public <T> T getVolatileObj(T[] a, int i) {
        return (T)unsafe.getObjectVolatile(a, AtomicArraysUnsafe.rawObjIndex(a, i));
    }
}

