/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.util;

import com.devexperts.logging.Logging;
import com.devexperts.util.AtomicArraysUnsafe;

public class AtomicArrays {
    public static final AtomicArrays INSTANCE = AtomicArrays.createInstance();

    private static AtomicArrays createInstance() {
        try {
            return new AtomicArraysUnsafe();
        }
        catch (Throwable t) {
            try {
                Logging.getLogging(AtomicArrays.class).warn("Cannot access sun.misc.Unsafe, fall back to SLOW MODE: " + t);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return new AtomicArrays();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVolatileInt(int[] a, int i, int val) {
        int[] nArray = a;
        synchronized (a) {
            a[i] = val;
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getVolatileInt(int[] a, int i) {
        int[] nArray = a;
        synchronized (a) {
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return a[i];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addAndGetInt(int[] a, int i, int delta) {
        int[] nArray = a;
        synchronized (a) {
            int n = i;
            int n2 = a[n] + delta;
            a[n] = n2;
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean compareAndSetInt(int[] a, int i, int expect, int update) {
        int[] nArray = a;
        synchronized (a) {
            if (a[i] == expect) {
                a[i] = update;
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVolatileLong(long[] a, int i, long val) {
        long[] lArray = a;
        synchronized (a) {
            a[i] = val;
            // ** MonitorExit[var5_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getVolatileLong(long[] a, int i) {
        long[] lArray = a;
        synchronized (a) {
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return a[i];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long addAndGetLong(long[] a, int i, long delta) {
        long[] lArray = a;
        synchronized (a) {
            int n = i;
            long l = a[n] + delta;
            a[n] = l;
            // ** MonitorExit[var5_4] (shouldn't be in output)
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void setVolatileObj(T[] a, int i, T val) {
        T[] TArray = a;
        synchronized (a) {
            a[i] = val;
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getVolatileObj(T[] a, int i) {
        T[] TArray = a;
        synchronized (a) {
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return a[i];
        }
    }
}

