/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.transport.stats;

import com.devexperts.transport.stats.ConnectionStats;

public class EndpointStats
extends ConnectionStats {
    private static final long serialVersionUID = 0L;
    private volatile long activeConnectionCount;
    private volatile long closedConnectionCount;

    public EndpointStats() {
    }

    public EndpointStats(EndpointStats other) {
        super(other);
        this.activeConnectionCount = other.activeConnectionCount;
        this.closedConnectionCount = other.closedConnectionCount;
    }

    public EndpointStats(EndpointStats cur, EndpointStats old) {
        super(cur, old);
        this.activeConnectionCount = cur.activeConnectionCount;
        this.closedConnectionCount = cur.closedConnectionCount - old.closedConnectionCount;
    }

    public long getActiveConnectionCount() {
        return this.activeConnectionCount;
    }

    public void setActiveConnectionCount(long activeConnectionCount) {
        this.activeConnectionCount = activeConnectionCount;
    }

    public void addActiveConnectionCount(long activeConnectionCount) {
        this.activeConnectionCount += activeConnectionCount;
    }

    public long getClosedConnectionCount() {
        return this.closedConnectionCount;
    }

    public void setClosedConnectionCount(long closedConnectionCount) {
        this.closedConnectionCount = closedConnectionCount;
    }

    public void addClosedConnectionCount(long closedConnectionCount) {
        this.closedConnectionCount += closedConnectionCount;
    }

    public void addEndpointStats(EndpointStats stats) {
        this.activeConnectionCount += stats.activeConnectionCount;
        this.closedConnectionCount += stats.closedConnectionCount;
        this.addConnectionStats(stats);
    }

    @Override
    public String toString() {
        return "active " + this.activeConnectionCount + ", closed " + this.closedConnectionCount + ", " + super.toString();
    }
}

