/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.transport.stats;

import java.io.Serializable;

public class ConnectionStats
implements Serializable {
    private static final long serialVersionUID = 0L;
    private volatile long readBytes;
    private volatile long writtenBytes;

    public ConnectionStats() {
    }

    public ConnectionStats(ConnectionStats other) {
        this.readBytes = other.readBytes;
        this.writtenBytes = other.writtenBytes;
    }

    public ConnectionStats(ConnectionStats cur, ConnectionStats old) {
        this.readBytes = cur.readBytes - old.readBytes;
        this.writtenBytes = cur.writtenBytes - old.writtenBytes;
    }

    public long getReadBytes() {
        return this.readBytes;
    }

    public void setReadBytes(long readBytes) {
        this.readBytes = readBytes;
    }

    public void addReadBytes(long readBytes) {
        this.readBytes += readBytes;
    }

    public long getWrittenBytes() {
        return this.writtenBytes;
    }

    public void setWrittenBytes(long writtenBytes) {
        this.writtenBytes = writtenBytes;
    }

    public void addWrittenBytes(long writtenBytes) {
        this.writtenBytes += writtenBytes;
    }

    public void addConnectionStats(ConnectionStats stats) {
        this.readBytes += stats.readBytes;
        this.writtenBytes += stats.writtenBytes;
    }

    public String toString() {
        return "read " + this.readBytes + ", written " + this.writtenBytes;
    }
}

