/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.rmi.task;

import com.devexperts.io.Marshalled;
import com.devexperts.logging.Logging;
import com.devexperts.rmi.RMIExceptionType;
import com.devexperts.rmi.RMIOperation;
import com.devexperts.rmi.impl.RMITaskImpl;
import com.devexperts.rmi.message.RMIErrorMessage;
import com.devexperts.rmi.message.RMIRequestMessage;
import com.devexperts.rmi.message.RMIResponseMessage;
import com.devexperts.rmi.message.RMIResponseType;
import com.devexperts.rmi.message.RMIResultMessage;
import com.devexperts.rmi.task.RMIChannel;
import com.devexperts.rmi.task.RMIContinuation;
import com.devexperts.rmi.task.RMITaskCancelListener;
import com.devexperts.rmi.task.RMITaskState;
import com.devexperts.util.TypedMap;
import com.dxfeed.promise.Promise;
import java.io.InvalidClassException;
import java.util.concurrent.Callable;

public abstract class RMITask<T> {
    private static final Logging log = Logging.getLogging(RMITask.class);
    private static final RMITaskCancelListener DEFAULT_CANCEL_LISTENER = RMITask::cancel;
    static final ThreadLocal<RMITaskImpl<?>> THREAD_TASK = new ThreadLocal();
    private final RMIRequestMessage<T> requestMessage;
    private RMITaskCancelListener cancelListener = DEFAULT_CANCEL_LISTENER;
    private final long submissionTime;
    private final TypedMap connectionVariables;
    private TypedMap taskVariables;
    private volatile RMITaskState state = RMITaskState.ACTIVE;
    private volatile RMIResponseMessage responseMessage;

    public static RMITask<?> current() {
        return THREAD_TASK.get();
    }

    public static <T> RMITask<T> current(Class<T> resultType) {
        RMITask task = THREAD_TASK.get();
        if (task == null) {
            throw new IllegalStateException("No task is currently executing");
        }
        try {
            Class<T> taskResultType = task.getOperation().getResultMarshaller().getClasses(resultType.getClassLoader())[0];
            if (!taskResultType.isAssignableFrom(resultType)) {
                throw new IllegalStateException("Incompatible result type: " + taskResultType.getName() + ", expected: " + resultType.getName());
            }
        }
        catch (InvalidClassException e) {
            throw new IllegalStateException("Cannot unmarshall result type is the expected class loader: " + task.getOperation().getResultMarshaller().getTypes(), e);
        }
        return task;
    }

    public long getSubmissionTime() {
        return this.submissionTime;
    }

    public RMIRequestMessage<T> getRequestMessage() {
        return this.requestMessage;
    }

    public RMIOperation<T> getOperation() {
        return this.requestMessage.getOperation();
    }

    public TypedMap getConnectionVariables() {
        return this.connectionVariables;
    }

    public synchronized TypedMap getTaskVariables() {
        if (this.taskVariables == null) {
            this.taskVariables = new TypedMap();
        }
        return this.taskVariables;
    }

    public RMIResponseMessage getResponseMessage() {
        return this.responseMessage;
    }

    public RMITaskState getState() {
        return this.state;
    }

    public abstract RMIChannel getChannel();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCancelListener(RMITaskCancelListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        boolean notifyImmediately = false;
        RMITask rMITask = this;
        synchronized (rMITask) {
            RMITaskCancelListener oldTaskCancelListener = RMITask.getTaskCancelListener(this.cancelListener);
            if (oldTaskCancelListener != DEFAULT_CANCEL_LISTENER) {
                throw new IllegalStateException();
            }
            this.cancelListener = this.cancelListener instanceof RMITaskCancelListenerImpl ? new RMITaskCancelListenerImpl(listener, ((RMITaskCancelListenerImpl)this.cancelListener).suspendedCancelListener) : listener;
            if (this.state.isCompletedOrCancelling()) {
                notifyImmediately = true;
            }
        }
        if (notifyImmediately) {
            listener.taskCompletedOrCancelling(this);
        }
    }

    public synchronized boolean hasCancelListener() {
        return RMITask.getTaskCancelListener(this.cancelListener) != DEFAULT_CANCEL_LISTENER;
    }

    public boolean isCompleted() {
        return this.state.isCompleted();
    }

    public void complete(T result) {
        this.completeResponse(new RMIResultMessage<T>(this.requestMessage.getOperation(), result));
    }

    public void completeExceptionally(Throwable exception) {
        this.completeExceptionally(RMIExceptionType.APPLICATION_ERROR, exception);
    }

    public void completeExceptionally(RMIExceptionType type, Throwable exception) {
        if (this.state.isCompleted()) {
            return;
        }
        this.logError(type, exception);
        this.completeResponse(new RMIErrorMessage(type, exception, null));
    }

    public void completeResponse(RMIResponseMessage responseMessage) {
        this.completeResponseImpl(responseMessage, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void completeResponseImpl(RMIResponseMessage responseMessage, boolean submitNextInQueue) {
        RMITaskCancelListener cancelListener;
        RMITask rMITask = this;
        synchronized (rMITask) {
            if (this.state.isCompleted()) {
                return;
            }
            if (responseMessage.getType() == RMIResponseType.SUCCESS && this.state == RMITaskState.CANCELLING) {
                responseMessage = new RMIErrorMessage(RMIExceptionType.CANCELLED_AFTER_EXECUTION, null, null);
            }
            this.responseMessage = responseMessage = this.ensureSerialized(responseMessage);
            this.state = responseMessage.getType() == RMIResponseType.ERROR ? RMITaskState.FAILED : RMITaskState.SUCCEEDED;
            cancelListener = this.cancelListener;
        }
        cancelListener.taskCompletedOrCancelling(this);
        this.taskCompleted(this, this.responseMessage, submitNextInQueue);
    }

    public final RMIContinuation<T> suspend(RMITaskCancelListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (this != RMITask.current()) {
            IllegalStateException e = new IllegalStateException("RMITask.suspend method was invoked by wrong thread");
            this.completeExceptionally(RMIExceptionType.INVALID_SUSPEND_STATE, e);
            throw e;
        }
        if (!this.suspendImpl(listener)) {
            listener.taskCompletedOrCancelling(this);
            return RMIContinuation.EMPTY;
        }
        return new RMIContinuation<T>(){
            private volatile boolean wasUsed;

            @Override
            public void resume(Callable<T> callable) {
                if (callable == null) {
                    throw new NullPointerException();
                }
                if (this.wasUsed) {
                    IllegalStateException e = new IllegalStateException("RMIContinuation can only be used once");
                    RMITask.this.completeExceptionally(RMIExceptionType.INVALID_SUSPEND_STATE, e);
                    return;
                }
                this.wasUsed = true;
                if (RMITask.this.resumeImpl()) {
                    RMITask.this.scheduleCallableOnResume(callable);
                }
            }
        };
    }

    public void completePromise(Promise<T> promise) {
        promise.whenDone(p -> {
            if (p.hasResult()) {
                this.complete(p.getResult());
            } else {
                this.completeExceptionally(p.getException());
            }
        });
        this.suspend(unused -> promise.cancel());
    }

    public void cancel() {
        this.cancel(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(RMIExceptionType type) {
        RMITaskCancelListener cancelListener;
        RMITask rMITask = this;
        synchronized (rMITask) {
            if (type == null) {
                type = this.getCancelTypeSyncImpl();
            }
            if (this.state.isCompleted()) {
                return;
            }
            this.responseMessage = new RMIErrorMessage(type, null, null);
            this.state = RMITaskState.FAILED;
            cancelListener = this.cancelListener;
        }
        cancelListener.taskCompletedOrCancelling(this);
        this.taskCompleted(this, this.responseMessage, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelWithConfirmation() {
        RMITaskCancelListener cancelListener;
        RMITask rMITask = this;
        synchronized (rMITask) {
            if (this.state.isCompleted()) {
                return;
            }
            this.state = RMITaskState.CANCELLING;
            cancelListener = this.cancelListener;
        }
        cancelListener.taskCompletedOrCancelling(this);
    }

    public boolean isNestedTask() {
        return this.getChannel().getOwner() != this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("state=").append(this.state.name()).append(", ").append("request=").append(this.requestMessage);
        if (this.responseMessage != null) {
            sb.append(", ").append("response=").append(this.responseMessage);
        }
        if (this.isNestedTask()) {
            sb.append(", ").append("channel=").append(this.getChannel());
        }
        return sb.toString();
    }

    protected abstract RMIExceptionType getCancelTypeSyncImpl();

    protected abstract void taskCompleted(RMITask<T> var1, RMIResponseMessage var2, boolean var3);

    protected abstract void scheduleCallableOnResume(Callable<T> var1);

    protected abstract void logError(RMIExceptionType var1, Throwable var2);

    protected synchronized boolean suspendImpl(RMITaskCancelListener listener) {
        if (this.state == RMITaskState.SUSPENDED) {
            throw new IllegalStateException("Task is already SUSPENDED");
        }
        if (this.state.isCompletedOrCancelling()) {
            return false;
        }
        assert (this.state == RMITaskState.ACTIVE);
        this.state = RMITaskState.SUSPENDED;
        this.cancelListener = new RMITaskCancelListenerImpl(RMITask.getTaskCancelListener(this.cancelListener), listener);
        return true;
    }

    protected RMITask(RMIRequestMessage<T> requestMessage, TypedMap connectionVariables) {
        this.requestMessage = requestMessage;
        this.connectionVariables = connectionVariables;
        this.submissionTime = System.currentTimeMillis();
    }

    private synchronized boolean resumeImpl() {
        if (this.state == RMITaskState.ACTIVE) {
            throw new IllegalStateException("Task is already ACTIVE");
        }
        if (this.state.isCompletedOrCancelling()) {
            return false;
        }
        assert (this.state == RMITaskState.SUSPENDED);
        this.state = RMITaskState.ACTIVE;
        this.cancelListener = RMITask.getTaskCancelListener(this.cancelListener);
        return true;
    }

    private RMIResponseMessage ensureSerialized(RMIResponseMessage responseMessage) {
        try {
            responseMessage.getMarshalledResult().ensureBytes();
        }
        catch (Throwable t1) {
            responseMessage = new RMIErrorMessage(RMIExceptionType.RESULT_MARSHALLING_ERROR, t1, null);
            try {
                responseMessage.getMarshalledResult().ensureBytes();
            }
            catch (Throwable t2) {
                log.error("MarshallingException can not be serialized", t2);
                responseMessage = new RMIErrorMessage(RMIExceptionType.RESULT_MARSHALLING_ERROR, null, null);
                responseMessage.getMarshalledResult().ensureBytes();
            }
        }
        return responseMessage;
    }

    private static RMITaskCancelListener getTaskCancelListener(RMITaskCancelListener cancelListener) {
        return cancelListener instanceof RMITaskCancelListenerImpl ? ((RMITaskCancelListenerImpl)cancelListener).taskCancelListener : cancelListener;
    }

    public Marshalled<?> getSubject() {
        return this.getChannel().getSubject();
    }

    private static class RMITaskCancelListenerImpl
    implements RMITaskCancelListener {
        private final RMITaskCancelListener taskCancelListener;
        private final RMITaskCancelListener suspendedCancelListener;

        private RMITaskCancelListenerImpl(RMITaskCancelListener taskCancelListener, RMITaskCancelListener suspendedCancelListener) {
            this.taskCancelListener = taskCancelListener;
            this.suspendedCancelListener = suspendedCancelListener;
        }

        @Override
        public void taskCompletedOrCancelling(RMITask<?> task) {
            this.taskCancelListener.taskCompletedOrCancelling(task);
            if (this.suspendedCancelListener != null) {
                this.suspendedCancelListener.taskCompletedOrCancelling(task);
            }
        }
    }
}

