/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.rmi.task;

import com.devexperts.io.Marshalled;
import com.devexperts.io.SerialClassContext;
import com.devexperts.rmi.RMIExceptionType;
import com.devexperts.rmi.RMIOperation;
import com.devexperts.rmi.task.RMIChannelSupport;
import com.devexperts.rmi.task.RMILocalService;
import com.devexperts.rmi.task.RMITask;
import java.io.InvalidClassException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;

public final class RMIServiceImplementation<T>
extends RMILocalService<T> {
    private final Class<T> serviceInterface;
    private final T implementation;
    private SerialClassContext serialContext;
    private volatile Map<String, Method> providingImplMethods;

    private static void trimStackTrack(Throwable cause, Method method) {
        StackTraceElement element;
        StackTraceElement[] causeStackTrace = cause.getStackTrace();
        StackTraceElement[] environmentStackTrace = Thread.currentThread().getStackTrace();
        int causePos = causeStackTrace.length;
        for (int environmentPos = environmentStackTrace.length; causePos > 0 && environmentPos > 0 && causeStackTrace[causePos - 1].equals(environmentStackTrace[environmentPos - 1]); --causePos, --environmentPos) {
        }
        String className = method.getDeclaringClass().getName();
        String methodName = method.getName();
        while (!(causePos <= 0 || className.equals((element = causeStackTrace[causePos - 1]).getClassName()) && methodName.equals(element.getMethodName()))) {
            --causePos;
        }
        StackTraceElement[] truncatedStackTrace = new StackTraceElement[causePos];
        System.arraycopy(causeStackTrace, 0, truncatedStackTrace, 0, causePos);
        cause.setStackTrace(truncatedStackTrace);
    }

    public void setClassLoader(ClassLoader loader) {
        this.serialContext = SerialClassContext.getDefaultSerialContext(loader);
    }

    public ClassLoader getClassLoader() {
        return this.serialContext.getClassLoader();
    }

    public void setSerialClassContext(SerialClassContext serialContext) {
        this.serialContext = serialContext;
    }

    public SerialClassContext getSerialClassContext() {
        return this.serialContext;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public RMIServiceImplementation(T implementation, Class<T> serviceInterface, String serviceName) {
        this(implementation, serviceInterface, serviceName, null);
    }

    public RMIServiceImplementation(T implementation, Class<T> serviceInterface, String serviceName, Map<String, String> properties) {
        super(serviceName, properties);
        if (implementation == null) {
            throw new NullPointerException("Implementation is null");
        }
        if (!serviceInterface.isInterface()) {
            throw new IllegalArgumentException("Only interface can be exported");
        }
        if (!serviceInterface.isInstance(implementation)) {
            throw new IllegalArgumentException("Exporting implementation does not implement the interface");
        }
        this.serviceInterface = serviceInterface;
        this.implementation = implementation;
    }

    public RMIServiceImplementation(T implementation, Class<T> serviceInterface) {
        this(implementation, serviceInterface, RMIServiceImplementation.getServiceName(serviceInterface));
    }

    @Override
    public T invoke(RMITask<T> task) throws Throwable {
        Object[] parameters;
        Method implMethod = this.getProvidingImplMethods().get(task.getOperation().getSignature());
        if (implMethod == null) {
            task.completeExceptionally(RMIExceptionType.OPERATION_NOT_PROVIDED, null);
            return null;
        }
        try {
            Marshalled<Object[]> marshalledParameters = task.getRequestMessage().getParameters();
            if (this.serialContext != null) {
                marshalledParameters = Marshalled.forBytes(marshalledParameters.getBytes(), marshalledParameters.getMarshaller(), this.serialContext);
            }
            parameters = marshalledParameters.getObject();
        }
        catch (Throwable t) {
            task.completeExceptionally(RMIExceptionType.PARAMETERS_UNMARSHALLING_ERROR, t);
            return null;
        }
        try {
            return (T)implMethod.invoke(this.implementation, parameters);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            RMIServiceImplementation.trimStackTrack(cause, implMethod);
            throw cause;
        }
        catch (IllegalAccessException e) {
            task.completeExceptionally(RMIExceptionType.ILLEGAL_ACCESS, e);
            return null;
        }
        catch (Throwable e) {
            task.completeExceptionally(RMIExceptionType.EXECUTION_ERROR, e);
            return null;
        }
    }

    @Override
    protected RMIChannelSupport<T> channelSupport() {
        return this.implementation instanceof RMIChannelSupport ? (RMIChannelSupport)this.implementation : null;
    }

    private synchronized Map<String, Method> fillProvidingImplMethodsSync() {
        Map<String, Method> providingImplMethods = this.providingImplMethods;
        if (providingImplMethods != null) {
            return providingImplMethods;
        }
        providingImplMethods = new HashMap<String, Method>();
        for (Method method : this.serviceInterface.getMethods()) {
            RMIOperation operation = RMIOperation.valueOf(this.serviceName, method);
            try {
                method = this.implementation.getClass().getMethod(method.getName(), operation.getParametersMarshaller().getClasses(this.serialContext != null ? this.serialContext.getClassLoader() : null));
                method.setAccessible(true);
            }
            catch (InvalidClassException | NoSuchMethodException e) {
                throw new IllegalArgumentException(e);
            }
            providingImplMethods.put(operation.getSignature(), method);
        }
        this.providingImplMethods = providingImplMethods;
        return this.providingImplMethods;
    }

    private Map<String, Method> getProvidingImplMethods() {
        Map<String, Method> providingImplMethods = this.providingImplMethods;
        if (providingImplMethods != null) {
            return providingImplMethods;
        }
        return this.fillProvidingImplMethodsSync();
    }
}

