/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.rmi.task;

import com.devexperts.connector.proto.JVMId;
import com.devexperts.io.BufferedInput;
import com.devexperts.io.BufferedOutput;
import com.devexperts.io.ByteArrayOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class RMIServiceId
implements Comparable<RMIServiceId> {
    private static final Map<String, AtomicLong> SERVICE_COUNTERS = new HashMap<String, AtomicLong>();
    private final String name;
    private final JVMId jvmId;
    private final long id;

    public static synchronized RMIServiceId newServiceId(String name) {
        if (!SERVICE_COUNTERS.containsKey(name)) {
            SERVICE_COUNTERS.put(name, new AtomicLong(0L));
        }
        return new RMIServiceId(name);
    }

    public static RMIServiceId readRMIServiceId(BufferedInput in, JVMId.ReadContext ctx) throws IOException {
        JVMId jvmId = JVMId.readJvmId(in, ctx);
        if (jvmId == null) {
            return null;
        }
        String name = in.readUTFString();
        long id = in.readCompactLong();
        return new RMIServiceId(name, jvmId, id);
    }

    public static void writeRMIServiceId(BufferedOutput out, RMIServiceId serviceId, JVMId.WriteContext ctx) throws IOException {
        if (serviceId == null) {
            out.writeByteArray(null);
            return;
        }
        JVMId.writeJvmId(out, serviceId.jvmId, ctx);
        out.writeUTFString(serviceId.getName());
        out.writeCompactLong(serviceId.id);
    }

    private RMIServiceId(String name, JVMId jvmId, long id) {
        this.name = name;
        this.jvmId = jvmId;
        this.id = id;
    }

    private RMIServiceId(String name) {
        this(name, JVMId.JVM_ID, SERVICE_COUNTERS.get(name).getAndIncrement());
    }

    public JVMId getJVMId() {
        return this.jvmId;
    }

    public String getName() {
        return this.name;
    }

    public long getId() {
        return this.id;
    }

    public byte[] getBytes() {
        ByteArrayOutput out = new ByteArrayOutput();
        try {
            RMIServiceId.writeRMIServiceId(out, this, null);
        }
        catch (IOException e) {
            throw new AssertionError();
        }
        return out.getBuffer();
    }

    @Override
    public int compareTo(RMIServiceId other) {
        int i = this.jvmId.compareTo(other.jvmId);
        if (i != 0) {
            return i;
        }
        i = this.name.compareTo(other.name);
        if (i != 0) {
            return i;
        }
        return Long.compare(this.id, other.id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RMIServiceId)) {
            return false;
        }
        RMIServiceId other = (RMIServiceId)o;
        return this.jvmId.equals(other.jvmId) && this.name.equals(other.name) && this.id == other.id;
    }

    public int hashCode() {
        return (this.jvmId.hashCode() * 27 + this.name.hashCode()) * 27 + ((int)this.id ^ (int)(this.id >> 32));
    }

    public String toString() {
        return this.name + "@" + (this.id == 0L ? this.jvmId.toString() : this.jvmId + "." + this.id);
    }
}

