/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.rmi.task;

import com.devexperts.connector.proto.EndpointId;
import com.devexperts.rmi.task.RMIServiceId;
import com.devexperts.util.IndexerFunction;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class RMIServiceDescriptor {
    public static final IndexerFunction<RMIServiceId, RMIServiceDescriptor> INDEXER_BY_SERVICE_ID = RMIServiceDescriptor::getServiceId;
    public static final String SERVICE_CAPACITY_PROPERTY = "capacity";
    public static final String SERVICE_SHARD_PROPERTY = "shard";
    public static final String SERVICE_PRIORITY_PROPERTY = "priority";
    private final RMIServiceId serviceId;
    private final int distance;
    private final Set<EndpointId> intermediateNodes;
    private final Map<String, String> properties;

    public static RMIServiceDescriptor createUnavailableDescriptor(RMIServiceId serviceId, Map<String, String> properties) {
        if (serviceId == null) {
            throw new NullPointerException("serviceId can not be null");
        }
        return new RMIServiceDescriptor(serviceId, Integer.MAX_VALUE, null, properties);
    }

    public static RMIServiceDescriptor createDescriptor(RMIServiceId serviceId, int distance, Set<EndpointId> intermediateNodes, Map<String, String> properties) {
        if (serviceId == null) {
            throw new NullPointerException("serviceId can not be null");
        }
        return new RMIServiceDescriptor(serviceId, distance, intermediateNodes, properties);
    }

    private RMIServiceDescriptor(RMIServiceId serviceId, int distance, Set<EndpointId> intermediateNodes, Map<String, String> properties) {
        this.serviceId = serviceId;
        this.distance = distance;
        this.intermediateNodes = intermediateNodes == null || intermediateNodes.isEmpty() ? Collections.emptySet() : (intermediateNodes.size() == 1 ? Collections.singleton(intermediateNodes.iterator().next()) : Collections.unmodifiableSet(new HashSet<EndpointId>(intermediateNodes)));
        this.properties = properties == null || properties.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(new HashMap<String, String>(properties));
    }

    public String getServiceName() {
        return this.serviceId.getName();
    }

    public RMIServiceId getServiceId() {
        return this.serviceId;
    }

    public int getDistance() {
        return this.distance;
    }

    public Set<EndpointId> getIntermediateNodes() {
        return this.intermediateNodes;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String getProperty(String key) {
        return this.properties.get(key);
    }

    public boolean isAvailable() {
        return this.distance != Integer.MAX_VALUE;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RMIServiceDescriptor)) {
            return false;
        }
        RMIServiceDescriptor other = (RMIServiceDescriptor)o;
        return this.serviceId.equals(other.serviceId) && this.distance == other.distance && this.intermediateNodes.equals(other.intermediateNodes) && this.properties.equals(other.properties);
    }

    public int hashCode() {
        return ((this.serviceId.hashCode() * 17 + this.distance) * 27 + this.intermediateNodes.hashCode() * 17) * 27 + this.properties.hashCode();
    }

    public String toString() {
        String dist = this.distance != Integer.MAX_VALUE ? String.valueOf(this.distance) : "INF";
        return this.serviceId + "{distance=" + dist + ", intermediateNodes=" + this.intermediateNodes + ", properties=" + this.properties + '}';
    }
}

