/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.rmi.task;

import com.devexperts.rmi.RMIServiceInterface;
import com.devexperts.rmi.task.RMIChannelSupport;
import com.devexperts.rmi.task.RMIObservableServiceDescriptors;
import com.devexperts.rmi.task.RMIServiceDescriptor;
import com.devexperts.rmi.task.RMIServiceDescriptorsListener;
import com.devexperts.rmi.task.RMIServiceId;
import com.devexperts.rmi.task.RMITask;
import com.devexperts.util.IndexerFunction;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public abstract class RMIService<T>
implements RMIObservableServiceDescriptors,
RMIChannelSupport<T> {
    public static final IndexerFunction<String, RMIService<?>> RMI_SERVICE_INDEXER = RMIService::getServiceName;
    public static final int UNAVAILABLE_METRIC = Integer.MAX_VALUE;
    private RMIServiceId serviceId;
    protected final String serviceName;
    protected Executor executor;

    public static String getServiceName(Class<?> serviceInterface) {
        RMIServiceInterface annotation = serviceInterface.getAnnotation(RMIServiceInterface.class);
        return annotation != null && !annotation.name().isEmpty() ? annotation.name() : serviceInterface.getName();
    }

    protected RMIService(String serviceName) {
        if (serviceName.indexOf(35) >= 0) {
            throw new IllegalArgumentException("Invalid service name: " + serviceName);
        }
        this.serviceName = serviceName;
    }

    public final String getServiceName() {
        return this.serviceName;
    }

    public final Executor getExecutor() {
        return this.executor;
    }

    @Override
    public void openChannel(RMITask<T> task) {
    }

    public abstract void processTask(RMITask<T> var1);

    @Override
    public boolean isAvailable() {
        return true;
    }

    protected final synchronized RMIServiceId getOrCreateServiceId() {
        if (this.serviceId == null) {
            this.serviceId = RMIServiceId.newServiceId(this.serviceName);
        }
        return this.serviceId;
    }

    @Nonnull
    public List<RMIServiceDescriptor> getDescriptors() {
        return Collections.singletonList(RMIServiceDescriptor.createDescriptor(this.getOrCreateServiceId(), 0, null, null));
    }

    @Override
    public synchronized void addServiceDescriptorsListener(RMIServiceDescriptorsListener listener) {
        List<RMIServiceDescriptor> descriptors = this.getDescriptors();
        if (!descriptors.isEmpty()) {
            listener.descriptorsUpdated(descriptors);
        }
    }

    @Override
    public synchronized void removeServiceDescriptorsListener(RMIServiceDescriptorsListener listener) {
        List<RMIServiceDescriptor> descriptors = this.getDescriptors().stream().map(descriptor -> RMIServiceDescriptor.createUnavailableDescriptor(descriptor.getServiceId(), descriptor.getProperties())).collect(Collectors.toList());
        if (!descriptors.isEmpty()) {
            listener.descriptorsUpdated(descriptors);
        }
    }

    public String toString() {
        return this.getOrCreateServiceId().toString();
    }
}

