/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.rmi.task;

import com.devexperts.io.MarshallingException;
import com.devexperts.rmi.RMIExceptionType;
import com.devexperts.rmi.impl.RMITaskImpl;
import com.devexperts.rmi.security.SecurityController;
import com.devexperts.rmi.task.RMIChannelSupport;
import com.devexperts.rmi.task.RMIService;
import com.devexperts.rmi.task.RMIServiceDescriptor;
import com.devexperts.rmi.task.RMITask;
import com.dxfeed.promise.Promise;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public abstract class RMILocalService<T>
extends RMIService<T> {
    private final List<RMIServiceDescriptor> descriptors;
    private static final Set<Class<?>> PRIMITIVE_NUMBER_TYPES = new HashSet<Class>(Arrays.asList(Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE));

    protected RMILocalService(String serviceName, Map<String, String> properties) {
        super(serviceName);
        this.descriptors = Collections.singletonList(RMIServiceDescriptor.createDescriptor(this.getOrCreateServiceId(), 0, null, properties));
    }

    @Override
    @Nonnull
    public List<RMIServiceDescriptor> getDescriptors() {
        return this.descriptors;
    }

    @Override
    public final void openChannel(RMITask<T> task) {
        RMIChannelSupport channelSupport = this.channelSupport();
        if (channelSupport == null) {
            return;
        }
        RMITaskImpl taskImpl = (RMITaskImpl)task;
        this.doAction(taskImpl, () -> {
            try {
                channelSupport.openChannel(taskImpl);
            }
            catch (Throwable t) {
                taskImpl.completeExceptionally(t);
                return;
            }
        });
    }

    @Override
    public final void processTask(RMITask<T> task) {
        RMITaskImpl taskImpl = (RMITaskImpl)task;
        this.doAction(taskImpl, () -> {
            try {
                T result = this.invoke(taskImpl);
                boolean suspended = taskImpl.getExecutionTask().getState().isSuspended();
                if (suspended && !RMILocalService.isDefaultValue(result, taskImpl.getOperation().getResultMarshaller().getClasses(null)[0])) {
                    IllegalStateException e = new IllegalStateException("Method that called suspend on this task returns non default value");
                    taskImpl.completeExceptionally(RMIExceptionType.INVALID_SUSPEND_STATE, e);
                    return;
                }
                if (result instanceof Promise) {
                    taskImpl.completePromise((Promise)result);
                    return;
                }
                if (!suspended && !taskImpl.isCompleted()) {
                    taskImpl.complete(result);
                }
            }
            catch (Throwable t) {
                taskImpl.completeExceptionally(t);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAction(RMITaskImpl<T> taskImpl, Runnable action) {
        RMITaskImpl<?> prevTask = RMITask.THREAD_TASK.get();
        RMITask.THREAD_TASK.set(taskImpl);
        try {
            Object subject = taskImpl.getSubject().getObject();
            SecurityController securityController = taskImpl.getSecurityController();
            securityController.doAs(subject, action);
        }
        catch (SecurityException e) {
            taskImpl.completeExceptionally(RMIExceptionType.SECURITY_VIOLATION, e);
        }
        catch (MarshallingException e) {
            taskImpl.completeExceptionally(RMIExceptionType.SUBJECT_UNMARSHALLING_ERROR, e);
        }
        finally {
            RMITask.THREAD_TASK.set(prevTask);
        }
    }

    public abstract T invoke(RMITask<T> var1) throws Throwable;

    protected RMIChannelSupport<T> channelSupport() {
        return null;
    }

    private static boolean isDefaultValue(Object result, Class<?> resultClass) {
        if (result == null) {
            return true;
        }
        if (!resultClass.isPrimitive()) {
            return false;
        }
        if (PRIMITIVE_NUMBER_TYPES.contains(resultClass)) {
            return result instanceof Number && ((Number)result).doubleValue() == 0.0;
        }
        if (resultClass == Boolean.TYPE) {
            return result instanceof Boolean && result.equals(false);
        }
        if (resultClass == Character.TYPE) {
            return result instanceof Character && result.equals(Character.valueOf('\u0000'));
        }
        return false;
    }
}

