/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.rmi.task;

import com.devexperts.rmi.message.RMIRequestMessage;
import com.devexperts.rmi.message.RMIRoute;
import com.devexperts.rmi.task.BalanceResult;
import com.devexperts.rmi.task.RMILoadBalancer;
import com.devexperts.rmi.task.RMIServiceDescriptor;
import com.devexperts.rmi.task.RMIServiceId;
import com.devexperts.util.IndexedSet;
import com.devexperts.util.SystemProperties;
import com.dxfeed.promise.Promise;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;

public class ConsistentLoadBalancer
implements RMILoadBalancer {
    private static final int DEFAULT_CAPACITY = SystemProperties.getIntProperty(ConsistentLoadBalancer.class, "defaultCapacity", 100);
    private static final int DEFAULT_PRIORITY = SystemProperties.getIntProperty(ConsistentLoadBalancer.class, "defaultPriority", 10);
    private static final int MAGIC = -1640531527;
    private final IndexedSet<RMIServiceId, RMIServiceDescriptor> descriptors = IndexedSet.create(RMIServiceDescriptor.INDEXER_BY_SERVICE_ID);
    private final NavigableMap<Integer, List<RMIServiceDescriptor>> ring = new TreeMap<Integer, List<RMIServiceDescriptor>>();
    private final Comparator<RMIServiceDescriptor> inShardComparator = this::compareInShard;

    @Override
    @Nonnull
    public synchronized Promise<BalanceResult> balance(@Nonnull RMIRequestMessage<?> request) {
        int requestKey;
        Map.Entry<Integer, List<RMIServiceDescriptor>> ceiling;
        if (this.descriptors.size() == 0 || request.getTarget() != null) {
            return Promise.completed(BalanceResult.route(request.getTarget()));
        }
        if (this.descriptors.size() == 1) {
            return Promise.completed(BalanceResult.route(this.descriptors.iterator().next().getServiceId()));
        }
        if (this.ring.isEmpty()) {
            this.descriptors.forEach(this::addInRing);
        }
        Map.Entry<Integer, List<RMIServiceDescriptor>> next = (ceiling = this.ring.ceilingEntry(requestKey = this.getRequestKey(request))) != null ? ceiling : this.ring.firstEntry();
        return Promise.completed(BalanceResult.route(next.getValue().get(0).getServiceId()));
    }

    @Override
    public synchronized void updateServiceDescriptor(@Nonnull RMIServiceDescriptor descriptor) {
        if (descriptor.isAvailable()) {
            this.processAvailableDescriptor(descriptor);
        } else {
            this.processUnavailableDescriptor(descriptor);
        }
    }

    @Override
    public void close() {
    }

    @GuardedBy(value="this")
    private void processAvailableDescriptor(@Nonnull RMIServiceDescriptor descriptor) {
        RMIServiceDescriptor existing = this.descriptors.put(descriptor);
        if (existing == null) {
            if (!this.ring.isEmpty()) {
                this.addInRing(descriptor);
            }
            return;
        }
        if (this.getCapacity(descriptor) != this.getCapacity(existing) || this.getPriority(descriptor) != this.getPriority(existing) || !Objects.equals(this.getShardName(descriptor), this.getShardName(existing))) {
            this.ring.clear();
        }
    }

    @GuardedBy(value="this")
    private void processUnavailableDescriptor(@Nonnull RMIServiceDescriptor descriptor) {
        if (!this.descriptors.remove(descriptor)) {
            return;
        }
        this.ring.clear();
    }

    public int getCapacity(RMIServiceDescriptor descriptor) {
        return this.getIntProperty(descriptor, "capacity", DEFAULT_CAPACITY);
    }

    public String getShardName(RMIServiceDescriptor descriptor) {
        return descriptor.getProperty("shard");
    }

    public byte[] getServiceSeed(RMIServiceDescriptor descriptor) {
        String shard = this.getShardName(descriptor);
        return shard != null ? shard.getBytes(StandardCharsets.UTF_8) : descriptor.getServiceId().getBytes();
    }

    public int getPriority(RMIServiceDescriptor descriptor) {
        return this.getIntProperty(descriptor, "priority", DEFAULT_PRIORITY);
    }

    private int getIntProperty(RMIServiceDescriptor descriptor, String key, int def) {
        try {
            String value = descriptor.getProperty(key);
            return value == null || value.isEmpty() ? def : Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public int compareInShard(RMIServiceDescriptor descriptor1, RMIServiceDescriptor descriptor2) {
        int pr2;
        int pr1 = this.getPriority(descriptor1);
        return pr1 < (pr2 = this.getPriority(descriptor2)) ? -1 : (pr1 > pr2 ? 1 : descriptor1.getServiceId().compareTo(descriptor2.getServiceId()));
    }

    public int getRequestKey(RMIRequestMessage<?> request) {
        RMIRoute route = request.getRoute();
        if (route.isEmpty()) {
            return 0;
        }
        return route.getFirst().hashCode() * -1640531527;
    }

    private void addInRing(RMIServiceDescriptor descriptor) {
        SecureRandom random;
        try {
            random = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
        random.setSeed(this.getServiceSeed(descriptor));
        for (int i = 0; i < this.getCapacity(descriptor); ++i) {
            int pos = random.nextInt();
            ArrayList<RMIServiceDescriptor> ids = (ArrayList<RMIServiceDescriptor>)this.ring.get(pos);
            if (ids == null) {
                ids = new ArrayList<RMIServiceDescriptor>(1);
                ids.add(descriptor);
                this.ring.put(pos, ids);
                continue;
            }
            int index = Collections.binarySearch(ids, descriptor, this.inShardComparator);
            if (index < 0) {
                ids.add(-index - 1, descriptor);
                continue;
            }
            ids.add(index + 1, descriptor);
        }
    }
}

