/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.rmi.task;

import com.devexperts.rmi.task.RMIServiceId;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class BalanceResult {
    private final RMIServiceId tentativeTarget;
    private final Type type;
    private final String rejectReason;

    private BalanceResult(RMIServiceId tentativeTarget, @Nonnull Type type, String rejectReason) {
        this.tentativeTarget = tentativeTarget;
        this.type = Objects.requireNonNull(type, "type");
        this.rejectReason = rejectReason;
    }

    @Nonnull
    public static BalanceResult route(@Nullable RMIServiceId tentativeTarget) {
        return new BalanceResult(tentativeTarget, Type.ROUTE, null);
    }

    @Nonnull
    public static BalanceResult reject(@Nullable RMIServiceId tentativeTarget, @Nullable String rejectReason) {
        return new BalanceResult(tentativeTarget, Type.REJECT, rejectReason == null ? "Request rejected by load balancer" : rejectReason);
    }

    @Nullable
    public RMIServiceId getTarget() {
        return this.tentativeTarget;
    }

    public boolean isReject() {
        return this.type == Type.REJECT;
    }

    @Nullable
    public String getRejectReason() {
        return this.rejectReason;
    }

    public String toString() {
        return "BalanceResult{" + (this.isReject() ? "REJECT routing to " + this.tentativeTarget + " due to '" + this.rejectReason + "'" : "ROUTE to " + this.tentativeTarget) + '}';
    }

    private static enum Type {
        REJECT,
        ROUTE;

    }
}

