/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.rmi.security;

import com.devexperts.logging.Logging;
import com.devexperts.rmi.security.SecurityController;

public class SecurityContext
implements SecurityController {
    private static final Logging log = Logging.getLogging(SecurityContext.class);
    protected static final SecurityContext INSTANCE = new SecurityContext();
    private final ThreadLocal<Object> subject = new InheritableThreadLocal<Object>();

    public static SecurityContext getInstance() {
        return INSTANCE;
    }

    private SecurityContext() {
    }

    @Override
    public Object getSubject() {
        return this.subject.get();
    }

    public void setSubject(Object subject) {
        if (this.subject.get() != null && subject != null) {
            log.warn("Subject " + this.subject.get() + " is replaced with " + subject + ". Check for missing call to SecurityContext.setSubject and/or use SecurityContext.doAs instead");
        }
        this.subject.set(subject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doAs(Object subject, Runnable action) {
        Object old = this.subject.get();
        try {
            this.subject.set(subject);
            action.run();
        }
        finally {
            this.subject.set(old);
        }
    }
}

