/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.rmi.message;

import com.devexperts.connector.proto.EndpointId;
import java.util.AbstractList;
import java.util.Arrays;

public class RMIRoute
extends AbstractList<EndpointId> {
    public static final RMIRoute EMPTY = new RMIRoute(new EndpointId[0]);
    private EndpointId[] ids;

    public static RMIRoute createRMIRoute(EndpointId ... ids) {
        int n = 0;
        for (EndpointId id : ids) {
            if (id == null) continue;
            ++n;
        }
        if (n == 0) {
            return EMPTY;
        }
        EndpointId[] filteredIds = new EndpointId[n];
        int i = 0;
        for (EndpointId id : ids) {
            if (id == null) continue;
            filteredIds[i++] = id;
        }
        return new RMIRoute(filteredIds);
    }

    private RMIRoute(EndpointId[] ids) {
        this.ids = ids;
    }

    public RMIRoute append(EndpointId id) {
        if (id == null) {
            throw new NullPointerException();
        }
        int n = this.ids.length;
        if (n > 0 && this.ids[n - 1].equals(id)) {
            return this;
        }
        EndpointId[] ids = Arrays.copyOf(this.ids, n + 1);
        ids[n] = id;
        return RMIRoute.createRMIRoute(ids);
    }

    @Override
    public EndpointId getFirst() {
        return this.size() == 0 ? null : this.ids[0];
    }

    @Override
    public EndpointId getLast() {
        return this.size() == 0 ? null : this.ids[this.size() - 1];
    }

    @Override
    public EndpointId get(int index) {
        return this.ids[index];
    }

    @Override
    public int size() {
        return this.ids.length;
    }

    public boolean isNotEmptyWithLast(EndpointId endpointId) {
        return this.size() > 1 && this.getLast().equals(endpointId);
    }

    @Override
    public String toString() {
        if (this.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.size(); ++i) {
            sb.append(this.ids[i]);
            if (i == this.size() - 1) continue;
            sb.append("->");
        }
        return sb.toString();
    }
}

