/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.rmi.message;

public enum RMIResponseType {
    SUCCESS(0),
    ERROR(1);

    private static final RMIResponseType[] TYPE_BY_ID;
    private final int id;

    public int getId() {
        return this.id;
    }

    public static RMIResponseType getById(int id) {
        return id >= 0 && id < TYPE_BY_ID.length ? TYPE_BY_ID[id] : null;
    }

    private RMIResponseType(int id) {
        this.id = id;
    }

    static {
        TYPE_BY_ID = new RMIResponseType[3];
        for (RMIResponseType type : RMIResponseType.values()) {
            if (TYPE_BY_ID[type.getId()] != null) {
                throw new AssertionError((Object)("Duplicate id: " + type.getId()));
            }
            RMIResponseType.TYPE_BY_ID[type.getId()] = type;
        }
    }
}

