/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.rmi.message;

import com.devexperts.io.BufferedInput;
import java.io.IOException;

public enum RMIRequestType {
    DEFAULT(0),
    ONE_WAY(1);

    private static final RMIRequestType[] TYPE_BY_ID;
    private final int id;

    public int getId() {
        return this.id;
    }

    public static RMIRequestType getById(int id) {
        return id >= 0 && id < TYPE_BY_ID.length ? TYPE_BY_ID[id] : null;
    }

    public static RMIRequestType readFromRequest(BufferedInput in) throws IOException {
        int id = in.readCompactInt();
        RMIRequestType type = RMIRequestType.getById(id);
        if (type == null) {
            throw new IOException("Invalid request type: " + Integer.toHexString(id));
        }
        return type;
    }

    private RMIRequestType(int id) {
        this.id = id;
    }

    static {
        TYPE_BY_ID = new RMIRequestType[3];
        for (RMIRequestType type : RMIRequestType.values()) {
            if (TYPE_BY_ID[type.getId()] != null) {
                throw new AssertionError((Object)("Duplicate id: " + type.getId()));
            }
            RMIRequestType.TYPE_BY_ID[type.getId()] = type;
        }
    }
}

