/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.rmi.message;

import com.devexperts.io.Marshalled;
import com.devexperts.rmi.RMIOperation;
import com.devexperts.rmi.message.RMIMessage;
import com.devexperts.rmi.message.RMIRequestType;
import com.devexperts.rmi.message.RMIRoute;
import com.devexperts.rmi.task.RMIServiceId;

public final class RMIRequestMessage<T>
extends RMIMessage {
    private final RMIRequestType requestType;
    private final RMIOperation<T> operation;
    private final Marshalled<Object[]> parameters;
    private final RMIServiceId target;

    public RMIRequestMessage(RMIRequestType type, RMIOperation<T> operation, Object ... parameters) {
        this(type, operation, Marshalled.forObject(parameters, operation.getParametersMarshaller()), RMIRoute.EMPTY, null);
    }

    public RMIRequestMessage(RMIRequestType type, RMIOperation<T> operation, Marshalled<Object[]> parameters, RMIRoute route, RMIServiceId target) {
        super(route);
        if (operation == null) {
            throw new NullPointerException("operation");
        }
        if (!parameters.getMarshaller().equals(operation.getParametersMarshaller())) {
            throw new IllegalArgumentException("Parameters used an incorrect marshaller");
        }
        if (type == null) {
            throw new NullPointerException("type");
        }
        this.requestType = type;
        this.operation = operation;
        this.parameters = parameters;
        this.target = target;
    }

    public RMIRequestMessage<T> changeTargetRoute(RMIServiceId newTarget, RMIRoute route) {
        return new RMIRequestMessage<T>(this.requestType, this.operation, this.parameters, route, newTarget);
    }

    public RMIServiceId getTarget() {
        return this.target;
    }

    public RMIOperation<T> getOperation() {
        return this.operation;
    }

    public Marshalled<Object[]> getParameters() {
        return this.parameters;
    }

    public RMIRequestType getRequestType() {
        return this.requestType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RMIRequestMessage message = (RMIRequestMessage)o;
        if (this.requestType != message.requestType) {
            return false;
        }
        if (!this.operation.equals(message.operation)) {
            return false;
        }
        return this.parameters.equals(message.parameters);
    }

    public int hashCode() {
        int result = this.requestType.hashCode();
        result = 31 * result + this.operation.hashCode();
        result = 31 * result + this.parameters.hashCode();
        return result + 7 * super.hashCode();
    }

    public String toString() {
        return "{operation=" + this.operation + ", target=" + this.target + ", parameters=" + this.parameters + ", route=" + this.route + '}';
    }
}

