/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.rmi.message;

import com.devexperts.io.BufferedInput;
import com.devexperts.io.BufferedOutput;
import com.devexperts.io.Marshaller;
import com.devexperts.io.SerialClassContext;
import com.devexperts.rmi.RMIException;
import com.devexperts.rmi.RMIExceptionType;
import java.io.EOFException;
import java.io.IOException;

class RMIExceptionMarshaller
extends Marshaller<RMIException> {
    static final RMIExceptionMarshaller INSTANCE = new RMIExceptionMarshaller();

    private RMIExceptionMarshaller() {
    }

    @Override
    public int readMarshalledLength(BufferedInput in) throws IOException {
        in.mark();
        long startPosition = in.totalPosition();
        in.readCompactInt();
        int messageLength = Math.max(0, in.readCompactInt());
        if (in.skip(messageLength) != (long)messageLength) {
            throw new EOFException("Input is too short, expected message length: " + messageLength);
        }
        int objectBodyLength = Math.max(0, in.readCompactInt());
        long objectBodyPosition = in.totalPosition();
        in.reset();
        return (int)(objectBodyPosition - startPosition) + objectBodyLength;
    }

    @Override
    public void writeMarshalledLength(BufferedOutput out, int length) {
    }

    @Override
    public void writeObjectTo(BufferedOutput out, RMIException object) throws IOException {
        out.writeCompactInt(object.getType().getId());
        out.writeUTFString(object.getMessage());
        out.writeObject(object);
    }

    @Override
    public RMIException readObjectFrom(BufferedInput in, int length, SerialClassContext serialContext) throws IOException {
        RMIException result;
        int typeId = in.readCompactInt();
        RMIExceptionType type = RMIExceptionType.getById(typeId);
        if (type == null) {
            type = RMIExceptionType.UNKNOWN_RMI_EXCEPTION;
        }
        String causeMessage = null;
        try {
            causeMessage = in.readUTFString();
            result = (RMIException)in.readObject(serialContext);
            if (result == null) {
                result = new RMIException(type, (Throwable)new Exception(causeMessage, null));
            }
        }
        catch (Throwable t) {
            result = causeMessage != null ? new RMIException(type, (Throwable)new Exception(causeMessage, t)) : new RMIException(type, t);
        }
        return result;
    }
}

