/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.rmi.message;

import com.devexperts.io.Marshalled;
import com.devexperts.io.Marshaller;
import com.devexperts.rmi.RMIException;
import com.devexperts.rmi.RMIExceptionType;
import com.devexperts.rmi.message.RMIExceptionMarshaller;
import com.devexperts.rmi.message.RMIResponseMessage;
import com.devexperts.rmi.message.RMIResponseType;
import com.devexperts.rmi.message.RMIRoute;
import java.util.Objects;

public final class RMIErrorMessage
extends RMIResponseMessage {
    public static Marshaller<RMIException> getExceptionMarshaller() {
        return RMIExceptionMarshaller.INSTANCE;
    }

    public RMIErrorMessage(RMIExceptionType exceptionType, Throwable cause, RMIRoute route) {
        super(Marshalled.forObject(new RMIException(Objects.requireNonNull(exceptionType, "exceptionType"), cause), RMIErrorMessage.getExceptionMarshaller()), RMIResponseType.ERROR, route);
    }

    public RMIErrorMessage(Marshalled<RMIException> exception, RMIRoute route) {
        super(exception, RMIResponseType.ERROR, route);
        if (exception.getMarshaller() != RMIErrorMessage.getExceptionMarshaller()) {
            throw new IllegalArgumentException("used an incorrect marshaller");
        }
    }

    public String toString() {
        return "{error=" + this.getMarshalledResult() + ", route=" + this.route + '}';
    }
}

