/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.rmi.impl;

import com.devexperts.rmi.RMIExceptionType;
import com.devexperts.rmi.impl.RMIChannelOwner;
import com.devexperts.rmi.impl.RMIConnection;
import com.devexperts.rmi.impl.RMIQueueType;
import com.devexperts.rmi.impl.RMITaskImpl;
import com.devexperts.rmi.impl.RMITaskResponse;
import com.devexperts.rmi.impl.RunningTask;
import com.devexperts.rmi.message.RMICancelType;
import com.devexperts.rmi.message.RMIRequestType;
import com.devexperts.rmi.task.RMIChannelType;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;

class TasksManager {
    private final RMIConnection connection;
    private final RunningTask runningTasks = new RunningTask();
    private final Queue<RMITaskResponse> completedTasks = new ConcurrentLinkedQueue<RMITaskResponse>();

    TasksManager(RMIConnection connection) {
        this.connection = connection;
    }

    void registerTask(RMITaskImpl<?> taskImpl) {
        this.runningTasks.add(taskImpl);
        if (this.connection.closed) {
            taskImpl.cancel(RMIExceptionType.DISCONNECTION);
        }
    }

    RMITaskResponse pollCompletedTask() {
        return this.completedTasks.poll();
    }

    int completedTaskSize() {
        return this.completedTasks.size();
    }

    void notifyTaskCompleted(RMITaskImpl<?> taskImpl) {
        assert (taskImpl.isNestedTask());
        this.runningTasks.remove(taskImpl);
        if (taskImpl.getRequestMessage().getRequestType() == RMIRequestType.DEFAULT) {
            this.completedTasks.add(new RMITaskResponse(taskImpl));
            this.connection.messageAdapter.rmiMessageAvailable(RMIQueueType.RESPONSE);
        }
    }

    void notifyTaskCompleted(RMIChannelOwner owner, long channelId) {
        this.runningTasks.remove(owner, channelId);
        if (owner.getChannelType() == RMIChannelType.SERVER_CHANNEL && owner.getRequestMessage().getRequestType() == RMIRequestType.DEFAULT) {
            this.completedTasks.add(new RMITaskResponse((RMITaskImpl)owner));
            this.connection.messageAdapter.rmiMessageAvailable(RMIQueueType.RESPONSE);
        }
    }

    void notifyTaskCompleted(RMIRequestType type, RMITaskResponse taskImpl) {
        if (type == RMIRequestType.DEFAULT) {
            this.completedTasks.add(taskImpl);
            this.connection.messageAdapter.rmiMessageAvailable(RMIQueueType.RESPONSE);
        }
    }

    void close() {
        this.runningTasks.close();
    }

    void cancelTask(long requestId, long channelId, int cancellationFlags, RMIChannelType type) {
        RMITaskImpl<?> task = this.runningTasks.removeById(requestId, channelId, type);
        if (task == null) {
            return;
        }
        if ((cancellationFlags & RMICancelType.ABORT_RUNNING.getId()) != 0) {
            task.cancel(RMIExceptionType.CANCELLED_DURING_EXECUTION);
        } else {
            task.cancelWithConfirmation();
        }
    }

    void cancelAllTasks(long channelId, int cancellationFlags, RMIChannelType type) {
        Set<RMITaskImpl<?>> tasks = this.runningTasks.removeAllById(channelId, type);
        if (tasks == null) {
            return;
        }
        for (RMITaskImpl<?> task : tasks) {
            if ((cancellationFlags & RMICancelType.ABORT_RUNNING.getId()) != 0) {
                task.cancel(RMIExceptionType.CANCELLED_DURING_EXECUTION);
                continue;
            }
            task.cancelWithConfirmation();
        }
    }

    boolean hasRunningTask() {
        return this.runningTasks.hasServerChannelTask();
    }
}

