/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.rmi.impl;

import com.devexperts.connector.proto.EndpointId;
import com.devexperts.logging.Logging;
import com.devexperts.rmi.impl.RMIConnection;
import com.devexperts.rmi.task.RMIObservableServiceDescriptors;
import com.devexperts.rmi.task.RMIServiceDescriptor;
import com.devexperts.rmi.task.RMIServiceDescriptorsListener;
import com.devexperts.rmi.task.RMIServiceId;
import com.devexperts.util.IndexedSet;
import com.devexperts.util.IndexerFunction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;

public class ServiceRouter<T>
implements RMIObservableServiceDescriptors {
    private final IndexerFunction<T, Ref<T>> indexerRefByT = value -> value.obj;
    private final List<Ref<T>> nearest = new ArrayList<Ref<T>>();
    private final Set<EndpointId> intermediateNodes = new HashSet<EndpointId>();
    private int bestDistance = Integer.MAX_VALUE;
    private int lastSendDistance = Integer.MAX_VALUE;
    private final List<RMIServiceDescriptorsListener> listeners = new CopyOnWriteArrayList<RMIServiceDescriptorsListener>();
    private final IndexedSet<T, Ref<T>> descriptors = IndexedSet.create(this.indexerRefByT);
    private final RMIServiceId serviceId;
    private final EndpointId endpointId;

    public static <T> ServiceRouter<T> createRouter(EndpointId endpoint, RMIServiceId serviceId) {
        if (serviceId == null) {
            throw new NullPointerException("ServiceId can not be null");
        }
        return new ServiceRouter<T>(endpoint, serviceId);
    }

    static ServiceRouter<RMIConnection> createAnonymousRouter(EndpointId endpointId) {
        return new AnonymousRouter(endpointId);
    }

    private ServiceRouter(EndpointId endpointId, RMIServiceId serviceId) {
        this.endpointId = endpointId;
        this.serviceId = serviceId;
    }

    public synchronized void updateDescriptor(RMIServiceDescriptor descriptor, int dist, T obj) {
        if (dist == Integer.MAX_VALUE) {
            this.removeDescriptor(descriptor, obj);
            return;
        }
        Ref<T> ref = new Ref<T>(descriptor, obj);
        this.descriptors.add(ref);
        if (this.updateDistanceInfo(ref)) {
            this.notifyListener(this.pickFirstDescriptor(), this.bestDistance);
        }
    }

    public synchronized void removeDescriptor(RMIServiceDescriptor descriptor, T obj) {
        if (this.descriptors.removeKey(obj) != null && this.updateDistanceInfo(new Ref<T>(descriptor, obj))) {
            this.notifyListener(this.nearest.isEmpty() ? descriptor : this.pickFirstDescriptor(), this.bestDistance);
        }
    }

    public synchronized RMIServiceDescriptor pickFirstDescriptor() {
        if (this.nearest.isEmpty()) {
            return null;
        }
        int randomIndex = ThreadLocalRandom.current().nextInt(this.nearest.size());
        RMIServiceDescriptor descriptor = this.nearest.get((int)randomIndex).descriptor;
        return RMIServiceDescriptor.createDescriptor(this.serviceId, descriptor.getDistance(), this.intermediateNodes, descriptor.getProperties());
    }

    public synchronized T pickRandom() {
        if (this.nearest.isEmpty()) {
            return null;
        }
        int randomIndex = ThreadLocalRandom.current().nextInt(this.nearest.size());
        return this.nearest.get((int)randomIndex).obj;
    }

    @Override
    public synchronized void addServiceDescriptorsListener(RMIServiceDescriptorsListener listener) {
        if (!this.isEmpty()) {
            listener.descriptorsUpdated(Collections.singletonList(this.pickFirstDescriptor()));
        }
        this.listeners.add(listener);
    }

    @Override
    public synchronized void removeServiceDescriptorsListener(RMIServiceDescriptorsListener listener) {
        listener.descriptorsUpdated(Collections.singletonList(RMIServiceDescriptor.createUnavailableDescriptor(this.serviceId, null)));
        this.listeners.remove(listener);
    }

    @Override
    public boolean isAvailable() {
        return !this.isEmpty();
    }

    public synchronized String toString() {
        return "Server " + this.endpointId + " ServiceRoute{serviceId=" + this.serviceId + ", nearest=" + this.nearest + ", bestDist=" + this.bestDistance + ", descriptors=" + this.descriptors + "lastSendDist=" + this.lastSendDistance + "}";
    }

    synchronized boolean isEmpty() {
        return this.descriptors.isEmpty();
    }

    private boolean updateDistanceInfo(Ref<T> ref) {
        if (!ref.descriptor.isAvailable()) {
            if (this.nearest.isEmpty()) {
                return false;
            }
        } else if (this.nearest.isEmpty() || this.bestDistance > ref.distance) {
            this.nearest.clear();
            this.nearest.add(ref);
            this.intermediateNodes.clear();
            this.intermediateNodes.addAll(ref.descriptor.getIntermediateNodes());
            this.bestDistance = ref.distance;
            return true;
        }
        this.nearest.remove(ref);
        if (!this.nearest.isEmpty()) {
            int sizeIntermediate = this.intermediateNodes.size();
            this.intermediateNodes.clear();
            for (Ref<T> tRef : this.nearest) {
                this.intermediateNodes.addAll(tRef.descriptor.getIntermediateNodes());
            }
            return sizeIntermediate != this.intermediateNodes.size();
        }
        this.updateNearest();
        return true;
    }

    private void updateNearest() {
        this.nearest.clear();
        this.intermediateNodes.clear();
        this.bestDistance = Integer.MAX_VALUE;
        for (Ref<T> ref : this.descriptors) {
            if (ref.distance == this.bestDistance) {
                this.nearest.add(ref);
                this.intermediateNodes.addAll(ref.descriptor.getIntermediateNodes());
                continue;
            }
            if (ref.distance >= this.bestDistance) continue;
            this.nearest.clear();
            this.intermediateNodes.clear();
            this.bestDistance = ref.distance;
            this.nearest.add(ref);
            this.intermediateNodes.addAll(ref.descriptor.getIntermediateNodes());
        }
    }

    private void notifyListener(RMIServiceDescriptor descriptor, int newDistance) {
        this.lastSendDistance = newDistance;
        for (RMIServiceDescriptorsListener listener : this.listeners) {
            try {
                listener.descriptorsUpdated(Collections.singletonList(descriptor));
            }
            catch (Throwable t) {
                Logging.getLogging(ServiceRouter.class).error("Failed to update service descriptors", t);
            }
        }
    }

    static class Ref<T>
    implements Comparable<Ref<T>> {
        final int distance;
        final RMIServiceDescriptor descriptor;
        final T obj;

        Ref(RMIServiceDescriptor descriptor, T obj) {
            this.descriptor = descriptor;
            this.distance = descriptor.getDistance();
            this.obj = obj;
        }

        @Override
        public int compareTo(@Nonnull Ref<T> o) {
            return this.distance - o.distance;
        }

        public int hashCode() {
            return (this.descriptor != null ? this.descriptor.getServiceId().hashCode() : super.hashCode()) * 27 + this.obj.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Ref)) {
                return false;
            }
            Ref other = (Ref)obj;
            return this.descriptor != null ? this.descriptor.getServiceId().equals(other.descriptor.getServiceId()) && this.obj.equals(other.obj) : other.descriptor == null && obj.equals(other.obj);
        }

        public String toString() {
            return "Ref{descriptor=" + this.descriptor + ", distance=" + this.distance + ", obj=" + this.obj + "}";
        }
    }

    static class AnonymousRouter
    extends ServiceRouter<RMIConnection> {
        ArrayList<RMIConnection> connections = new ArrayList();

        AnonymousRouter(EndpointId endpointId) {
            super(endpointId, null);
        }

        @Override
        public synchronized void updateDescriptor(RMIServiceDescriptor descriptor, int dist, RMIConnection connection) {
            this.connections.add(connection);
        }

        @Override
        public synchronized void removeDescriptor(RMIServiceDescriptor descriptor, RMIConnection obj) {
            this.connections.remove(obj);
        }

        @Override
        public synchronized void addServiceDescriptorsListener(RMIServiceDescriptorsListener listener) {
        }

        @Override
        public synchronized void removeServiceDescriptorsListener(RMIServiceDescriptorsListener listener) {
        }

        @Override
        public synchronized RMIConnection pickRandom() {
            if (this.connections.isEmpty()) {
                return null;
            }
            int randomIndex = ThreadLocalRandom.current().nextInt(this.connections.size());
            return this.connections.get(randomIndex);
        }
    }
}

