/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.rmi.impl;

import com.devexperts.util.InvalidFormatException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class ServiceFilter {
    public static final ServiceFilter ANYTHING = new ServiceFilter(FilterType.ANYTHING, Atom.ANYTHING);
    public static final ServiceFilter NOTHING = new ServiceFilter(FilterType.NOTHING, Atom.NOTHING);
    private String serviceNames;
    private final Atom[] services;
    private final FilterType type;

    public static ServiceFilter valueOf(String serviceNames) {
        if (serviceNames == null) {
            return ANYTHING;
        }
        boolean wrapped = serviceNames.startsWith("(") && serviceNames.endsWith(")");
        String str = wrapped ? serviceNames : "(" + serviceNames + ")";
        StringTokenizer st = new StringTokenizer(str.substring(1, str.length() - 1), ",", false);
        int nToken = st.countTokens();
        if (nToken == 0) {
            return NOTHING;
        }
        Atom[] services = new Atom[nToken];
        FilterType type = FilterType.SIMPLE;
        for (int i = 0; i < nToken; ++i) {
            services[i] = new Atom(st.nextToken());
            if (services[i].type == FilterType.ANYTHING) {
                return ANYTHING;
            }
            if (services[i].type != FilterType.PATTERN) continue;
            type = FilterType.PATTERN;
        }
        return new ServiceFilter(type, services);
    }

    private ServiceFilter(ServiceFilter filter) {
        this.services = new Atom[filter.services.length];
        System.arraycopy(filter.services, 0, this.services, 0, this.services.length);
        this.type = filter.type;
    }

    private ServiceFilter(FilterType type, Atom ... services) {
        this.services = services;
        this.type = type;
    }

    private ServiceFilter(Atom service) {
        this(service.type, service);
    }

    public boolean accept(String serviceName) {
        if (this.type == FilterType.ANYTHING) {
            return true;
        }
        if (this.type == FilterType.NOTHING) {
            return false;
        }
        for (Atom service : this.services) {
            if (!service.accept(serviceName)) continue;
            return true;
        }
        return false;
    }

    public ServiceFilter intersection(ServiceFilter filter) {
        if (filter.type == FilterType.NOTHING || this.type == FilterType.NOTHING) {
            return NOTHING;
        }
        if (this.type == FilterType.ANYTHING) {
            return new ServiceFilter(filter);
        }
        if (filter.type == FilterType.ANYTHING) {
            return new ServiceFilter(this);
        }
        if (this.type == filter.type && this.equals(filter)) {
            return new ServiceFilter(this);
        }
        FilterType newType = FilterType.SIMPLE;
        ArrayList<Atom> services = new ArrayList<Atom>();
        for (Atom s1 : this.services) {
            for (Atom s2 : filter.services) {
                ServiceFilter intersect = s1.intersection(s2);
                if (intersect.type == FilterType.NOTHING) continue;
                if (intersect.type == FilterType.PATTERN) {
                    newType = FilterType.PATTERN;
                }
                services.addAll(Arrays.asList(intersect.services));
            }
        }
        if (services.isEmpty()) {
            return NOTHING;
        }
        return new ServiceFilter(newType, services.toArray(new Atom[services.size()]));
    }

    Atom[] getServices() {
        return this.services;
    }

    FilterType getType() {
        return this.type;
    }

    public int hashCode() {
        return this.type.hashCode() * 17 + Arrays.hashCode(this.services);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ServiceFilter)) {
            return false;
        }
        ServiceFilter other = (ServiceFilter)obj;
        if (this.type == FilterType.ANYTHING && other == ANYTHING || this.type == FilterType.NOTHING && other == NOTHING) {
            return true;
        }
        return this.type == other.type && Arrays.equals(this.services, ((ServiceFilter)obj).services);
    }

    public String toString() {
        return this.getServiceNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getServiceNames() {
        if (this.serviceNames != null) {
            return this.serviceNames;
        }
        ServiceFilter serviceFilter = this;
        synchronized (serviceFilter) {
            if (this.serviceNames != null) {
                return this.serviceNames;
            }
            StringBuilder sb = new StringBuilder("(");
            for (int i = 0; i < this.services.length; ++i) {
                if (i != 0) {
                    sb.append(',');
                }
                sb.append(this.services[i].toString());
            }
            sb.append(')');
            this.serviceNames = sb.toString();
            return this.serviceNames;
        }
    }

    static enum FilterType {
        ANYTHING,
        NOTHING,
        PATTERN,
        SIMPLE;

    }

    static class Atom {
        static final Atom ANYTHING = new Atom("*");
        static final Atom NOTHING = new Atom("");
        final ServiceFilter wrapper;
        final String serviceName;
        final FilterType type;
        volatile Pattern pattern;

        private static String stringIntersection(String left, String right) {
            int length = Math.min(left.length(), right.length());
            StringBuilder l = new StringBuilder(left);
            StringBuilder r = new StringBuilder(right);
            if (l.length() > length) {
                l.delete(0, l.length() - length);
            } else if (r.length() > length) {
                r = r.delete(length, r.length());
            }
            while (length != 0) {
                if (l.indexOf(r.toString()) != -1) {
                    return l.toString();
                }
                l = l.deleteCharAt(0);
                r = r.deleteCharAt(--length);
            }
            return "";
        }

        Atom(String serviceName) {
            for (int i = 0; i < serviceName.length(); ++i) {
                char c = serviceName.charAt(i);
                if (Character.isJavaIdentifierPart(c) || c == '*' || c == '.' || c == '|') continue;
                throw new InvalidFormatException("Can only use the Java identifier parts, '.', or \"*\" in service name");
            }
            this.serviceName = serviceName;
            int starIndex = serviceName.indexOf(42);
            if (starIndex >= 0) {
                if (serviceName.length() == 1) {
                    this.type = FilterType.ANYTHING;
                } else {
                    if (serviceName.indexOf(42, starIndex + 1) >= 0) {
                        throw new InvalidFormatException("Cannot have more than one '*' in service name");
                    }
                    this.type = FilterType.PATTERN;
                }
            } else {
                this.type = serviceName.isEmpty() ? FilterType.NOTHING : FilterType.SIMPLE;
            }
            this.wrapper = new ServiceFilter(this);
        }

        boolean accept(String name) {
            if (this.type == FilterType.ANYTHING) {
                return true;
            }
            if (this.type == FilterType.NOTHING) {
                return false;
            }
            if (this.type == FilterType.SIMPLE) {
                return this.serviceName.equals(name);
            }
            return this.getPattern().matcher(name).matches();
        }

        ServiceFilter intersection(Atom service) {
            Atom other;
            String othName;
            String patName;
            if (this.equals(service)) {
                return this.wrapper;
            }
            if (this.type == FilterType.SIMPLE && service.type == FilterType.SIMPLE) {
                return NOTHING;
            }
            if (this.type == FilterType.PATTERN && service.type == FilterType.PATTERN) {
                String rightIntersect;
                String right;
                String leftIntersect;
                String left;
                int pos2;
                String s1 = this.serviceName;
                String s2 = service.serviceName;
                int pos1 = s1.indexOf(42);
                if (pos1 <= (pos2 = s2.indexOf(42))) {
                    if (!s2.startsWith(s1.substring(0, pos1))) {
                        return NOTHING;
                    }
                    left = s2.substring(0, pos2);
                    leftIntersect = left.substring(pos1);
                } else {
                    if (!s1.startsWith(s2.substring(0, pos2))) {
                        return NOTHING;
                    }
                    left = s1.substring(0, pos1);
                    leftIntersect = left.substring(pos2);
                }
                if (s1.length() - pos1 <= s2.length() - pos2) {
                    if (!s2.endsWith(s1.substring(pos1 + 1))) {
                        return NOTHING;
                    }
                    right = s2.substring(pos2 + 1);
                    rightIntersect = right.substring(0, right.length() - s1.length() + pos1 + 1);
                } else {
                    if (!s1.endsWith(s2.substring(pos2 + 1))) {
                        return NOTHING;
                    }
                    right = s1.substring(pos1 + 1);
                    rightIntersect = right.substring(0, right.length() - s2.length() + pos2 + 1);
                }
                Atom pattern = new Atom(left + '*' + right);
                if (left.isEmpty() || right.isEmpty()) {
                    return pattern.wrapper;
                }
                String intersect = Atom.stringIntersection(leftIntersect, rightIntersect);
                if (intersect.isEmpty()) {
                    return pattern.wrapper;
                }
                String simpleName = left.substring(0, left.length() - intersect.length()) + intersect + right.substring(intersect.length());
                Atom simple = new Atom(simpleName);
                return new ServiceFilter(FilterType.PATTERN, new Atom[]{pattern, simple});
            }
            if (this.type == FilterType.ANYTHING) {
                return new ServiceFilter(service.wrapper);
            }
            if (service.type == FilterType.ANYTHING) {
                return new ServiceFilter(this.wrapper);
            }
            if (this.type == FilterType.NOTHING || service.type == FilterType.NOTHING) {
                return NOTHING;
            }
            if (this.type == FilterType.PATTERN && service.type == FilterType.SIMPLE) {
                patName = this.serviceName;
                othName = service.serviceName;
                other = service;
            } else if (service.type == FilterType.PATTERN && this.type == FilterType.SIMPLE) {
                patName = service.serviceName;
                othName = this.serviceName;
                other = this;
            } else {
                throw new IllegalArgumentException();
            }
            int starPos = patName.indexOf(42);
            return othName.startsWith(patName.substring(0, starPos)) && othName.endsWith(patName.substring(starPos + 1)) ? new ServiceFilter(other.wrapper) : NOTHING;
        }

        public int hashCode() {
            return this.serviceName.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Atom)) {
                return false;
            }
            if (this.type == FilterType.ANYTHING && ((Atom)obj).type == FilterType.ANYTHING || this.type == FilterType.NOTHING && ((Atom)obj).type == FilterType.NOTHING) {
                return true;
            }
            return this.serviceName.equals(((Atom)obj).serviceName);
        }

        public String toString() {
            return this.serviceName;
        }

        private Pattern getPattern() {
            Pattern pattern = this.pattern;
            if (pattern != null) {
                return pattern;
            }
            String regex = "\\Q" + this.serviceName.replace("*", "\\E.*\\Q").replace("|", "\\E|\\Q") + "\\E";
            this.pattern = Pattern.compile(regex);
            return this.pattern;
        }
    }
}

