/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.rmi.impl;

import com.devexperts.rmi.impl.AbstractServiceDescriptorsProcessor;
import com.devexperts.rmi.impl.LoadBalancers;
import com.devexperts.rmi.impl.RMIConnection;
import com.devexperts.rmi.impl.RMIServerImpl;
import com.devexperts.rmi.impl.ServiceRouter;
import com.devexperts.rmi.message.RMIRequestMessage;
import com.devexperts.rmi.task.BalanceResult;
import com.devexperts.rmi.task.RMILoadBalancerFactory;
import com.devexperts.rmi.task.RMIService;
import com.devexperts.rmi.task.RMIServiceDescriptor;
import com.devexperts.rmi.task.RMIServiceId;
import com.dxfeed.promise.Promise;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

class ServerSideServices {
    private final RMIServerImpl server;
    private final Map<RMIServiceId, ServiceRouter<RMIService<?>>> clientServiceMap = new HashMap();
    private final Map<RMIServiceId, RMIService<?>> localServices = new HashMap();
    private final Set<RMIService<?>> services = Collections.newSetFromMap(new IdentityHashMap());
    private final LoadBalancers loadBalancers;

    ServerSideServices(RMIServerImpl server, List<RMILoadBalancerFactory> rmiLoadBalancerFactories) {
        this.server = server;
        this.loadBalancers = new LoadBalancers(rmiLoadBalancerFactories);
    }

    synchronized void put(RMIService<?> service) {
        if (this.services.add(service)) {
            service.addServiceDescriptorsListener(new ServiceProcessor(service));
        }
    }

    synchronized void remove(RMIService<?> service) {
        if (this.services.remove(service)) {
            service.removeServiceDescriptorsListener(new ServiceProcessor(service));
        }
    }

    synchronized RMIService<?> getService(RMIServiceId serviceId) {
        RMIService<?> result = this.localServices.get(serviceId);
        if (result != null) {
            return result;
        }
        ServiceRouter<RMIService<?>> router = this.clientServiceMap.get(serviceId);
        if (router != null) {
            return router.pickRandom();
        }
        return null;
    }

    synchronized boolean sendAllDescriptorsToConnection(RMIConnection connection) {
        ArrayList<RMIServiceDescriptor> descriptors = new ArrayList<RMIServiceDescriptor>();
        for (ServiceRouter<RMIService<?>> serviceRouter : this.clientServiceMap.values()) {
            if (serviceRouter.isEmpty()) continue;
            descriptors.add(serviceRouter.pickFirstDescriptor());
        }
        for (RMIService rMIService : this.localServices.values()) {
            for (RMIServiceDescriptor descriptor : rMIService.getDescriptors()) {
                if (descriptor.getDistance() != 0) continue;
                descriptors.add(descriptor);
            }
        }
        connection.serverDescriptorsManager.addServiceDescriptors(descriptors);
        return !descriptors.isEmpty();
    }

    synchronized Promise<BalanceResult> balance(RMIRequestMessage<?> message) {
        return this.loadBalancers.balance(message);
    }

    synchronized void close() {
        this.loadBalancers.close();
    }

    private synchronized void descriptorsUpdateImpl(RMIService<?> service, List<RMIServiceDescriptor> descriptors) {
        ArrayList<RMIServiceDescriptor> localServiceDescriptors = new ArrayList<RMIServiceDescriptor>();
        for (RMIServiceDescriptor descriptor : descriptors) {
            if (descriptor.getDistance() == 0) {
                this.localServices.put(descriptor.getServiceId(), service);
                localServiceDescriptors.add(descriptor);
            } else {
                if (this.localServices.remove(descriptor.getServiceId()) != null) {
                    localServiceDescriptors.add(descriptor);
                }
                this.updateInClientServicesMap(service, descriptor);
            }
            this.loadBalancers.updateDescriptorInLoadBalancer(descriptor);
        }
        this.server.sendDescriptorsToAllConnections(localServiceDescriptors);
    }

    private void updateInClientServicesMap(RMIService<?> service, RMIServiceDescriptor descriptor) {
        RMIServiceId serviceId = descriptor.getServiceId();
        ServiceRouter<RMIService<Object>> router = this.clientServiceMap.get(serviceId);
        if (router == null) {
            if (!descriptor.isAvailable()) {
                return;
            }
            router = ServiceRouter.createRouter(this.server.endpoint.getEndpointId(), serviceId);
            router.addServiceDescriptorsListener(new ServerRouterProcessor());
            this.clientServiceMap.put(serviceId, router);
        }
        router.updateDescriptor(descriptor, descriptor.getDistance(), service);
        if (router.isEmpty()) {
            this.clientServiceMap.remove(descriptor.getServiceId());
        }
    }

    private class ServerRouterProcessor
    extends AbstractServiceDescriptorsProcessor {
        ServerRouterProcessor() {
            super(ServerSideServices.this.server.getDefaultExecutor());
        }

        @Override
        protected void process(List<RMIServiceDescriptor> descriptors) {
            ServerSideServices.this.server.sendDescriptorsToAllConnections(descriptors);
        }

        public String toString() {
            return "ServerRouterProcessor{" + ((ServerSideServices)ServerSideServices.this).server.endpoint + "}";
        }
    }

    private class ServiceProcessor
    extends AbstractServiceDescriptorsProcessor {
        private final RMIService<?> service;

        private ServiceProcessor(RMIService<?> service) {
            super(ServerSideServices.this.server.getDefaultExecutor());
            this.service = service;
        }

        @Override
        protected void process(List<RMIServiceDescriptor> descriptors) {
            ServerSideServices.this.descriptorsUpdateImpl(this.service, descriptors);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ServiceProcessor)) {
                return false;
            }
            ServiceProcessor other = (ServiceProcessor)obj;
            return other.service.equals(this.service);
        }

        public int hashCode() {
            return this.service.hashCode();
        }

        public String toString() {
            return "ServiceProcessor{" + this.service + "}";
        }
    }
}

