/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.rmi.impl;

import com.devexperts.io.Marshalled;
import com.devexperts.rmi.impl.RMIMessageKind;
import com.devexperts.rmi.message.RMIRequestMessage;
import com.devexperts.rmi.task.RMIServiceId;

class ServerRequestInfo {
    final long reqId;
    final long channelId;
    final RMIRequestMessage<?> message;
    final Marshalled<?> subject;
    final RMIMessageKind kind;
    final boolean retargetedByLoadBalancer;

    ServerRequestInfo(RMIMessageKind kind, long reqId, long channelId, RMIRequestMessage<?> message, Marshalled<?> subject) {
        this(kind, reqId, channelId, message, subject, false);
    }

    private ServerRequestInfo(RMIMessageKind kind, long reqId, long channelId, RMIRequestMessage<?> message, Marshalled<?> subject, boolean retargetedByLoadBalancer) {
        this.reqId = reqId;
        this.channelId = channelId;
        this.subject = subject;
        this.message = message;
        this.kind = kind;
        this.retargetedByLoadBalancer = retargetedByLoadBalancer;
    }

    ServerRequestInfo changeTargetRoute(RMIServiceId newTarget) {
        RMIRequestMessage<?> retargetedMessage = this.message.changeTargetRoute(newTarget, this.message.getRoute());
        return new ServerRequestInfo(this.kind, this.reqId, this.channelId, retargetedMessage, this.subject, true);
    }

    public String toString() {
        return "ServerRequestInfo{reqId=" + this.reqId + ", channelId=" + this.channelId + ", message=" + this.message + ", subject=" + this.subject + ", kind=" + (Object)((Object)this.kind) + ", retargetedByLoadBalancer=" + this.retargetedByLoadBalancer + '}';
    }
}

