/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.rmi.impl;

import com.devexperts.rmi.impl.RMIConnection;
import com.devexperts.rmi.impl.RMIQueueType;
import com.devexperts.rmi.impl.ServiceFilter;
import com.devexperts.rmi.task.RMIServiceDescriptor;
import com.devexperts.rmi.task.RMIServiceId;
import com.devexperts.util.IndexedSet;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
class ServerDescriptorsManager {
    private final RMIConnection connection;
    private volatile ServiceFilter services;
    private final IndexedSet<RMIServiceId, RMIServiceDescriptor> descriptors = IndexedSet.create(RMIServiceDescriptor.INDEXER_BY_SERVICE_ID);

    ServerDescriptorsManager(RMIConnection connection) {
        this.connection = connection;
        this.services = ServiceFilter.NOTHING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setServicesOnDescribeProtocolAndSendAllDescriptors(ServiceFilter services) {
        ServerDescriptorsManager serverDescriptorsManager = this;
        synchronized (serverDescriptorsManager) {
            this.services = services;
        }
        if (this.connection.side.hasServer()) {
            this.connection.endpoint.getServer().sendAllDescriptorsToConnection(this.connection);
        }
    }

    synchronized void addServiceDescriptors(List<RMIServiceDescriptor> descriptors) {
        if (!this.connection.adFilter.isSendAdvertisement()) {
            return;
        }
        boolean changed = false;
        for (RMIServiceDescriptor descriptor : descriptors) {
            if (!this.services.accept(descriptor.getServiceName())) continue;
            if (descriptor.getIntermediateNodes().contains(this.connection.getRemoteEndpointId())) {
                this.descriptors.add(RMIServiceDescriptor.createUnavailableDescriptor(descriptor.getServiceId(), descriptor.getProperties()));
                changed = true;
                continue;
            }
            this.descriptors.add(descriptor);
            changed = true;
        }
        if (changed) {
            this.connection.messageAdapter.rmiMessageAvailable(RMIQueueType.ADVERTISE);
        }
    }

    synchronized List<RMIServiceDescriptor> pollServiceDescriptors() {
        if (this.descriptors.isEmpty()) {
            return null;
        }
        ArrayList<RMIServiceDescriptor> result = new ArrayList<RMIServiceDescriptor>(this.descriptors.size());
        result.addAll(this.descriptors);
        this.descriptors.clear();
        return result;
    }

    synchronized int descriptorsSize() {
        return this.descriptors.size();
    }
}

