/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.rmi.impl;

import com.devexperts.rmi.RMIExceptionType;
import com.devexperts.rmi.impl.RMIChannelImpl;
import com.devexperts.rmi.impl.RMIMessageKind;
import com.devexperts.rmi.impl.RMIRequestImpl;
import com.devexperts.util.IndexedSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
class SentRequests {
    private final IndexedSet<Long, RMIRequestImpl<?>> channelRequests = IndexedSet.createLong(RMIRequestImpl::getId);
    private final Map<Long, IndexedSet<Long, RMIRequestImpl<?>>> clientNestedRequests = new HashMap();
    private final Map<Long, IndexedSet<Long, RMIRequestImpl<?>>> serverNestedRequests = new HashMap();

    SentRequests() {
    }

    synchronized void addSentRequest(RMIRequestImpl<?> request) {
        if (!request.isNestedRequest()) {
            this.channelRequests.add(request);
            return;
        }
        Map<Long, IndexedSet<Long, RMIRequestImpl<?>>> map = request.getKind().hasClient() ? this.clientNestedRequests : this.serverNestedRequests;
        IndexedSet<Long, RMIRequestImpl<?>> set = map.get(request.getChannelId());
        if (set == null) {
            set = IndexedSet.createLong(RMIRequestImpl::getId);
            map.put(request.getChannelId(), set);
        }
        set.add(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RMIRequestImpl<?> removeSentRequest(long channelId, long curRequestId, RMIMessageKind kind) {
        IndexedSet<Long, RMIRequestImpl<?>> set;
        RMIRequestImpl<?> headRequest;
        SentRequests sentRequests = this;
        synchronized (sentRequests) {
            if (channelId != 0L) {
                IndexedSet<Long, RMIRequestImpl<?>> requests = kind.hasClient() ? this.clientNestedRequests.get(channelId) : this.serverNestedRequests.get(channelId);
                RMIRequestImpl<?> result = requests != null ? requests.removeKey(curRequestId) : null;
                return result;
            }
            headRequest = this.channelRequests.removeKey(curRequestId);
            if (headRequest == null) {
                return null;
            }
            set = this.clientNestedRequests.remove(((RMIChannelImpl)headRequest.getChannel()).getChannelId());
        }
        if (set != null && !set.isEmpty()) {
            for (RMIRequestImpl request : set) {
                request.setFailedState(RMIExceptionType.CHANNEL_CLOSED, null);
            }
        }
        return headRequest;
    }

    synchronized RMIRequestImpl<?>[] getSentRequests(RMIRequestImpl<?>[] requests) {
        return this.channelRequests.toArray(requests);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        ArrayList allRequests = new ArrayList();
        SentRequests sentRequests = this;
        synchronized (sentRequests) {
            for (IndexedSet<Long, RMIRequestImpl<?>> requests : this.clientNestedRequests.values()) {
                allRequests.addAll(requests);
            }
            this.clientNestedRequests.clear();
            for (IndexedSet<Long, RMIRequestImpl<?>> requests : this.serverNestedRequests.values()) {
                allRequests.addAll(requests);
            }
            this.serverNestedRequests.clear();
            allRequests.addAll(this.channelRequests);
            this.channelRequests.clear();
        }
        for (RMIRequestImpl request : allRequests) {
            request.setFailedState(RMIExceptionType.DISCONNECTION, null);
        }
    }
}

